/*
 * Decompiled with CFR 0.152.
 */
package workbench.botanianeedsit.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.IManaPool;
import workbench.botanianeedsit.ModBlocks;
import workbench.botanianeedsit.common.block.BlockBase;
import workbench.botanianeedsit.common.lexicon.LexiconIntegration;
import workbench.botanianeedsit.common.tile.TileManaCharger;

public class BlockManaCharger
extends BlockBase
implements ILexiconable {
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.15625, 0.09375, 0.15625, 0.84375, 0.21875, 0.84375);

    public BlockManaCharger(String name) {
        super(name, Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(1.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (!this.checkAndDestroy(worldIn, pos, state)) {
            return true;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileManaCharger) {
            return ((TileManaCharger)tileEntity).handleClick(playerIn, hand);
        }
        return true;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        this.checkAndDestroy((World)world, pos, world.func_180495_p(pos));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileManaCharger) {
            ((TileManaCharger)te).onBlockBreak();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canStay(worldIn, pos);
    }

    protected boolean checkAndDestroy(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.canStay(world, pos)) {
            return true;
        }
        world.func_175698_g(pos);
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(ModBlocks.blockManaCharger, 1));
        return false;
    }

    public boolean canStay(World world, BlockPos pos) {
        return world.func_175625_s(pos.func_177977_b()) instanceof IManaPool;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileManaCharger) {
            return ((TileManaCharger)tileEntity).getComparatorOutput();
        }
        return 0;
    }

    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconIntegration.manaChargerEntry;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileManaCharger();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }
}

