/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.fluidfunnel.block.te.behaviour;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import party.lemons.fluidfunnel.block.te.TileEntityFluidHandlerBase;
import party.lemons.fluidfunnel.block.te.behaviour.IFluidBehaviour;
import party.lemons.fluidfunnel.config.ModConfig;

public class FluidPushItemHandler
implements IFluidBehaviour {
    @Override
    public boolean run(@Nonnull BlockPos pos, @Nonnull World world, @Nonnull TileEntityFluidHandlerBase tileEntity, @Nullable EnumFacing direction) {
        if (direction == null) {
            return false;
        }
        if (!ModConfig.GameplayConfig.fillContainers) {
            return false;
        }
        EnumFacing targetSide = direction.func_176734_d();
        TileEntity targetTe = world.func_175625_s(pos.func_177972_a(direction));
        if (targetTe == null) {
            return false;
        }
        if (!targetTe.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, targetSide)) {
            return false;
        }
        IItemHandler targetHandler = (IItemHandler)targetTe.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, targetSide);
        FluidTank handler = tileEntity.getTank();
        for (int i = 0; i < targetHandler.getSlots(); ++i) {
            ItemStack stack = targetHandler.getStackInSlot(i);
            if (stack.func_190926_b() || !stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && !(stack.func_77973_b() instanceof ItemGlassBottle)) continue;
            if (stack.func_77973_b() instanceof ItemGlassBottle) {
                if (tileEntity.getTank().getFluid().getFluid() != FluidRegistry.WATER || tileEntity.getTank().drain(ModConfig.GameplayConfig.glassBottleSize, false) == null) continue;
                ItemStack newBottle = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
                if (targetHandler.extractItem(i, 1, true).func_190926_b() || !ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)newBottle, (boolean)true).func_190926_b()) continue;
                tileEntity.getTank().drain(ModConfig.GameplayConfig.glassBottleSize, true);
                targetHandler.extractItem(i, 1, false);
                ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)newBottle, (boolean)false);
                continue;
            }
            FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)handler, (int)1000, null, (boolean)false);
            if (!result.isSuccess() || targetHandler.extractItem(i, 1, true).func_190926_b() || !ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)result.getResult(), (boolean)true).func_190926_b()) continue;
            result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)handler, (int)1000, null, (boolean)true);
            targetHandler.extractItem(i, 1, false);
            ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)result.getResult(), (boolean)false);
            tileEntity.setCooldown(tileEntity.getCooldownLength());
            return true;
        }
        return false;
    }
}

