/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.fluidfunnel.block.te;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import party.lemons.fluidfunnel.block.BlockTap;
import party.lemons.fluidfunnel.block.ModBlocks;
import party.lemons.fluidfunnel.block.te.TileEntityFluidHandlerBase;
import party.lemons.fluidfunnel.block.te.behaviour.IFluidBehaviour;
import party.lemons.fluidfunnel.block.te.tank.FluidTankTileTap;
import party.lemons.fluidfunnel.config.ModConfig;

public class TileEntityTap
extends TileEntityFluidHandlerBase
implements ITickable {
    private int transferCooldown = -1;
    public static List<IFluidBehaviour> outputBehaviour = new ArrayList<IFluidBehaviour>();
    public static List<IFluidBehaviour> inputBehaviour = new ArrayList<IFluidBehaviour>();

    public TileEntityTap() {
        this.tank = new FluidTankTileTap(this, ModConfig.GameplayConfig.tapCapacity);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                if (!this.transferOut()) {
                    this.takeIn();
                }
            }
            this.func_70296_d();
        }
    }

    public boolean takeIn() {
        IBlockState offsetState;
        if (this.isFull()) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockTap.FACING);
        if (!(this.field_145850_b.func_175623_d(this.field_174879_c.func_177972_a(facing)) || (offsetState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing))).func_177230_c() != ModBlocks.tap && offsetState.func_177230_c() != ModBlocks.funnel)) {
            return false;
        }
        for (IFluidBehaviour b : inputBehaviour) {
            if (!b.run(this.field_174879_c, this.field_145850_b, this, facing)) continue;
            return true;
        }
        return false;
    }

    public boolean transferOut() {
        if (this.isEmpty()) {
            return false;
        }
        for (IFluidBehaviour b : outputBehaviour) {
            if (!b.run(this.field_174879_c, this.field_145850_b, this, EnumFacing.DOWN)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.setTransferCooldown(cooldown);
    }

    @Override
    public int getMaxTransferRate() {
        return ModConfig.GameplayConfig.tapTransferMax;
    }

    @Override
    public int getCooldownLength() {
        return ModConfig.GameplayConfig.tapCooldown;
    }

    private void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177229_b((IProperty)BlockTap.FACING) == facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177229_b((IProperty)BlockTap.FACING) == facing & capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }
}

