/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.fluidfunnel.block.te;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import party.lemons.fluidfunnel.block.BlockFunnel;
import party.lemons.fluidfunnel.block.te.TileEntityFluidHandlerBase;
import party.lemons.fluidfunnel.block.te.behaviour.IFluidBehaviour;
import party.lemons.fluidfunnel.block.te.tank.FluidTankTile;
import party.lemons.fluidfunnel.config.ModConfig;

public class TileEntityFunnel
extends TileEntityFluidHandlerBase
implements ITickable {
    public static List<IFluidBehaviour> outputBehaviour = new ArrayList<IFluidBehaviour>();
    public static List<IFluidBehaviour> inputBehaviour = new ArrayList<IFluidBehaviour>();
    private int transferCooldown = -1;

    public TileEntityFunnel() {
        this.tank = new FluidTankTile(this, ModConfig.GameplayConfig.funnelCapacity);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && BlockFunnel.isEnabled(this.func_145832_p())) {
            --this.transferCooldown;
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                if (!this.transferOut()) {
                    this.takeIn();
                }
            }
            this.func_70296_d();
        }
    }

    private void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean takeIn() {
        if (this.isFull()) {
            return false;
        }
        for (IFluidBehaviour b : inputBehaviour) {
            if (!b.run(this.field_174879_c, this.field_145850_b, this, EnumFacing.UP)) continue;
            return true;
        }
        return false;
    }

    public boolean transferOut() {
        if (this.isEmpty()) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockFunnel.FACING);
        for (IFluidBehaviour b : outputBehaviour) {
            if (!b.run(this.field_174879_c, this.field_145850_b, this, facing)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.setTransferCooldown(cooldown);
    }

    @Override
    public int getMaxTransferRate() {
        return ModConfig.GameplayConfig.funnelTransferMax;
    }

    @Override
    public int getCooldownLength() {
        return ModConfig.GameplayConfig.funnelCooldown;
    }
}

