/*
 * Decompiled with CFR 0.152.
 */
package moxlotus.minecraft;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.InvalidBlockStateException;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="generate", name="Generate", version="1.0", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public final class Generate {
    public static final String MODID = "generate";
    public static final String NAME = "Generate";
    public static final String VERSION = "1.0";
    private static final List<ConfigEntry> list = new LinkedList<ConfigEntry>();
    private static Configuration config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        String[] cobblestone = new String[]{"16 minecraft:cobblestone", " 4 minecraft:stone variant=andesite", " 2 minecraft:stone variant=diorite", " 1 minecraft:stone variant=granite"};
        String[] stone = new String[]{"16384 minecraft:stone", " 1024 minecraft:coal_ore", "  256 minecraft:iron_ore", "   64 minecraft:redstone_ore", "   32 minecraft:lapis_ore", "   8  minecraft:gold_ore", "    1 minecraft:diamond_ore"};
        String[] obsidian = new String[]{"1 minecraft:obsidian"};
        config.load();
        list.add(new ConfigEntry(Blocks.field_150347_e, cobblestone));
        list.add(new ConfigEntry(Blocks.field_150348_b, stone));
        list.add(new ConfigEntry(Blocks.field_150343_Z, obsidian));
        config.save();
    }

    @SubscribeEvent
    public static void onFluidPlaceBlockEvent(BlockEvent.FluidPlaceBlockEvent event) {
        for (ConfigEntry entry : list) {
            if (event.getNewState().func_177230_c() != entry.toReplace) continue;
            event.setNewState(entry.getNewBlock());
            return;
        }
    }

    private class ConfigEntry {
        final Block toReplace;
        final int totalWeight;
        final Collection<Pair> pairs;

        ConfigEntry(Block toReplace, String ... defaults) {
            this.toReplace = toReplace;
            String[] strings = config.get("Replacements", toReplace.toString(), defaults).getStringList();
            this.pairs = new PriorityQueue<Pair>(Collections.reverseOrder(Comparator.comparingInt(Pair::getWeight)));
            int totalWeight = 0;
            for (String string : strings) {
                String s = string.trim();
                String[] split = s.split("\\s+");
                if (split.length < 2) continue;
                int weight = Integer.parseInt(split[0]);
                Block block = Block.func_149684_b((String)split[1]);
                if (block == null) continue;
                IBlockState state = null;
                if (split.length >= 3) {
                    try {
                        state = CommandBase.func_190794_a((Block)block, (String)split[2]);
                    }
                    catch (InvalidBlockStateException | NumberInvalidException throwable) {
                        // empty catch block
                    }
                }
                if (state == null) {
                    state = block.func_176223_P();
                }
                this.pairs.add(new Pair(state, weight));
                totalWeight += weight;
            }
            this.totalWeight = totalWeight;
        }

        private IBlockState getNewBlock() {
            int i = new Random().nextInt(this.totalWeight) + 1;
            int currentWeight = 0;
            for (Pair p : this.pairs) {
                if ((currentWeight += p.getWeight()) < i) continue;
                return p.getState();
            }
            throw new Error("This should never happen.");
        }

        private class Pair {
            private final IBlockState state;
            private final int weight;

            Pair(IBlockState state, int weight) {
                this.state = state;
                this.weight = weight;
            }

            public int getWeight() {
                return this.weight;
            }

            public IBlockState getState() {
                return this.state;
            }
        }
    }
}

