/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.init;

import com.mrbysco.slabmachines.blocks.BlockChestSlab;
import com.mrbysco.slabmachines.blocks.BlockFurnaceSlab;
import com.mrbysco.slabmachines.blocks.BlockNoteblockSlab;
import com.mrbysco.slabmachines.blocks.BlockTNTSlab;
import com.mrbysco.slabmachines.blocks.BlockTrappedChestSlab;
import com.mrbysco.slabmachines.blocks.BlockWorkbenchSlab;
import com.mrbysco.slabmachines.blocks.compat.tinkers.BlockCraftingStationSlab;
import com.mrbysco.slabmachines.blocks.compat.tinkers.BlockPartBuilderSlab;
import com.mrbysco.slabmachines.blocks.compat.tinkers.BlockPartChestSlab;
import com.mrbysco.slabmachines.blocks.compat.tinkers.BlockPatternChestSlab;
import com.mrbysco.slabmachines.blocks.compat.tinkers.BlockStencilTableSlab;
import com.mrbysco.slabmachines.blocks.compat.tinkers.BlockToolForgeSlab;
import com.mrbysco.slabmachines.blocks.compat.tinkers.BlockToolStationSlab;
import com.mrbysco.slabmachines.init.SlabItems;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class SlabBlocks {
    public static BlockSlab workbenchSlab;
    public static BlockSlab furnaceSlab;
    public static BlockSlab chestSlab;
    public static BlockSlab trappedChestSlab;
    public static BlockSlab noteSlab;
    public static BlockSlab tntSlab;
    public static BlockSlab craftingStationSlab;
    public static BlockSlab partBuilderSlab;
    public static BlockSlab partChestSlab;
    public static BlockSlab patternChestSlab;
    public static BlockSlab stencilTableSlab;
    public static BlockSlab toolForgeSlab;
    public static BlockSlab toolStationSlab;
    public static ArrayList<Block> BLOCKS;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        workbenchSlab = SlabBlocks.registerBlock(new BlockWorkbenchSlab());
        furnaceSlab = SlabBlocks.registerBlock(new BlockFurnaceSlab());
        chestSlab = SlabBlocks.registerBlock(new BlockChestSlab());
        trappedChestSlab = SlabBlocks.registerBlock(new BlockTrappedChestSlab());
        noteSlab = SlabBlocks.registerBlock(new BlockNoteblockSlab());
        tntSlab = SlabBlocks.registerBlock(new BlockTNTSlab());
        if (Loader.isModLoaded((String)"tconstruct")) {
            SlabBlocks.registerTinkers();
        }
        registry.registerAll((IForgeRegistryEntry[])BLOCKS.toArray(new Block[0]));
    }

    @Optional.Method(modid="tconstruct")
    public static void registerTinkers() {
        craftingStationSlab = SlabBlocks.registerBlock(new BlockCraftingStationSlab());
        partBuilderSlab = SlabBlocks.registerBlock(new BlockPartBuilderSlab());
        partChestSlab = SlabBlocks.registerBlock(new BlockPartChestSlab());
        patternChestSlab = SlabBlocks.registerBlock(new BlockPatternChestSlab());
        stencilTableSlab = SlabBlocks.registerBlock(new BlockStencilTableSlab());
        toolForgeSlab = SlabBlocks.registerBlock(new BlockToolForgeSlab());
        toolStationSlab = SlabBlocks.registerBlock(new BlockToolStationSlab());
    }

    public static <T extends Block> T registerBlock(T block) {
        return SlabBlocks.registerBlock(block, new ItemBlock(block));
    }

    public static <T extends Block> T registerBlock(T block, ItemBlock item) {
        item.setRegistryName(block.getRegistryName());
        SlabItems.ITEMS.add((Item)item);
        BLOCKS.add(block);
        return block;
    }

    static {
        BLOCKS = new ArrayList();
    }
}

