/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.blocks;

import com.google.common.base.Predicate;
import com.mrbysco.slabmachines.SlabMachines;
import com.mrbysco.slabmachines.tileentity.TileChestSlab;
import com.mrbysco.slabmachines.utils.SlabUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTrappedChestSlab
extends BlockSlab {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    private static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockTrappedChestSlab() {
        super(Material.field_151575_d);
        this.func_149663_c("slabmachines:" + "trapped_chest_slab".replaceAll("_", ""));
        this.setRegistryName("trapped_chest_slab");
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.field_149783_u = true;
        this.func_149647_a(SlabMachines.slabTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT)).func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setHarvestLevel("axe", 0);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public boolean func_176552_j() {
        return false;
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return Variant.DEFAULT;
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
        if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.field_82609_l[meta & 7];
        if (!EnumFacing.Plane.HORIZONTAL.apply(facing)) {
            facing = EnumFacing.NORTH;
        }
        boolean top = meta >> 3 == 1;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)field_176554_a, (Comparable)(top ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, field_176554_a, FACING});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        int id = state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 4 : 5;
        playerIn.openGui((Object)SlabMachines.instance, id, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        playerIn.func_71029_a(StatList.field_188089_W);
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileChestSlab te;
        if (!worldIn.field_72995_K && (te = SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a), TileChestSlab.class)) != null) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)te);
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileChestSlab();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)SlabUtil.getTileSlab((IBlockAccess)worldIn, pos, (BlockSlab.EnumBlockHalf)blockState.func_177229_b((IProperty)BlockSlab.field_176554_a), TileChestSlab.class));
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!blockState.func_185897_m()) {
            return 0;
        }
        int i = 0;
        TileChestSlab te = SlabUtil.getTileSlab(blockAccess, pos, (BlockSlab.EnumBlockHalf)blockState.func_177229_b((IProperty)BlockSlab.field_176554_a), TileChestSlab.class);
        if (te != null) {
            i = te.numPlayersUsing;
        }
        return MathHelper.func_76125_a((int)i, (int)0, (int)15);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? blockState.func_185911_a(blockAccess, pos, side) : 0;
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String func_176610_l() {
            return "default";
        }
    }
}

