/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.crafting;

import com.blakebr0.pickletweaks.PickleTweaks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class GridRepairOverride {
    public static final String[] DEFAULT_VALUES = new String[]{"minecraft:wooden_hoe=ore:plankWood", "minecraft:stone_hoe=minecraft:cobblestone", "minecraft:iron_hoe=minecraft:iron_ingot", "minecraft:golden_hoe=minecraft:gold_ingot", "minecraft:diamond_hoe=minecraft:diamond"};
    public static List<Override> overrides = new ArrayList<Override>();

    public static void configure(Configuration config) {
        ConfigCategory category = config.getCategory("grid_repair");
        String[] values = config.get(category.getName(), "_repair_materials", DEFAULT_VALUES).getStringList();
        category.get("_repair_materials").setComment("Here you can add your own repair materials to tools.\n- Syntax: (tool=material) modid:itemid=modid:itemid:meta\n- Example: minecraft:stone_pickaxe=minecraft:apple:0\n- Note: the tool doesn't have a meta. If no meta is put for the material it will automatically become 0.\n- You can also use the OreDictionary for repair materials.\n- Example: ore:ingotIron would make all items in ingotIron a valid material.\n- Note: additions using OreDictionary seem to require a restart.\n- You can also specify an effectiveness multiplier by adding @<multiplier> to the repair material.\n- Example: adding @0.5 after the repair material would make that material only 50 percent effective.");
        for (String value : values) {
            ItemStack mat;
            String[] parts = value.split("=");
            if (parts.length != 2) {
                PickleTweaks.LOGGER.error("Invalid repair material syntax: {}", (Object)value);
                continue;
            }
            double multi = 1.0;
            String[] toolName = parts[0].split(":");
            if (toolName.length != 2) {
                PickleTweaks.LOGGER.error("Invalid repair material syntax: {}", (Object)value);
                continue;
            }
            Item toolItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(toolName[0], toolName[1]));
            if (toolItem == null) {
                PickleTweaks.LOGGER.error("Invalid repair material syntax, tool item is null: {}", (Object)value);
                continue;
            }
            ItemStack tool = new ItemStack(toolItem);
            String[] matName = parts[1].split(":");
            if (matName.length == 3) {
                int meta;
                block19: {
                    if (matName[2].contains("@")) {
                        String[] metaThings = matName[2].split("@");
                        try {
                            meta = Integer.valueOf(metaThings[0]);
                            multi = Double.valueOf(metaThings[1]);
                            break block19;
                        }
                        catch (NumberFormatException e) {
                            PickleTweaks.LOGGER.error("Invalid repair material syntax metadata and mutliplier: {}", (Object)value);
                            continue;
                        }
                    }
                    try {
                        meta = Integer.valueOf(matName[2]);
                    }
                    catch (NumberFormatException e) {
                        PickleTweaks.LOGGER.error("Invalid repair material syntax metadata: {}", (Object)value);
                        continue;
                    }
                }
                Item matItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(matName[0], matName[1]));
                if (matItem == null) {
                    PickleTweaks.LOGGER.error("Invalid repair material syntax, material item is null: {}", (Object)value);
                    continue;
                }
                mat = new ItemStack(matItem, 1, meta);
            } else if (matName.length == 2) {
                if (parts[1].startsWith("ore:")) {
                    String ore = parts[1].substring(4);
                    if (ore.contains("@")) {
                        String[] metaParts = ore.split("@");
                        try {
                            multi = Double.valueOf(metaParts[1]);
                        }
                        catch (NumberFormatException e) {
                            PickleTweaks.LOGGER.error("Invalid repair material syntax mutliplier: {}", (Object)value);
                            continue;
                        }
                        overrides.add(new Override(tool, metaParts[0], multi));
                        continue;
                    }
                    overrides.add(new Override(tool, ore));
                    continue;
                }
                Item matItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(matName[0], matName[1]));
                if (matItem == null) {
                    PickleTweaks.LOGGER.error("Invalid repair material syntax, material item is null: {}", (Object)value);
                    continue;
                }
                mat = new ItemStack(matItem);
            } else {
                PickleTweaks.LOGGER.error("Invalid repair material syntax, material item is invalid: {}", (Object)value);
                continue;
            }
            overrides.add(new Override(tool, mat, multi));
        }
    }

    public static Override getOverride(ItemStack tool, ItemStack mat) {
        for (Override entry : overrides) {
            String ore;
            if (!entry.tool.func_185136_b(tool)) continue;
            if (entry.mat instanceof ItemStack) {
                ItemStack stack = (ItemStack)entry.mat;
                if (!stack.func_77969_a(mat)) continue;
                return entry;
            }
            if (!(entry.mat instanceof String) || !OreDictionary.doesOreNameExist((String)(ore = (String)entry.mat)) || !OreDictionary.getOres((String)ore).stream().anyMatch(is -> is.func_77960_j() == Short.MAX_VALUE && is.func_77973_b() == mat.func_77973_b() || is.func_77969_a(mat))) continue;
            return entry;
        }
        return null;
    }

    public static boolean hasToolOverride(ItemStack tool) {
        return overrides.stream().anyMatch(o -> o.tool.func_185136_b(tool));
    }

    public static class Override {
        public ItemStack tool;
        public Object mat;
        public double multi;

        public Override(ItemStack tool, Object mat) {
            this(tool, mat, 1.0);
        }

        public Override(ItemStack tool, Object mat, double multi) {
            this.tool = tool;
            this.mat = mat;
            this.multi = multi;
        }
    }
}

