/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.gui.container.SlottedChestContainer;
import com.Da_Technomancer.essentials.packets.EssentialsPackets;
import com.Da_Technomancer.essentials.packets.SendSlotFilterToClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SlottedChestTileEntity
extends TileEntity {
    private ItemStack[] inv = new ItemStack[54];
    public ItemStack[] lockedInv = new ItemStack[54];
    public final IInventory iInv = new Inventory();
    private final InventoryHandler handler = new InventoryHandler();

    public SlottedChestTileEntity() {
        for (int i = 0; i < 54; ++i) {
            this.inv[i] = ItemStack.field_190927_a;
            this.lockedInv[i] = ItemStack.field_190927_a;
        }
    }

    public void filterChanged() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        NBTTagCompound slotNBT = new NBTTagCompound();
        for (int i = 0; i < 54; ++i) {
            if (this.lockedInv[i].func_190926_b()) continue;
            slotNBT.func_74782_a("lock" + i, (NBTBase)this.lockedInv[i].func_77955_b(new NBTTagCompound()));
        }
        EssentialsPackets.network.sendToAllAround((IMessage)new SendSlotFilterToClient(slotNBT, this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 54; ++i) {
            if (nbt.func_74764_b("slot" + i)) {
                this.inv[i] = new ItemStack(nbt.func_74775_l("slot" + i));
                this.lockedInv[i] = new ItemStack(nbt.func_74775_l("slot" + i));
            }
            if (!nbt.func_74764_b("lockSlot" + i)) continue;
            this.lockedInv[i] = new ItemStack(nbt.func_74775_l("lockSlot" + i));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < 54; ++i) {
            if (!this.inv[i].func_190926_b()) {
                nbt.func_74782_a("slot" + i, (NBTBase)this.inv[i].func_77955_b(new NBTTagCompound()));
            }
            if (this.lockedInv[i].func_190926_b()) continue;
            nbt.func_74782_a("lockSlot" + i, (NBTBase)this.lockedInv[i].func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        for (int i = 0; i < 54; ++i) {
            if (this.lockedInv[i].func_190926_b()) continue;
            nbt.func_74782_a("lockSlot" + i, (NBTBase)this.lockedInv[i].func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    public void cleanPreset(int slot) {
        if (slot < 54 && this.inv[slot].func_190926_b()) {
            this.lockedInv[slot] = ItemStack.field_190927_a;
        }
        this.filterChanged();
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(cap, facing);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(cap, facing);
    }

    public boolean isInventoryType(IInventory inv) {
        return inv instanceof Inventory;
    }

    private class Inventory
    implements IInventory {
        private Inventory() {
        }

        public String func_70005_c_() {
            return "container.slotted_chest";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return 54;
        }

        public ItemStack func_70301_a(int index) {
            return index >= 54 ? ItemStack.field_190927_a : SlottedChestTileEntity.this.inv[index];
        }

        public ItemStack func_70298_a(int index, int count) {
            if (index >= 54 || SlottedChestTileEntity.this.inv[index].func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = SlottedChestTileEntity.this.inv[index].func_77979_a(count);
            return stack;
        }

        public ItemStack func_70304_b(int index) {
            if (index >= 54) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = SlottedChestTileEntity.this.inv[index].func_77946_l();
            SlottedChestTileEntity.this.inv[index].func_190920_e(0);
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (index < 54) {
                ((SlottedChestTileEntity)SlottedChestTileEntity.this).inv[index] = stack;
                if (!stack.func_190926_b()) {
                    SlottedChestTileEntity.this.lockedInv[index] = stack.func_77946_l();
                    SlottedChestTileEntity.this.lockedInv[index].func_190920_e(1);
                }
            }
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            SlottedChestTileEntity.this.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return SlottedChestTileEntity.this.field_145850_b.func_175625_s(SlottedChestTileEntity.this.field_174879_c) == SlottedChestTileEntity.this && player.func_174818_b(SlottedChestTileEntity.this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
        }

        public void func_174889_b(EntityPlayer player) {
            SlottedChestTileEntity.this.filterChanged();
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index < 54 && (SlottedChestTileEntity.this.inv[index].func_190926_b() ? SlottedChestTileEntity.this.lockedInv[index].func_190926_b() || SlottedChestContainer.doStackContentsMatch(stack, SlottedChestTileEntity.this.lockedInv[index]) : SlottedChestContainer.doStackContentsMatch(stack, SlottedChestTileEntity.this.inv[index]));
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
            for (int i = 0; i < 54; ++i) {
                ((SlottedChestTileEntity)SlottedChestTileEntity.this).inv[i] = ItemStack.field_190927_a;
                SlottedChestTileEntity.this.lockedInv[i] = ItemStack.field_190927_a;
            }
            SlottedChestTileEntity.this.filterChanged();
        }

        public boolean func_191420_l() {
            for (int i = 0; i < 54; ++i) {
                if (SlottedChestTileEntity.this.inv[i].func_190926_b()) continue;
                return false;
            }
            return true;
        }
    }

    private class InventoryHandler
    implements IItemHandler {
        private InventoryHandler() {
        }

        public int getSlots() {
            return 54;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < 54 ? SlottedChestTileEntity.this.inv[slot] : ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot >= 54 || stack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)SlottedChestTileEntity.this.lockedInv[slot])) {
                return stack;
            }
            int change = Math.min(stack.func_77976_d() - SlottedChestTileEntity.this.inv[slot].func_190916_E(), stack.func_190916_E());
            if (!simulate) {
                if (SlottedChestTileEntity.this.inv[slot].func_190926_b()) {
                    ((SlottedChestTileEntity)SlottedChestTileEntity.this).inv[slot] = stack.func_77946_l();
                } else {
                    SlottedChestTileEntity.this.inv[slot].func_190917_f(change);
                }
            }
            ItemStack out = stack.func_77946_l();
            out.func_190918_g(change);
            return stack.func_190916_E() == change ? ItemStack.field_190927_a : out;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= 54 || SlottedChestTileEntity.this.inv[slot].func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int change = Math.min(SlottedChestTileEntity.this.inv[slot].func_190916_E(), amount);
            ItemStack out = SlottedChestTileEntity.this.inv[slot].func_77946_l();
            out.func_190920_e(change);
            if (!simulate) {
                SlottedChestTileEntity.this.inv[slot].func_190918_g(change);
            }
            return change == 0 ? ItemStack.field_190927_a : out;
        }

        public int getSlotLimit(int slot) {
            return slot < 54 ? 64 : 0;
        }
    }
}

