/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import com.Da_Technomancer.essentials.items.crafting.EssentialsCrafting;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class BrazierTileEntity
extends TileEntity
implements ITickable {
    private final FuelHandler fuelHandler = new FuelHandler();

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            WorldServer server = (WorldServer)this.field_145850_b;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() != EssentialsBlocks.brazier) {
                this.func_145843_s();
                return;
            }
            switch ((Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS)) {
                case 2: {
                    server.func_180505_a(EnumParticleTypes.LAVA, false, (double)this.field_174879_c.func_177958_n() + 0.25 + 0.5 * Math.random(), (double)(this.field_174879_c.func_177956_o() + 1) + Math.random() * 0.25, (double)this.field_174879_c.func_177952_p() + 0.25 + 0.5 * Math.random(), 3, 0.0, 0.0, 0.0, 0.01, new int[0]);
                    break;
                }
                case 3: {
                    server.func_180505_a(EnumParticleTypes.FLAME, false, (double)this.field_174879_c.func_177958_n() + 0.25 + 0.5 * Math.random(), (double)(this.field_174879_c.func_177956_o() + 1) + Math.random() * 0.25, (double)this.field_174879_c.func_177952_p() + 0.25 + 0.5 * Math.random(), 3, 0.0, 0.0, 0.0, 0.01, new int[0]);
                    break;
                }
                case 6: {
                    server.func_180505_a(EnumParticleTypes.REDSTONE, false, (double)this.field_174879_c.func_177958_n() + 0.25 + 0.5 * Math.random(), (double)(this.field_174879_c.func_177956_o() + 1) + Math.random() * 0.25, (double)this.field_174879_c.func_177952_p() + 0.25 + 0.5 * Math.random(), 0, -1.0, 0.5, 1.0, 0.01, new int[0]);
                    break;
                }
                case 7: {
                    server.func_180505_a(EnumParticleTypes.SPELL_MOB, false, (double)this.field_174879_c.func_177958_n() + 0.25 + 0.5 * Math.random(), (double)(this.field_174879_c.func_177956_o() + 1) + Math.random() * 0.25, (double)this.field_174879_c.func_177952_p() + 0.25 + 0.5 * Math.random(), 1, 0.0, 0.0, 0.0, 0.01, new int[0]);
                    ItemStack out = BrazierTileEntity.recipeMatch((ArrayList)this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(1, 1, 1)), EntitySelectors.field_94557_a));
                    if (out.func_190926_b()) break;
                    for (EntityItem item : this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(1, 1, 1)), EntitySelectors.field_94557_a)) {
                        item.func_70106_y();
                    }
                    server.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, false);
                    EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), out.func_77946_l());
                    item.func_184224_h(true);
                    this.field_145850_b.func_72838_d((Entity)item);
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                }
            }
        }
    }

    public ItemStack useItem(ItemStack stack) {
        int type = (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS);
        ItemStack out = stack;
        if (type == 0) {
            int tar = 0;
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
                tar = 3;
                out = stack.func_77946_l();
                out.func_190918_g(1);
            } else if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150426_aN)) {
                tar = 4;
                out = stack.func_77946_l();
                out.func_190918_g(1);
            } else if (stack.func_77973_b() == Items.field_151170_bI) {
                tar = 7;
                out = stack.func_77946_l();
                out.func_190918_g(1);
            } else if (!stack.func_190926_b()) {
                int[] ids;
                for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                    if (!"blockSalt".equals(OreDictionary.getOreName((int)id))) continue;
                    tar = 6;
                    out = stack.func_77946_l();
                    out.func_190918_g(1);
                    break;
                }
            }
            if (tar == 0 && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                FluidStack drained = handler.drain(new FluidStack(FluidRegistry.WATER, 1000), false);
                if (drained != null && drained.amount == 1000) {
                    handler.drain(new FluidStack(FluidRegistry.WATER, 1000), true);
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(1)));
                    return handler.getContainer();
                }
                drained = handler.drain(new FluidStack(FluidRegistry.LAVA, 1000), false);
                if (drained != null && drained.amount == 1000) {
                    handler.drain(new FluidStack(FluidRegistry.LAVA, 1000), true);
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(2)));
                    return handler.getContainer();
                }
            }
            if (tar != 0) {
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(tar)));
                return out;
            }
        } else {
            switch (type) {
                case 1: {
                    IFluidHandlerItem handler;
                    if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || (handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).fill(new FluidStack(FluidRegistry.WATER, 1000), false) != 1000) break;
                    handler.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                    return handler.getContainer();
                }
                case 2: {
                    IFluidHandlerItem handler;
                    if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || (handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).fill(new FluidStack(FluidRegistry.LAVA, 1000), false) != 1000) break;
                    handler.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                    return handler.getContainer();
                }
                case 3: {
                    if (!stack.func_190926_b()) break;
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                    return new ItemStack(Blocks.field_150402_ci);
                }
                case 4: {
                    if (!stack.func_190926_b()) break;
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                    return new ItemStack(Blocks.field_150426_aN);
                }
                case 6: {
                    NonNullList saltBlocks = OreDictionary.getOres((String)"blockSalt");
                    if (saltBlocks.isEmpty()) {
                        return ItemStack.field_190927_a;
                    }
                    if (!stack.func_190926_b()) break;
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                    return (ItemStack)saltBlocks.get(0);
                }
                case 7: {
                    if (!stack.func_190926_b()) break;
                    this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                    return new ItemStack(Items.field_151170_bI);
                }
                default: {
                    return ItemStack.field_190927_a;
                }
            }
        }
        return stack;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(cap, side);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.fuelHandler;
        }
        return (T)super.getCapability(cap, side);
    }

    @Nonnull
    private static ItemStack recipeMatch(ArrayList<EntityItem> itemEnt) {
        if (itemEnt == null) {
            return ItemStack.field_190927_a;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (EntityItem entityItem : itemEnt) {
            if (entityItem.func_92059_d().func_190926_b() || entityItem.func_92059_d().func_190916_E() != 1) {
                return ItemStack.field_190927_a;
            }
            items.add(entityItem.func_92059_d());
        }
        if (items.size() != 3) {
            return ItemStack.field_190927_a;
        }
        for (Pair pair : EssentialsCrafting.brazierBoboRecipes) {
            ArrayList itemCop = new ArrayList(items);
            for (Predicate cStack : (Predicate[])pair.getLeft()) {
                for (ItemStack stack : items) {
                    if (!itemCop.contains(stack) || !cStack.test(stack)) continue;
                    itemCop.remove(stack);
                    break;
                }
                if (itemCop.size() != 0) continue;
                return (ItemStack)pair.getRight();
            }
        }
        return ItemStack.field_190927_a;
    }

    private class FuelHandler
    implements IItemHandler {
        private FuelHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot != 0) {
                return ItemStack.field_190927_a;
            }
            switch ((Integer)BrazierTileEntity.this.field_145850_b.func_180495_p(BrazierTileEntity.this.field_174879_c).func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS)) {
                case 3: {
                    return new ItemStack(Blocks.field_150402_ci);
                }
                case 4: {
                    return new ItemStack(Blocks.field_150426_aN);
                }
                case 6: {
                    NonNullList saltBlocks = OreDictionary.getOres((String)"blockSalt");
                    if (saltBlocks.isEmpty()) {
                        return ItemStack.field_190927_a;
                    }
                    return (ItemStack)saltBlocks.get(0);
                }
                case 7: {
                    return new ItemStack(Items.field_151170_bI);
                }
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 0 && (Integer)BrazierTileEntity.this.field_145850_b.func_180495_p(BrazierTileEntity.this.field_174879_c).func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS) == 0) {
                int tar = 0;
                if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
                    tar = 3;
                } else if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150426_aN)) {
                    tar = 4;
                } else if (stack.func_77973_b() == Items.field_151170_bI) {
                    tar = 7;
                } else {
                    int[] ids;
                    for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                        if (!"blockSalt".equals(OreDictionary.getOreName((int)id))) continue;
                        tar = 6;
                        break;
                    }
                }
                if (tar != 0) {
                    if (!simulate) {
                        BrazierTileEntity.this.field_145850_b.func_175656_a(BrazierTileEntity.this.field_174879_c, BrazierTileEntity.this.field_145850_b.func_180495_p(BrazierTileEntity.this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(tar)));
                    }
                    ItemStack out = stack.func_77946_l();
                    out.func_190918_g(1);
                    return out;
                }
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                ItemStack out = this.getStackInSlot(0);
                if (!simulate) {
                    BrazierTileEntity.this.field_145850_b.func_175656_a(BrazierTileEntity.this.field_174879_c, BrazierTileEntity.this.field_145850_b.func_180495_p(BrazierTileEntity.this.field_174879_c).func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
                }
                return out;
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? 1 : 0;
        }
    }
}

