/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.packets;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;

public class Message<REQ extends Message>
implements Serializable,
IMessage,
IMessageHandler<REQ, IMessage> {
    private static final HashMap<Class, Pair<Reader, Writer>> handlers = new HashMap();
    private static final HashMap<Class, Field[]> fieldCache = new HashMap();

    public IMessage handleMessage(MessageContext context) {
        return null;
    }

    public final IMessage onMessage(REQ message, MessageContext context) {
        return ((Message)message).handleMessage(context);
    }

    public final void fromBytes(ByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = Message.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!Message.acceptField(f, type)) continue;
                this.readField(f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading packet " + this, e);
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = Message.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!Message.acceptField(f, type)) continue;
                this.writeField(f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing packet " + this, e);
        }
    }

    private static Field[] getClassFields(Class<?> clazz) {
        if (fieldCache.containsValue(clazz)) {
            return fieldCache.get(clazz);
        }
        Field[] fields = clazz.getFields();
        Arrays.sort(fields, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        fieldCache.put(clazz, fields);
        return fields;
    }

    private final void writeField(Field f, Class clazz, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = Message.getHandler(clazz);
        ((Writer)handler.getRight()).write(f.get(this), buf);
    }

    private final void readField(Field f, Class clazz, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = Message.getHandler(clazz);
        f.set(this, ((Reader)handler.getLeft()).read(buf));
    }

    private static Pair<Reader, Writer> getHandler(Class<?> clazz) {
        Pair<Reader, Writer> pair = handlers.get(clazz);
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return pair;
    }

    private static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        return handlers.containsKey(type);
    }

    private static <T> void map(Class<T> type, Reader<T> reader, Writer<T> writer) {
        handlers.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    private static byte readByte(ByteBuf buf) {
        return buf.readByte();
    }

    private static void writeByte(byte b, ByteBuf buf) {
        buf.writeByte((int)b);
    }

    private static int readInt(ByteBuf buf) {
        return buf.readInt();
    }

    private static void writeInt(int i, ByteBuf buf) {
        buf.writeInt(i);
    }

    private static long readLong(ByteBuf buf) {
        return buf.readLong();
    }

    private static void writeLong(long l, ByteBuf buf) {
        buf.writeLong(l);
    }

    private static float readFloat(ByteBuf buf) {
        return buf.readFloat();
    }

    private static void writeFloat(float f, ByteBuf buf) {
        buf.writeFloat(f);
    }

    private static double readDouble(ByteBuf buf) {
        return buf.readDouble();
    }

    private static void writeDouble(double d, ByteBuf buf) {
        buf.writeDouble(d);
    }

    private static boolean readBoolean(ByteBuf buf) {
        return buf.readBoolean();
    }

    private static void writeBoolean(boolean b, ByteBuf buf) {
        buf.writeBoolean(b);
    }

    private static UUID readUUID(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    private static void writeUUID(UUID id, ByteBuf buf) {
        buf.writeLong(id.getMostSignificantBits());
        buf.writeLong(id.getLeastSignificantBits());
    }

    private static byte[][] readByte2DArray(ByteBuf buf) {
        int outerSize = buf.readInt();
        int innerSize = buf.readInt();
        byte[][] out = new byte[outerSize][innerSize];
        for (int i = 0; i < outerSize; ++i) {
            for (int j = 0; j < innerSize; ++j) {
                out[i][j] = buf.readByte();
            }
        }
        return out;
    }

    private static void writeByte2DArray(byte[][] bytes, ByteBuf buf) {
        buf.writeInt(bytes.length);
        buf.writeInt(bytes[0].length);
        for (byte[] inner : bytes) {
            buf.writeBytes(inner);
        }
    }

    private static int[] readIntArray(ByteBuf buf) {
        int size = buf.readInt();
        int[] out = new int[size];
        for (int i = 0; i < size; ++i) {
            out[i] = buf.readInt();
        }
        return out;
    }

    private static void writeIntArray(int[] ints, ByteBuf buf) {
        buf.writeInt(ints.length);
        for (int inner : ints) {
            buf.writeInt(inner);
        }
    }

    private static double[] readDoubleArray(ByteBuf buf) {
        int size = buf.readInt();
        double[] out = new double[size];
        for (int i = 0; i < size; ++i) {
            out[i] = buf.readDouble();
        }
        return out;
    }

    private static void writeDoubleArray(double[] doubles, ByteBuf buf) {
        buf.writeInt(doubles.length);
        for (double inner : doubles) {
            buf.writeDouble(inner);
        }
    }

    private static String readString(ByteBuf buf) {
        return ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    private static void writeString(String s, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
    }

    private static NBTTagCompound readNBT(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    private static void writeNBT(NBTTagCompound cmp, ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)cmp);
    }

    private static BlockPos readBlockPos(ByteBuf buf) {
        return BlockPos.func_177969_a((long)buf.readLong());
    }

    private static void writeBlockPos(BlockPos pos, ByteBuf buf) {
        buf.writeLong(pos.func_177986_g());
    }

    static {
        Message.map(Byte.TYPE, Message::readByte, Message::writeByte);
        Message.map(Integer.TYPE, Message::readInt, Message::writeInt);
        Message.map(Long.TYPE, Message::readLong, Message::writeLong);
        Message.map(Float.TYPE, Message::readFloat, Message::writeFloat);
        Message.map(Double.TYPE, Message::readDouble, Message::writeDouble);
        Message.map(Boolean.TYPE, Message::readBoolean, Message::writeBoolean);
        Message.map(String.class, Message::readString, Message::writeString);
        Message.map(NBTTagCompound.class, Message::readNBT, Message::writeNBT);
        Message.map(BlockPos.class, Message::readBlockPos, Message::writeBlockPos);
        Message.map(byte[][].class, Message::readByte2DArray, Message::writeByte2DArray);
        Message.map(int[].class, Message::readIntArray, Message::writeIntArray);
        Message.map(double[].class, Message::readDoubleArray, Message::writeDoubleArray);
        Message.map(UUID.class, Message::readUUID, Message::writeUUID);
    }

    public static interface Reader<T> {
        public T read(ByteBuf var1);
    }

    public static interface Writer<T> {
        public void write(T var1, ByteBuf var2);
    }
}

