/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import com.Da_Technomancer.essentials.items.EssentialsItems;
import com.Da_Technomancer.essentials.tileentities.BrazierTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class Brazier
extends BlockContainer {
    private static final AxisAlignedBB BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);

    protected Brazier() {
        super(Material.field_151576_e);
        String name = "brazier";
        this.func_149663_c(name);
        this.func_149711_c(2.0f);
        this.setRegistryName(name);
        this.func_149647_a(EssentialsItems.TAB_ESSENTIALS);
        EssentialsBlocks.toRegister.add((Block)this);
        EssentialsBlocks.blockAddQue(this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new BrazierTileEntity();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState other = world.func_180495_p(pos);
        if (other.func_177230_c() != this) {
            return other.getLightValue(world, pos);
        }
        switch ((Integer)state.func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS)) {
            case 2: 
            case 4: {
                return 15;
            }
            case 3: {
                return 14;
            }
            case 6: 
            case 7: {
                return 3;
            }
        }
        return 0;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        int type = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS);
        if (type == 1) {
            entityIn.func_70066_B();
        } else if (type == 2) {
            entityIn.func_70015_d(5);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        int type = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS);
        if (type != 1 && type != 2) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack out;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BrazierTileEntity && !(out = ((BrazierTileEntity)te).useItem(playerIn.func_184586_b(hand))).equals(playerIn.func_184586_b(hand))) {
            if (!worldIn.field_72995_K) {
                playerIn.func_184611_a(hand, out);
            }
            return true;
        }
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EssentialsProperties.BRAZIER_CONTENTS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> list, @Nullable Entity entityIn, boolean p_185477_7_) {
        Brazier.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, list, (AxisAlignedBB)BB);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack made = ItemStack.field_190927_a;
            switch ((Integer)state.func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS)) {
                case 3: {
                    made = new ItemStack(Blocks.field_150402_ci);
                    break;
                }
                case 4: {
                    made = new ItemStack(Blocks.field_150426_aN);
                    break;
                }
                case 6: {
                    NonNullList saltBlocks = OreDictionary.getOres((String)"blockSalt");
                    if (saltBlocks.isEmpty()) break;
                    made = (ItemStack)saltBlocks.get(0);
                    break;
                }
                case 7: {
                    made = new ItemStack(Items.field_151170_bI);
                }
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)made);
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("Able to hold water, lava, glowstone, coal blocks, and salt blocks");
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

