/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials;

import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.EssentialsConfig;
import com.Da_Technomancer.essentials.EssentialsEventHandlerCommon;
import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.gui.EssentialsGuiHandler;
import com.Da_Technomancer.essentials.items.EssentialsItems;
import com.Da_Technomancer.essentials.items.crafting.EssentialsCrafting;
import com.Da_Technomancer.essentials.packets.EssentialsPackets;
import com.Da_Technomancer.essentials.tileentities.EssentialsTileEntity;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class CommonProxy {
    protected void preInit(FMLPreInitializationEvent e) {
        EssentialsConfig.init(e);
        EssentialsTileEntity.init();
        EssentialsPackets.preInit();
    }

    protected void init(FMLInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new EssentialsEventHandlerCommon());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Essentials.instance, (IGuiHandler)new EssentialsGuiHandler());
        EssentialsConfig.config.save();
    }

    protected void postInit(FMLPostInitializationEvent e) {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        IForgeRegistry registry = e.getRegistry();
        EssentialsBlocks.init();
        for (Block block : EssentialsBlocks.toRegister) {
            registry.register((IForgeRegistryEntry)block);
        }
        EssentialsBlocks.toRegister.clear();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry registry = e.getRegistry();
        EssentialsItems.init();
        for (Item item : EssentialsItems.toRegister) {
            registry.register((IForgeRegistryEntry)item);
        }
        EssentialsItems.toRegister.clear();
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> e) {
        IForgeRegistry registry = e.getRegistry();
        EssentialsCrafting.init();
        for (IRecipe recipe : EssentialsCrafting.toRegister) {
            if (recipe.getRegistryName() == null) {
                ResourceLocation rawLoc;
                ResourceLocation adjusted = rawLoc = new ResourceLocation("essentials", recipe.func_77571_b().func_77973_b().getRegistryName().func_110623_a());
                int i = 0;
                while (CraftingManager.field_193380_a.func_148741_d((Object)adjusted)) {
                    adjusted = new ResourceLocation("essentials", rawLoc.func_110623_a() + '_' + i);
                    ++i;
                }
                recipe.setRegistryName(adjusted);
            }
            registry.register((IForgeRegistryEntry)recipe);
        }
        EssentialsCrafting.toRegister.clear();
    }

    @SubscribeEvent
    public static void missingBlockMapping(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.func_110624_b().equals("crossroads")) continue;
            Essentials.logger.info("Repairing missing mapping: " + mapping.key.toString());
            switch (mapping.key.func_110623_a().toLowerCase()) {
                case "candle_lilypad": {
                    mapping.remap((IForgeRegistryEntry)EssentialsBlocks.candleLilyPad);
                    break;
                }
                case "fertile_soil": {
                    mapping.remap((IForgeRegistryEntry)EssentialsBlocks.fertileSoil);
                    break;
                }
                case "slotted_chest": {
                    mapping.remap((IForgeRegistryEntry)EssentialsBlocks.slottedChest);
                    break;
                }
                case "sorting_hopper": {
                    mapping.remap((IForgeRegistryEntry)EssentialsBlocks.sortingHopper);
                    break;
                }
                case "port_extender": {
                    mapping.remap((IForgeRegistryEntry)EssentialsBlocks.portExtender);
                    break;
                }
                case "brazier": {
                    mapping.remap((IForgeRegistryEntry)EssentialsBlocks.brazier);
                    break;
                }
                case "item_chute": {
                    mapping.remap((IForgeRegistryEntry)EssentialsBlocks.itemChute);
                    break;
                }
                case "item_chute_port": {
                    mapping.remap((IForgeRegistryEntry)EssentialsBlocks.itemChutePort);
                }
            }
        }
    }

    @SubscribeEvent
    public static void missingItemMapping(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.func_110624_b().equals("crossroads")) continue;
            Essentials.logger.info("Repairing missing mapping: " + mapping.key.toString());
            switch (mapping.key.func_110623_a().toLowerCase()) {
                case "candle_lilypad": {
                    mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)EssentialsBlocks.candleLilyPad));
                    break;
                }
                case "fertile_soil": {
                    mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)EssentialsBlocks.fertileSoil));
                    break;
                }
                case "slotted_chest": {
                    mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)EssentialsBlocks.slottedChest));
                    break;
                }
                case "sorting_hopper": {
                    mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)EssentialsBlocks.sortingHopper));
                    break;
                }
                case "obsidian_cutting_kit": {
                    mapping.remap((IForgeRegistryEntry)EssentialsItems.obsidianKit);
                    break;
                }
                case "port_extender": {
                    mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)EssentialsBlocks.portExtender));
                    break;
                }
                case "wrench": {
                    mapping.remap((IForgeRegistryEntry)EssentialsItems.wrench);
                    break;
                }
                case "brazier": {
                    mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)EssentialsBlocks.brazier));
                    break;
                }
                case "item_chute": {
                    mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)EssentialsBlocks.itemChute));
                    break;
                }
                case "item_chute_port": {
                    mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)EssentialsBlocks.itemChutePort));
                }
            }
        }
    }
}

