/*
 * Decompiled with CFR 0.152.
 */
package baguchan.sauceconstruct.inventory;

import baguchan.sauceconstruct.handler.SauceBlocks;
import baguchan.sauceconstruct.tileentity.TileEntitySauceStation;
import baguchan.sauceconstruct.utill.SauceHelper;
import c4.culinaryconstruct.api.ICulinaryIngredient;
import c4.culinaryconstruct.common.util.NBTHelper;
import c4.culinaryconstruct.proxy.CommonProxy;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerSauceStation
extends Container {
    private final InventoryCraftResult outputSlot = new InventoryCraftResult();
    private final IItemHandler ingredientHandler;
    private final BlockPos pos;
    private final World world;
    private String sandwichName;
    private TileEntitySauceStation sandwichStation;

    public ContainerSauceStation(InventoryPlayer playerInventory, World world, BlockPos pos, TileEntitySauceStation te) {
        this.pos = pos;
        this.world = world;
        this.sandwichStation = te;
        this.ingredientHandler = (IItemHandler)this.sandwichStation.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.initSlots(playerInventory);
        this.updateSandwichOutput();
    }

    private void initSlots(InventoryPlayer playerInventory) {
        this.func_75146_a((Slot)new SlotSauce(this.ingredientHandler, 0, 10, 50));
        for (int i = 1; i < 6; ++i) {
            this.func_75146_a((Slot)new SlotLayeredIngredient(this.ingredientHandler, i, 12 + i * 18, 50));
        }
        this.func_75146_a(new SlotSandwich((IInventory)this.outputSlot, 6, 150, 50));
        this.addPlayerSlots(playerInventory);
    }

    private void addPlayerSlots(InventoryPlayer playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 79 + row * 18));
            }
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.func_75146_a(new Slot((IInventory)playerInventory, hotbar, 8 + hotbar * 18, 137));
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.world.func_180495_p(this.pos).func_177230_c() != SauceBlocks.SAUCESTATION) {
            return false;
        }
        return playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public void updateSandwichOutput() {
        ItemStack bread = this.ingredientHandler.getStackInSlot(0);
        int totalFood = 0;
        float totalSaturation = 0.0f;
        int complexity = 0;
        if (bread.func_190926_b()) {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            this.func_75142_b();
            return;
        }
        if (bread.func_77973_b() instanceof ICulinaryIngredient) {
            totalFood += ((ICulinaryIngredient)bread.func_77973_b()).getFoodAmount(bread);
            totalSaturation += ((ICulinaryIngredient)bread.func_77973_b()).getSaturationModifier(bread);
        }
        NonNullList ingredientsList = NonNullList.func_191196_a();
        for (int i = 1; i < this.ingredientHandler.getSlots(); ++i) {
            ItemStack copy;
            ItemStack stack = this.ingredientHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemFood) {
                totalFood += ((ItemFood)stack.func_77973_b()).func_150905_g(stack);
            } else if (stack.func_77973_b() == Items.field_151102_aT) {
                ++totalFood;
            } else if (stack.func_77973_b() == Items.field_151100_aR) {
                ++totalFood;
            } else {
                this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
                this.func_75142_b();
                return;
            }
            boolean flag = true;
            if (flag && !SauceHelper.isValidSandwitch(stack)) {
                ++complexity;
            }
            for (ItemStack existing : ingredientsList) {
                if (existing.func_190926_b() || existing.func_77973_b() != stack.func_77973_b() || stack.func_77981_g() && stack.func_77960_j() != existing.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existing)) continue;
                flag = false;
                break;
            }
            if ((copy = stack.func_77946_l()).func_190916_E() > 1) {
                copy.func_190920_e(1);
            }
            ingredientsList.add((Object)copy);
        }
        if (bread.func_77973_b() instanceof ItemFood) {
            totalFood += ((ItemFood)bread.func_77973_b()).func_150905_g(bread);
        } else {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            this.func_75142_b();
            return;
        }
        ItemStack copy = bread.func_77946_l();
        if (copy.func_190916_E() > 1) {
            copy.func_190920_e(1);
        }
        ingredientsList.add((Object)copy);
        for (ItemStack stack : ingredientsList) {
            double foodAmount = 0.0;
            double saturationModifier = 0.0;
            double basicFoodAmount = 0.0;
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (stack.func_77973_b() instanceof ItemFood) {
                foodAmount = ((ItemFood)stack.func_77973_b()).func_150905_g(stack);
                saturationModifier = ((ItemFood)stack.func_77973_b()).func_150906_h(stack);
            } else if (stack.func_77973_b() == Items.field_151102_aT) {
                basicFoodAmount = 0.04;
            } else if (stack.func_77973_b() == Items.field_151100_aR) {
                basicFoodAmount = 0.06;
            }
            totalSaturation = (float)((double)totalSaturation + foodAmount / (double)totalFood * saturationModifier);
            totalSaturation = (float)((double)totalSaturation + basicFoodAmount);
        }
        if (ingredientsList.size() <= 1 || totalFood <= 0 || totalSaturation < 0.0f) {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            this.func_75142_b();
            return;
        }
        double count = 1.0;
        int averageFood = MathHelper.func_76143_f((double)((double)totalFood / count));
        NonNullList ingredientsListBase = NonNullList.func_191196_a();
        int size = NBTHelper.getSize((ItemStack)bread);
        int bonus = NBTHelper.getBonus((ItemStack)bread);
        ingredientsListBase = NBTHelper.getIngredientsList((ItemStack)bread, (boolean)true);
        ItemStack output = new ItemStack((Item)CommonProxy.sandwich);
        NBTHelper.setTagSize((ItemStack)output, (int)size);
        NBTHelper.setIngredientsList((ItemStack)output, (NonNullList)ingredientsListBase);
        NBTHelper.setTagFood((ItemStack)output, (int)averageFood);
        NBTHelper.setTagSaturation((ItemStack)output, (float)(totalSaturation *= 1.0f + (float)bonus * 0.02f));
        NBTHelper.setTagBonus((ItemStack)output, (int)bonus);
        SauceHelper.setTagSauce(output);
        output.func_190920_e(1);
        this.outputSlot.func_70299_a(0, output);
        this.func_75142_b();
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 6) {
                if (!this.func_75135_a(itemstack1, 7, 43, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 7 ? index < 43 && !this.func_75135_a(itemstack1, 0, 1, false) && !this.func_75135_a(itemstack1, 1, 6, false) : !this.func_75135_a(itemstack1, 7, 43, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void updateSandwichName(String newName) {
        this.sandwichName = newName;
        this.updateSandwichOutput();
    }

    private class SlotSandwich
    extends Slot {
        public SlotSandwich(IInventory inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public void func_75218_e() {
            ContainerSauceStation.this.updateSandwichOutput();
        }

        @Nonnull
        public ItemStack func_190901_a(EntityPlayer thePlayer, @Nonnull ItemStack stack) {
            IItemHandler ingredients = ContainerSauceStation.this.ingredientHandler;
            if (ingredients != null) {
                for (int i = 0; i < ingredients.getSlots(); ++i) {
                    ItemStack slot = ingredients.getStackInSlot(i);
                    slot.func_190918_g(1);
                }
            }
            ContainerSauceStation.this.updateSandwichOutput();
            return stack;
        }
    }

    private class SlotLayeredIngredient
    extends SlotItemHandler {
        public SlotLayeredIngredient(IItemHandler handler, int index, int xPosition, int yPosition) {
            super(handler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return SauceHelper.isValidSauce(stack);
        }

        public void func_75218_e() {
            ContainerSauceStation.this.updateSandwichOutput();
        }
    }

    private class SlotSauce
    extends SlotItemHandler {
        public SlotSauce(IItemHandler handler, int index, int xPosition, int yPosition) {
            super(handler, index, xPosition, yPosition);
        }

        public void func_75218_e() {
            ContainerSauceStation.this.updateSandwichOutput();
        }

        public boolean func_75214_a(ItemStack stack) {
            return SauceHelper.isValidSandwitch(stack);
        }
    }
}

