/*
 * Decompiled with CFR 0.152.
 */
package alexiy.thaumic.addon;

import alexiy.thaumic.addon.AspectInstance;
import alexiy.thaumic.addon.CalculatorData;
import alexiy.thaumic.addon.Events;
import alexiy.thaumic.addon.GuiHandler;
import alexiy.thaumic.addon.ServerProxy;
import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

@Mod(modid="thaumic_calculator", name="Thaumic Calculations", version="0.4", acceptedMinecraftVersions="[1.12]", dependencies="required-after:thaumcraft;required-after:satako")
public class ThaumicCalculations {
    static final String ID = "thaumic_calculator";
    static final String NAME = "Thaumic Calculations";
    static HashMap<ItemStack, AspectList> crucibleRecipes;
    static HashMultimap<ItemStack, ItemStack> crucibleCatalysts;
    static HashMap<ItemStack, ShapedArcaneRecipe> arcaneRecipes;
    static HashMap<ItemStack, ShapelessArcaneRecipe> shapelessArcaneRecipes;
    @Mod.Instance
    public static ThaumicCalculations instance;
    @SidedProxy(clientSide="alexiy.thaumic.addon.ClientProxy", serverSide="alexiy.thaumic.addon.ServerProxy")
    public static ServerProxy proxy;
    static HashMultimap<ItemStack, AspectInstance> aspectinstances;
    static SimpleNetworkWrapper networkWrapper;

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent preInitializationEvent) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        networkWrapper = new SimpleNetworkWrapper(ID);
        networkWrapper.registerMessage(CalculatorData.Handler.class, CalculatorData.class, 0, Side.SERVER);
        proxy.onPreload();
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent postInitializationEvent) {
        crucibleRecipes = new HashMap(73);
        crucibleCatalysts = HashMultimap.create((int)crucibleRecipes.size(), (int)2);
        ThaumcraftApi.getCraftingRecipes().values().forEach(iThaumcraftRecipe -> {
            if (iThaumcraftRecipe instanceof CrucibleRecipe) {
                ItemStack[] matchingStacks;
                CrucibleRecipe crucibleRecipe = (CrucibleRecipe)iThaumcraftRecipe;
                ItemStack result = crucibleRecipe.getRecipeOutput();
                AspectList parts = crucibleRecipe.getAspects();
                crucibleRecipes.put(result, parts);
                Ingredient input = crucibleRecipe.getCatalyst();
                for (ItemStack matchingStack : matchingStacks = input.func_193365_a()) {
                    crucibleCatalysts.put((Object)result, (Object)matchingStack.func_77946_l());
                }
            }
        });
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            ItemStack result;
            if (recipe instanceof ShapedArcaneRecipe) {
                ShapedArcaneRecipe shapedArcaneRecipe = (ShapedArcaneRecipe)recipe;
                result = shapedArcaneRecipe.func_77571_b();
                arcaneRecipes.put(result, shapedArcaneRecipe);
                continue;
            }
            if (!(recipe instanceof ShapelessArcaneRecipe)) continue;
            ShapelessArcaneRecipe shapelessArcaneRecipe = (ShapelessArcaneRecipe)recipe;
            result = shapelessArcaneRecipe.func_77571_b();
            shapelessArcaneRecipes.put(result, shapelessArcaneRecipe);
        }
        System.out.println("Found " + crucibleRecipes.size() + " crucible recipes");
        System.out.println("Found " + shapelessArcaneRecipes.size() + " shapeless arcane recipes");
        System.out.println("Found " + arcaneRecipes.size() + " shaped arcane recipes");
    }

    @Mod.EventHandler
    public void loaded(FMLLoadCompleteEvent loadCompleteEvent) {
        long timeStarted = System.currentTimeMillis();
        aspectinstances = HashMultimap.create((int)CommonInternals.objectTags.size(), (int)8);
        HashSet<ItemStack> stackHashSet = new HashSet<ItemStack>();
        Collection items = ForgeRegistries.ITEMS.getValuesCollection();
        for (Object item : items) {
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, list);
            if (!list.isEmpty()) {
                for (ItemStack itemStack : list) {
                    if (Events.isRegistered(itemStack)) {
                        stackHashSet.add(itemStack);
                        continue;
                    }
                    if (ThaumcraftCraftingManager.generateTags((ItemStack)itemStack) == null) continue;
                    stackHashSet.add(itemStack);
                }
                continue;
            }
            ItemStack itemStack = new ItemStack((Item)item);
            if (Events.isRegistered(itemStack)) {
                stackHashSet.add(itemStack);
                continue;
            }
            if (ThaumcraftCraftingManager.generateTags((ItemStack)itemStack) == null) continue;
            stackHashSet.add(itemStack);
        }
        int count = 0;
        for (ItemStack stack : stackHashSet) {
            AspectList aspectList = AspectHelper.getObjectAspects((ItemStack)stack);
            if (aspectList == null || aspectList.size() <= 0) continue;
            ++count;
            aspectList.aspects.forEach((aspect, integer) -> aspectinstances.put((Object)stack, (Object)new AspectInstance((Aspect)aspect, (int)integer)));
        }
        System.out.println("Tagged objects: " + CommonInternals.objectTags.size());
        System.out.println("Resolved stacks: " + count);
        System.out.println("Total stacks: " + stackHashSet.size());
        long time = System.currentTimeMillis() - timeStarted;
        if (time >= 1000L) {
            System.out.println("Finished in " + time / 1000L + " seconds");
        } else {
            System.out.println("Finished in " + time + " milliseconds");
        }
    }

    static {
        arcaneRecipes = new HashMap(80);
        shapelessArcaneRecipes = new HashMap(8);
    }
}

