/*
 * Decompiled with CFR 0.152.
 */
package alexiy.thaumic.addon;

import alexiy.thaumic.addon.TileCalculator;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CalculatorData
implements IMessage {
    private String string;
    private BlockPos tileposition;
    private String crucibleString;
    private TileCalculator.Mode mode;

    public CalculatorData() {
    }

    public CalculatorData(BlockPos blockPos, String aspectString, String crucibleOutputString, TileCalculator.Mode calculatorMode) {
        this.string = aspectString;
        this.tileposition = blockPos;
        this.crucibleString = crucibleOutputString;
        this.mode = calculatorMode;
    }

    public void fromBytes(ByteBuf buf) {
        this.string = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.tileposition = BlockPos.func_177969_a((long)buf.readLong());
        this.mode = TileCalculator.Mode.values()[buf.readByte()];
        this.crucibleString = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.string);
        buf.writeLong(this.tileposition.func_177986_g());
        buf.writeByte(this.mode.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.crucibleString);
    }

    public static class Handler
    implements IMessageHandler<CalculatorData, IMessage> {
        public IMessage onMessage(CalculatorData message, MessageContext ctx) {
            WorldServer worldServer = ctx.getServerHandler().field_147369_b.func_71121_q();
            worldServer.func_152344_a(() -> {
                BlockPos pos = message.tileposition;
                TileEntity tileEntity = worldServer.func_175625_s(pos);
                if (tileEntity instanceof TileCalculator) {
                    TileCalculator calculator = (TileCalculator)tileEntity;
                    calculator.aspect = message.string;
                    calculator.crucibleOutput = message.crucibleString;
                    calculator.mode = message.mode;
                    calculator.func_70296_d();
                }
            });
            return null;
        }
    }
}

