/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.network;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import ftblag.thaumicgrid.grid.gui.GuiThaumicGrid;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageThaumicGridItemUpdate
implements IMessage,
IMessageHandler<MessageThaumicGridItemUpdate, IMessage> {
    private Consumer<ByteBuf> sendHandler;
    private boolean canCraft;
    private List<IGridStack> stacks = new ArrayList<IGridStack>();

    public MessageThaumicGridItemUpdate() {
    }

    public MessageThaumicGridItemUpdate(INetwork network, boolean canCraft) {
        this.sendHandler = buf -> {
            int size = network.getItemStorageCache().getList().getStacks().size();
            for (ICraftingPattern pattern : network.getCraftingManager().getPatterns()) {
                size += pattern.getOutputs().size();
            }
            buf.writeInt(size);
            for (ItemStack stack : network.getItemStorageCache().getList().getStacks()) {
                StackUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack, (INetwork)network, (boolean)false);
                IStorageTracker.IStorageTrackerEntry entry = network.getItemStorageTracker().get((Object)stack);
                buf.writeBoolean(entry != null);
                if (entry == null) continue;
                buf.writeLong(entry.getTime());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
            }
            for (ICraftingPattern pattern : network.getCraftingManager().getPatterns()) {
                for (ItemStack output : pattern.getOutputs()) {
                    StackUtils.writeItemStack((ByteBuf)buf, (ItemStack)output, (INetwork)network, (boolean)true);
                    IStorageTracker.IStorageTrackerEntry entry = network.getItemStorageTracker().get((Object)output);
                    buf.writeBoolean(entry != null);
                    if (entry == null) continue;
                    buf.writeLong(entry.getTime());
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
                }
            }
        };
        this.canCraft = canCraft;
    }

    public MessageThaumicGridItemUpdate(Consumer<ByteBuf> sendHandler, boolean canCraft) {
        this.sendHandler = sendHandler;
        this.canCraft = canCraft;
    }

    public void fromBytes(ByteBuf buf) {
        this.canCraft = buf.readBoolean();
        int items = buf.readInt();
        for (int i = 0; i < items; ++i) {
            this.stacks.add((IGridStack)new GridStackItem(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.canCraft);
        this.sendHandler.accept(buf);
    }

    public IMessage onMessage(MessageThaumicGridItemUpdate message, MessageContext ctx) {
        GuiBase.executeLater(GuiThaumicGrid.class, grid -> {
            grid.getView().setCanCraft(message.canCraft);
            grid.getView().setStacks(message.stacks);
            grid.getView().sort();
        });
        return null;
    }
}

