/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.grid.tile;

import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import ftblag.thaumicgrid.grid.gui.GuiThaumicGrid;
import ftblag.thaumicgrid.grid.network.IThaumicGrid;
import ftblag.thaumicgrid.grid.network.NetworkNodeThaumicGrid;
import javax.annotation.Nonnull;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileThaumicGrid
extends TileNode<NetworkNodeThaumicGrid> {
    public static final TileDataParameter<Integer, TileThaumicGrid> VIEW_TYPE = new TileDataParameter(DataSerializers.field_187192_b, (Object)0, t -> ((NetworkNodeThaumicGrid)t.getNode()).getViewType(), (t, v) -> {
        if (IThaumicGrid.isValidViewType(v)) {
            ((NetworkNodeThaumicGrid)t.getNode()).setViewType((int)v);
            ((NetworkNodeThaumicGrid)t.getNode()).markDirty();
        }
    }, (initial, p) -> TileThaumicGrid.trySortGrid(initial));
    public static final TileDataParameter<Integer, TileThaumicGrid> SORTING_DIRECTION = new TileDataParameter(DataSerializers.field_187192_b, (Object)0, t -> ((NetworkNodeThaumicGrid)t.getNode()).getSortingDirection(), (t, v) -> {
        if (IThaumicGrid.isValidSortingDirection(v)) {
            ((NetworkNodeThaumicGrid)t.getNode()).setSortingDirection((int)v);
            ((NetworkNodeThaumicGrid)t.getNode()).markDirty();
        }
    }, (initial, p) -> TileThaumicGrid.trySortGrid(initial));
    public static final TileDataParameter<Integer, TileThaumicGrid> SORTING_TYPE = new TileDataParameter(DataSerializers.field_187192_b, (Object)0, t -> ((NetworkNodeThaumicGrid)t.getNode()).getSortingType(), (t, v) -> {
        if (IThaumicGrid.isValidSortingType(v)) {
            ((NetworkNodeThaumicGrid)t.getNode()).setSortingType((int)v);
            ((NetworkNodeThaumicGrid)t.getNode()).markDirty();
        }
    }, (initial, p) -> TileThaumicGrid.trySortGrid(initial));
    public static final TileDataParameter<Integer, TileThaumicGrid> SEARCH_BOX_MODE = new TileDataParameter(DataSerializers.field_187192_b, (Object)0, t -> ((NetworkNodeThaumicGrid)t.getNode()).getSearchBoxMode(), (t, v) -> {
        if (IThaumicGrid.isValidSearchBoxMode(v)) {
            ((NetworkNodeThaumicGrid)t.getNode()).setSearchBoxMode((int)v);
            ((NetworkNodeThaumicGrid)t.getNode()).markDirty();
        }
    }, (initial, p) -> GuiBase.executeLater(GuiThaumicGrid.class, grid -> grid.getSearchField().setMode(p.intValue())));
    public static final TileDataParameter<Integer, TileThaumicGrid> SIZE = new TileDataParameter(DataSerializers.field_187192_b, (Object)0, t -> ((NetworkNodeThaumicGrid)t.getNode()).getSize(), (t, v) -> {
        if (IThaumicGrid.isValidSize(v)) {
            ((NetworkNodeThaumicGrid)t.getNode()).setSize((int)v);
            ((NetworkNodeThaumicGrid)t.getNode()).markDirty();
        }
    }, (initial, p) -> GuiBase.executeLater(GuiThaumicGrid.class, GuiBase::func_73866_w_));
    public static final TileDataParameter<Integer, TileThaumicGrid> TAB_SELECTED = new TileDataParameter(DataSerializers.field_187192_b, (Object)0, t -> ((NetworkNodeThaumicGrid)t.getNode()).getTabSelected(), (t, v) -> {
        ((NetworkNodeThaumicGrid)t.getNode()).setTabSelected(v.intValue() == ((NetworkNodeThaumicGrid)t.getNode()).getTabSelected() ? -1 : v);
        ((NetworkNodeThaumicGrid)t.getNode()).markDirty();
    }, (initial, p) -> {
        if (p != -1) {
            GuiBase.executeLater(GuiThaumicGrid.class, grid -> grid.getView().sort());
        }
    });
    public static final TileDataParameter<Integer, TileThaumicGrid> TAB_PAGE = new TileDataParameter(DataSerializers.field_187192_b, (Object)0, t -> ((NetworkNodeThaumicGrid)t.getNode()).getTabPage(), (t, v) -> {
        if (v >= 0 && v <= ((NetworkNodeThaumicGrid)t.getNode()).getTotalTabPages()) {
            ((NetworkNodeThaumicGrid)t.getNode()).setTabPage((int)v);
            ((NetworkNodeThaumicGrid)t.getNode()).markDirty();
        }
    });

    public TileThaumicGrid() {
        this.dataManager.addWatchedParameter(VIEW_TYPE);
        this.dataManager.addWatchedParameter(SORTING_DIRECTION);
        this.dataManager.addWatchedParameter(SORTING_TYPE);
        this.dataManager.addWatchedParameter(SEARCH_BOX_MODE);
        this.dataManager.addWatchedParameter(SIZE);
        this.dataManager.addWatchedParameter(TAB_SELECTED);
        this.dataManager.addWatchedParameter(TAB_PAGE);
    }

    public static void trySortGrid(boolean initial) {
        if (!initial) {
            GuiBase.executeLater(GuiThaumicGrid.class, grid -> grid.getView().sort());
        }
    }

    @Nonnull
    public NetworkNodeThaumicGrid createNode(World world, BlockPos pos) {
        return new NetworkNodeThaumicGrid(world, pos);
    }

    public String getNodeId() {
        return "thaumic_grid";
    }
}

