/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.grid.container;

import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.container.ContainerBase;
import com.raoulvdberge.refinedstorage.gui.IResizableDisplay;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import ftblag.thaumicgrid.grid.container.slot.SlotThaumicGridCrafting;
import ftblag.thaumicgrid.grid.container.slot.SlotThaumicGridCraftingResult;
import ftblag.thaumicgrid.grid.network.NetworkNodeThaumicGrid;
import ftblag.thaumicgrid.utils.TGUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.ThaumcraftInvHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.ContainerDummy;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.common.blocks.world.ore.ShardType;
import thaumcraft.common.container.slot.SlotCrystal;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class ContainerThaumicGrid
extends ContainerBase {
    public static int[] xx = new int[]{8, 26, 8, 26, 8, 26};
    public static int[] yy = new int[]{0, 0, 18, 18, 36, 36};
    private NetworkNodeThaumicGrid grid;
    private IStorageCache cache;
    private IStorageCacheListener listener;
    private IResizableDisplay display;
    private SlotThaumicGridCraftingResult craftingResultSlot;
    private int lastVis = -1;
    private long lastCheck = 0L;

    public ContainerThaumicGrid(NetworkNodeThaumicGrid grid, IResizableDisplay display, @Nullable TileBase gridTile, EntityPlayer player) {
        super(gridTile, player);
        this.grid = grid;
        this.display = display;
        this.initSlots();
        TGUtils.setEH(grid.getCraftingMatrix(), this);
        grid.getAura();
        this.func_75130_a((IInventory)grid.getCraftingMatrix());
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.grid.getAura();
        listener.func_71112_a((Container)this, 0, this.grid.auraVisServer);
    }

    public void func_75137_b(int id, int data) {
        if (id == 0) {
            this.grid.auraVisClient = data;
        }
    }

    public void func_75130_a(IInventory par1IInventory) {
        IArcaneRecipe recipe = ThaumcraftCraftingManager.findMatchingArcaneRecipe((InventoryCrafting)this.grid.getCraftingMatrix(), (EntityPlayer)this.getPlayer());
        boolean hasVis = true;
        boolean hasCrystals = true;
        int vis = 0;
        if (recipe != null) {
            AspectList crystals = null;
            vis = recipe.getVis();
            crystals = recipe.getCrystals();
            this.grid.getAura();
            boolean bl = this.grid.getWorld().field_72995_K ? this.grid.auraVisClient >= vis : (hasVis = this.grid.auraVisServer >= (vis *= (int)(1.0f - CasterManager.getTotalVisDiscount((EntityPlayer)this.getPlayer()))));
            if (crystals != null && crystals.size() > 0) {
                for (Aspect aspect : crystals.getAspects()) {
                    if (ThaumcraftInvHelper.countTotalItemsIn((IItemHandler)ThaumcraftInvHelper.wrapInventory((IInventory)this.grid.getCraftingMatrix(), (EnumFacing)EnumFacing.UP), (ItemStack)ThaumcraftApiHelper.makeCrystal((Aspect)aspect, (int)crystals.getAmount(aspect)), (ThaumcraftInvHelper.InvFilter)ThaumcraftInvHelper.InvFilter.STRICT) >= crystals.getAmount(aspect)) continue;
                    hasCrystals = false;
                    break;
                }
            }
        }
        if (hasVis && hasCrystals) {
            this.func_192389_a(this.grid.getWorld(), this.getPlayer(), this.grid.getCraftingMatrix(), null);
        }
    }

    protected void func_192389_a(World world, EntityPlayer player, InventoryCrafting craftMat, InventoryCraftResult nn) {
        if (!world.field_72995_K) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            IArcaneRecipe arecipe = ThaumcraftCraftingManager.findMatchingArcaneRecipe((InventoryCrafting)craftMat, (EntityPlayer)entityplayermp);
            if (arecipe != null && (arecipe.func_192399_d() || !world.func_82736_K().func_82766_b("doLimitedCrafting") || entityplayermp.func_192037_E().func_193830_f((IRecipe)arecipe)) && ThaumcraftCapabilities.getKnowledge((EntityPlayer)player).isResearchKnown(arecipe.getResearch())) {
                this.grid.currentRecipe = arecipe;
                itemstack = arecipe.func_77572_b(craftMat);
            } else {
                InventoryCrafting craftInv = new InventoryCrafting((Container)new ContainerDummy(), 3, 3);
                for (int a = 0; a < 9; ++a) {
                    craftInv.func_70299_a(a, craftMat.func_70301_a(a));
                }
                IRecipe irecipe = CraftingManager.func_192413_b((InventoryCrafting)craftInv, (World)world);
                if (irecipe != null && (irecipe.func_192399_d() || !world.func_82736_K().func_82766_b("doLimitedCrafting") || entityplayermp.func_192037_E().func_193830_f(irecipe))) {
                    this.grid.currentRecipe = irecipe;
                    itemstack = irecipe.func_77572_b(craftInv);
                }
            }
            this.grid.getCraftingResult().func_70299_a(0, itemstack);
            entityplayermp.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, 0, itemstack));
        }
    }

    public void initSlots() {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.transferManager.clearTransfers();
        this.addCraftingSlots();
        this.addFilterSlots();
        this.transferManager.setNotFoundHandler(slotIndex -> {
            Slot slot;
            if (!this.getPlayer().func_130014_f_().field_72995_K && (slot = (Slot)this.field_75151_b.get((int)slotIndex)).func_75216_d()) {
                if (slot == this.craftingResultSlot) {
                    this.grid.onCraftedShift(this.getPlayer());
                    this.sendCraftingSlots();
                    this.func_75142_b();
                } else {
                    ItemStack stack = slot.func_75211_c();
                    IItemGridHandler itemHandler = this.grid.getItemHandler();
                    if (itemHandler != null) {
                        slot.func_75215_d(itemHandler.onShiftClick((EntityPlayerMP)this.getPlayer(), stack));
                    } else if (slot instanceof SlotThaumicGridCrafting && this.func_75135_a(stack, 4, 40, false)) {
                        slot.func_75218_e();
                    }
                    this.func_75142_b();
                }
            }
            return ItemStack.field_190927_a;
        });
        this.addPlayerInventory(8, this.display.getYPlayerInventory());
    }

    private void addFilterSlots() {
        int yStart = 6;
        for (int i = 0; i < 4; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.grid.getFilter(), i, 204, yStart + 18 * i + this.getTabDelta()));
        }
        this.transferManager.addBiTransfer((IInventory)this.getPlayer().field_71071_by, (IItemHandler)this.grid.getFilter());
    }

    private void addCraftingSlots() {
        int headerAndSlots = this.getTabDelta() + this.display.getTopHeight() + this.display.getVisibleRows() * 18;
        this.craftingResultSlot = new SlotThaumicGridCraftingResult(this, this.getPlayer(), this.grid, 0, 148, headerAndSlots + 22);
        this.func_75146_a((Slot)this.craftingResultSlot);
        int x = 48;
        int y = headerAndSlots + 4;
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotThaumicGridCrafting((IInventory)this.grid.getCraftingMatrix(), i, x + i % 3 * 18, y));
            if ((i + 1) % 3 != 0) continue;
            y += 18;
        }
        for (ShardType st : ShardType.values()) {
            if (st.getMetadata() >= 6) continue;
            this.func_75146_a((Slot)new SlotCrystal(st.getAspect(), (IInventory)this.grid.getCraftingMatrix(), st.getMetadata() + 9, xx[st.getMetadata()], headerAndSlots + 4 + yy[st.getMetadata()]));
        }
    }

    private int getTabDelta() {
        return !this.grid.getTabs().isEmpty() ? 27 : 0;
    }

    public NetworkNodeThaumicGrid getGrid() {
        return this.grid;
    }

    public void sendCraftingSlots() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotThaumicGridCrafting) && slot != this.craftingResultSlot) continue;
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((Container)this, i, slot.func_75211_c());
            }
        }
    }

    public void func_75142_b() {
        if (!this.getPlayer().field_70170_p.field_72995_K) {
            if (this.grid.getStorageCache() == null) {
                if (this.listener != null) {
                    this.cache.removeListener(this.listener);
                    this.listener = null;
                    this.cache = null;
                }
            } else if (this.listener == null) {
                this.listener = this.grid.createListener((EntityPlayerMP)this.getPlayer());
                this.cache = this.grid.getStorageCache();
                this.cache.addListener(this.listener);
            }
        }
        super.func_75142_b();
        long t = System.currentTimeMillis();
        if (t > this.lastCheck) {
            this.lastCheck = t + 500L;
            this.grid.getAura();
        }
        if (this.lastVis != this.grid.auraVisServer) {
            this.func_75130_a((IInventory)this.grid.getCraftingMatrix());
        }
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener icrafting = (IContainerListener)this.field_75149_d.get(i);
            if (this.lastVis == this.grid.auraVisServer) continue;
            icrafting.func_71112_a((Container)this, 0, this.grid.auraVisServer);
            this.sendCraftingSlots();
        }
        this.lastVis = this.grid.auraVisServer;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.func_130014_f_().field_72995_K) {
            this.grid.onClosed(player);
            if (this.cache != null && this.listener != null) {
                this.cache.removeListener(this.listener);
            }
        }
        if (!this.grid.getWorld().field_72995_K) {
            TGUtils.setEH(this.grid.getCraftingMatrix(), this.grid.craftingContainer);
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot != this.craftingResultSlot && super.func_94530_a(stack, slot);
    }

    protected boolean isHeldItemDisabled() {
        return false;
    }
}

