/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.lexi;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import quaternary.botaniatweaks.modules.botania.recipe.AgglomerationRecipe;
import quaternary.botaniatweaks.modules.shared.helper.MiscHelpers;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.common.lexicon.page.PageRecipe;

public class PageCustomTerrasteel
extends PageRecipe {
    private static final ResourceLocation terrasteelOverlay = new ResourceLocation("botania:textures/gui/terrasteelOverlay.png");
    private final AgglomerationRecipe recipe;
    List<List<ItemStack>> inputStacks = new ArrayList<List<ItemStack>>();
    @GameRegistry.ItemStackHolder(value="botania:terraplate")
    public static final ItemStack terraPlate = ItemStack.field_190927_a;

    public PageCustomTerrasteel(String unlocalizedName, AgglomerationRecipe recipe) {
        super(unlocalizedName);
        this.recipe = recipe;
        for (ItemStack stack : recipe.recipeStacks) {
            this.inputStacks.add((List<ItemStack>)ImmutableList.of((Object)stack));
        }
        for (String oreKey : recipe.recipeOreKeys) {
            this.inputStacks.add(MiscHelpers.getAllSubtypes((Iterable<ItemStack>)OreDictionary.getOres((String)oreKey)));
        }
    }

    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        IBlockState multiblockCenter = this.recipe.multiblockCenter;
        IBlockState multiblockEdge = this.recipe.multiblockEdge;
        IBlockState multiblockCorner = this.recipe.multiblockCorner;
        ItemStack multiblockCenterStack = MiscHelpers.stackFromState(multiblockCenter);
        ItemStack multiblockEdgeStack = MiscHelpers.stackFromState(multiblockEdge);
        ItemStack multiblockCornerStack = MiscHelpers.stackFromState(multiblockCorner);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8, gui.getTop() + 103, multiblockCornerStack, false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8 + 7, gui.getTop() + 106, multiblockEdgeStack, false);
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8 - 6, gui.getTop() + 106, multiblockEdgeStack, false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8, gui.getTop() + 110, multiblockCenterStack, false);
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8 + 14, gui.getTop() + 110, multiblockCornerStack, false);
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8 - 13, gui.getTop() + 110, multiblockCornerStack, false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8 - 6, gui.getTop() + 114, multiblockEdgeStack, false);
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8 + 7, gui.getTop() + 114, multiblockEdgeStack, false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8 + 1, gui.getTop() + 117, multiblockCornerStack, false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8, gui.getTop() + 102, terraPlate, false);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
        int circleCenterX = gui.getLeft() + gui.getWidth() / 2 - 8;
        int circleCenterY = gui.getTop() + 110;
        int circleRadius = 30;
        ArrayList<ItemStack> drawStacks = new ArrayList<ItemStack>(this.inputStacks.size());
        int seconds = (int)(Minecraft.func_71386_F() / 1000L);
        for (List<ItemStack> stackList : this.inputStacks) {
            drawStacks.add(stackList.get(seconds % stackList.size()));
        }
        double tau = Math.PI * 2;
        double angleBetweenItems = tau / 10.0;
        double angle = tau * -0.25 - (double)(drawStacks.size() - 1) / 2.0 * angleBetweenItems;
        for (ItemStack stack : drawStacks) {
            double xOffset = Math.cos(angle) * (double)circleRadius;
            double yOffset = Math.sin(angle) * (double)circleRadius;
            this.renderItem(gui, (double)circleCenterX + xOffset, (double)circleCenterY + yOffset, stack, false);
            angle += angleBetweenItems;
        }
        this.renderItem(gui, gui.getLeft() + gui.getWidth() / 2 - 8, gui.getTop() + 30, this.recipe.recipeOutput, false);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(terrasteelOverlay);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        GlStateManager.func_179084_k();
    }

    public void onPageAdded(LexiconEntry entry, int index) {
        LexiconRecipeMappings.map((ItemStack)this.recipe.getRecipeOutputCopy(), (LexiconEntry)entry, (int)index);
    }

    public List<ItemStack> getDisplayedRecipes() {
        return ImmutableList.of((Object)this.recipe.getRecipeOutputCopy());
    }
}

