/*
 * Decompiled with CFR 0.152.
 */
package fluke.stygian.world.feature;

import fluke.stygian.util.FastNoise;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenEndVolcano
extends WorldGenerator {
    private final IBlockState volcMainState;
    private final IBlockState volcSecondaryState;
    private final IBlockState volcLiquid;
    private final FastNoise perlin;
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();

    public WorldGenEndVolcano(IBlockState mainBlock, IBlockState subBlock, IBlockState liquid) {
        this.volcMainState = mainBlock;
        this.volcSecondaryState = subBlock;
        this.volcLiquid = liquid;
        this.perlin = new FastNoise();
        this.perlin.SetNoiseType(FastNoise.NoiseType.Perlin);
        this.perlin.SetFrequency(0.1f);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int radius = 9 + rand.nextInt(6);
        int maxHeight = radius * 2 - 1 - rand.nextInt(2);
        IBlockState volcBlock = this.volcMainState;
        List<BlockPos> firstLayer = this.getFirstLayer(world, pos, radius);
        if (firstLayer == null) {
            return false;
        }
        for (BlockPos baseBlock : firstLayer) {
            world.func_175656_a(baseBlock, volcBlock);
        }
        for (int y = 1; y < maxHeight; ++y) {
            int layerRadius = radius - y / 2;
            double maxDist = layerRadius * layerRadius;
            for (int x = -layerRadius - 2; x <= layerRadius + 2; ++x) {
                double xDist = x * x;
                for (int z = -layerRadius - 2; z <= layerRadius + 2; ++z) {
                    double zDist = z * z;
                    double noiseMod = (double)(this.perlin.GetNoise(pos.func_177958_n() + x, y * 2, pos.func_177952_p() + z) + 1.0f) / 2.0 + 0.5;
                    double noisyDist = xDist * noiseMod + zDist * noiseMod;
                    if (noisyDist > maxDist) continue;
                    volcBlock = x == 0 && z == 0 ? this.volcLiquid : (y < 12 && xDist <= 1.0 && zDist <= 1.0 ? this.volcLiquid : (rand.nextInt(11) == 0 ? this.volcSecondaryState : this.volcMainState));
                    IBlockState downState = world.func_180495_p(pos.func_177982_a(x, y, z).func_177977_b());
                    if (y != 0 && volcBlock != this.volcLiquid && downState != this.volcMainState && downState != this.volcSecondaryState && (y != 12 || !(xDist <= 1.0) || !(zDist <= 1.0))) continue;
                    world.func_175656_a(pos.func_177982_a(x, y, z), volcBlock);
                }
            }
        }
        return true;
    }

    public List<BlockPos> getFirstLayer(World world, BlockPos pos, int radius) {
        ArrayList<BlockPos> firstLayer = new ArrayList<BlockPos>();
        double maxDist = radius * radius;
        for (int x = -radius - 2; x <= radius + 2; ++x) {
            double xDist = x * x;
            for (int z = -radius - 2; z <= radius + 2; ++z) {
                double zDist = z * z;
                double noiseMod = (double)(this.perlin.GetNoise(pos.func_177958_n() + x, 0.0f, pos.func_177952_p() + z) + 1.0f) / 2.0 + 0.5;
                double noisyDist = xDist * noiseMod + zDist * noiseMod;
                if (noisyDist > maxDist) continue;
                BlockPos checkPos = pos.func_177982_a(x, 0, z).func_177977_b();
                IBlockState downState = world.func_180495_p(checkPos);
                if (downState != AIR) {
                    firstLayer.add(pos.func_177982_a(x, 0, z));
                    continue;
                }
                if (world.func_180495_p(checkPos.func_177977_b()) != AIR) {
                    firstLayer.add(pos.func_177982_a(x, 0, z));
                    firstLayer.add(pos.func_177982_a(x, -1, z));
                    continue;
                }
                if (world.func_180495_p(checkPos.func_177977_b().func_177977_b()) != AIR) {
                    firstLayer.add(pos.func_177982_a(x, 0, z));
                    firstLayer.add(pos.func_177982_a(x, -1, z));
                    firstLayer.add(pos.func_177982_a(x, -2, z));
                    continue;
                }
                return null;
            }
        }
        return firstLayer;
    }
}

