/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity.transvector;

import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import com.nekokittygames.thaumictinkerer.common.tileentity.transvector.TileEntityTransvector;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.tiles.essentia.TileJarFillable;

public class TileEntityTransvectorInterface
extends TileEntityTransvector
implements IAspectSource,
IEssentiaTransport {
    private int comparatorValue = 0;
    int count = 0;

    @Override
    public int getMaxDistance() {
        return TTConfig.transvectorInterfaceDistance * TTConfig.transvectorInterfaceDistance;
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        TileEntity tile = this.getTile();
        if (tile != null) {
            return tile.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    public void func_70296_d() {
        TileEntity tile = this.getTile();
        if (tile != null) {
            tile.func_70296_d();
        }
        super.func_70296_d();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntity tile = this.getTile();
        if (tile != null) {
            return (T)tile.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isBlocked() {
        TileEntity tile = this.getTile();
        if (tile instanceof IAspectSource) {
            return ((IAspectSource)tile).isBlocked();
        }
        return false;
    }

    public AspectList getAspects() {
        TileEntity tile = this.getTile();
        if (tile instanceof IAspectContainer) {
            return ((IAspectContainer)tile).getAspects();
        }
        return null;
    }

    public void setAspects(AspectList aspectList) {
        TileEntity tile = this.getTile();
        if (tile instanceof IAspectContainer) {
            ((IAspectContainer)tile).setAspects(aspectList);
        }
    }

    public boolean doesContainerAccept(Aspect aspect) {
        TileEntity tile = this.getTile();
        if (tile instanceof IAspectContainer) {
            return ((IAspectContainer)tile).doesContainerAccept(aspect);
        }
        return false;
    }

    public int addToContainer(Aspect aspect, int i) {
        TileEntity tile = this.getTile();
        if (tile instanceof IAspectContainer) {
            return ((IAspectContainer)tile).addToContainer(aspect, i);
        }
        return 0;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        TileEntity tile = this.getTile();
        if (tile instanceof IAspectContainer) {
            return ((IAspectContainer)tile).takeFromContainer(aspect, i);
        }
        return false;
    }

    public boolean takeFromContainer(AspectList aspectList) {
        TileEntity tile = this.getTile();
        if (tile instanceof IAspectContainer) {
            return ((IAspectContainer)tile).takeFromContainer(aspectList);
        }
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        TileEntity tile = this.getTile();
        if (tile instanceof IAspectContainer) {
            return ((IAspectContainer)tile).doesContainerContainAmount(aspect, i);
        }
        return false;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        TileEntity tile = this.getTile();
        if (tile instanceof IAspectContainer) {
            return ((IAspectContainer)tile).doesContainerContain(aspectList);
        }
        return false;
    }

    public int containerContains(Aspect aspect) {
        TileEntity tile = this.getTile();
        if (tile instanceof IAspectContainer) {
            return ((IAspectContainer)tile).containerContains(aspect);
        }
        return 0;
    }

    public boolean isConnectable(EnumFacing enumFacing) {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)tile).isConnectable(enumFacing);
        }
        return false;
    }

    public boolean canInputFrom(EnumFacing enumFacing) {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)tile).canInputFrom(enumFacing);
        }
        return false;
    }

    public boolean canOutputTo(EnumFacing enumFacing) {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)tile).canOutputTo(enumFacing);
        }
        return false;
    }

    public void setSuction(Aspect aspect, int i) {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            ((IEssentiaTransport)tile).setSuction(aspect, i);
        }
    }

    public Aspect getSuctionType(EnumFacing enumFacing) {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)tile).getSuctionType(enumFacing);
        }
        return null;
    }

    public int getSuctionAmount(EnumFacing enumFacing) {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)tile).getSuctionAmount(enumFacing);
        }
        return 0;
    }

    public int takeEssentia(Aspect aspect, int i, EnumFacing enumFacing) {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)tile).takeEssentia(aspect, i, enumFacing);
        }
        return 0;
    }

    public int addEssentia(Aspect aspect, int i, EnumFacing enumFacing) {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)tile).addEssentia(aspect, i, enumFacing);
        }
        return 0;
    }

    public Aspect getEssentiaType(EnumFacing enumFacing) {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)tile).getEssentiaType(enumFacing);
        }
        return null;
    }

    public int getEssentiaAmount(EnumFacing enumFacing) {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)tile).getEssentiaAmount(enumFacing);
        }
        return 0;
    }

    public int getMinimumSuction() {
        TileEntity tile = this.getTile();
        if (tile instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)tile).getMinimumSuction();
        }
        return 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        TileEntity tile = this.getTile();
        if (tile instanceof TileJarFillable) {
            TileJarFillable jar = (TileJarFillable)tile;
            this.fillJar(jar);
        }
        int originalValue = this.comparatorValue;
        if (this.getTilePos() != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.getTilePos());
            this.comparatorValue = state.func_185912_n() ? state.func_185888_a(this.field_145850_b, this.getTilePos()) : 0;
            if (this.comparatorValue != originalValue) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            }
        }
    }

    public int getComparatorValue() {
        return this.comparatorValue;
    }

    public void setComparatorValue(int comparatorValue) {
        this.comparatorValue = comparatorValue;
    }

    @Override
    public void readExtraNBT(NBTTagCompound compound) {
        super.readExtraNBT(compound);
        if (compound.func_74764_b("comparator")) {
            this.comparatorValue = compound.func_74762_e("comparator");
        }
    }

    @Override
    public void writeExtraNBT(NBTTagCompound compound) {
        super.writeExtraNBT(compound);
        compound.func_74768_a("comparator", this.comparatorValue);
    }

    private void fillJar(TileJarFillable jar) {
        TileEntity te;
        if (!this.field_145850_b.field_72995_K && ++this.count % 5 == 0 && jar.amount < 250 && (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)EnumFacing.UP)) != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(EnumFacing.DOWN)) {
                return;
            }
            Aspect ta = null;
            if (jar.aspectFilter != null) {
                ta = jar.aspectFilter;
            } else if (jar.aspect != null && jar.amount > 0) {
                ta = jar.aspect;
            } else if (ic.getEssentiaAmount(EnumFacing.DOWN) > 0 && ic.getSuctionAmount(EnumFacing.DOWN) < this.getSuctionAmount(EnumFacing.UP) && this.getSuctionAmount(EnumFacing.UP) >= ic.getMinimumSuction()) {
                ta = ic.getEssentiaType(EnumFacing.DOWN);
            }
            if (ta != null && ic.getSuctionAmount(EnumFacing.DOWN) < this.getSuctionAmount(EnumFacing.UP)) {
                this.addToContainer(ta, ic.takeEssentia(ta, 1, EnumFacing.DOWN));
            }
        }
    }
}

