/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity;

import com.nekokittygames.thaumictinkerer.common.items.ItemSoulMould;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityMagnet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMobMagnet
extends TileEntityMagnet {
    private ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityMobMagnet.this.sendUpdates();
        }

        public boolean isItemValidForSlot(int index, ItemStack stack) {
            return TileEntityMobMagnet.this.isItemValidForSlot(index, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private boolean pullAdults = true;

    public boolean isPullAdults() {
        return this.pullAdults;
    }

    public void setPullAdults(boolean pullAdults) {
        this.pullAdults = pullAdults;
        this.sendUpdates();
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemSoulMould;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void writeExtraNBT(NBTTagCompound nbttagcompound) {
        super.writeExtraNBT(nbttagcompound);
        nbttagcompound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        nbttagcompound.func_74757_a("adults", this.pullAdults);
    }

    @Override
    public void readExtraNBT(NBTTagCompound nbttagcompound) {
        super.readExtraNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbttagcompound.func_74775_l("inventory"));
            this.pullAdults = nbttagcompound.func_74767_n("adults");
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    protected <T extends Entity> Predicate selectedEntities() {
        return o -> o instanceof EntityLiving && this.filterEntity((Entity)o);
    }

    @Override
    protected boolean filterEntity(Entity entity) {
        EntityLiving entityLiving = (EntityLiving)entity;
        boolean agePull = false;
        agePull = entityLiving instanceof EntityAgeable ? this.isPullAdults() != ((EntityAgeable)entity).func_70631_g_() : true;
        boolean typePull = true;
        if (this.getInventory().getStackInSlot(0) != ItemStack.field_190927_a) {
            String selectedEntity = ItemSoulMould.getEntityName(this.getInventory().getStackInSlot(0));
            String targetEntity = EntityList.func_75621_b((Entity)entity);
            if (selectedEntity != null && !selectedEntity.equalsIgnoreCase(targetEntity)) {
                typePull = false;
            }
        }
        return !(entity instanceof EntityPlayer) && agePull && typePull;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c() == newSate.func_177230_c()) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newSate);
    }
}

