/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.gui;

import com.ezrol.terry.minecraft.defaultworldgenerator.DefaultWorldGenerator;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.BooleanTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.SettingsRoot;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.WorldTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.gui.ConfigWorldDataGui;
import com.ezrol.terry.minecraft.defaultworldgenerator.lib.Log;
import java.io.IOException;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public class ConfigWorldDataListGui
extends GuiScreen
implements GuiPageButtonList.GuiResponder {
    private GuiScreen parent;
    private SettingsRoot tree;
    private String title = "DWG Config";
    private WorldSlotList slotList = null;
    private int nodeBeingEdited = -1;

    public ConfigWorldDataListGui(GuiScreen parent) {
        this.parent = parent;
        this.tree = DefaultWorldGenerator.modConfig.getSettings();
    }

    protected void saveEdit(WorldTypeNode value) {
        if (this.nodeBeingEdited == -1) {
            this.tree.getWorldList().add(value);
        } else {
            this.tree.getWorldList().set(this.nodeBeingEdited, value);
        }
    }

    public void func_73866_w_() {
        int rightOfList = this.field_146294_l / 3 * 2;
        this.nodeBeingEdited = -1;
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.title = I18n.func_135052_a((String)"defaultworldgenerator-port.config.gui.title", (Object[])new Object[0]);
        this.field_146292_n.add(new GuiButton(ButtonIds.MOVE_UP.getBtnId(), rightOfList + 5, this.field_146295_m / 2 - 80, rightOfList / 2 - 10, 20, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.moveup", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(ButtonIds.NEW.getBtnId(), rightOfList + 5, this.field_146295_m / 2 - 56, rightOfList / 2 - 10, 20, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.new", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(ButtonIds.EDIT.getBtnId(), rightOfList + 5, this.field_146295_m / 2 - 36, rightOfList / 2 - 10, 20, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.edit", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(ButtonIds.DELETE.getBtnId(), rightOfList + 5, this.field_146295_m / 2 - 16, rightOfList / 2 - 10, 20, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.delete", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(ButtonIds.MOVE_DOWN.getBtnId(), rightOfList + 5, this.field_146295_m / 2 + 8, rightOfList / 2 - 10, 20, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.movedown", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(ButtonIds.RESTORE.getBtnId(), rightOfList + 5, this.field_146295_m - 68, rightOfList / 2 - 10, 20, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.restore", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(ButtonIds.SAVE.getBtnId(), rightOfList + 5, this.field_146295_m - 48, rightOfList / 2 - 10, 20, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.save", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(ButtonIds.CANCEL.getBtnId(), rightOfList + 5, this.field_146295_m - 28, rightOfList / 2 - 10, 20, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.cancel", (Object[])new Object[0])));
        int idx = this.slotList == null ? -1 : this.slotList.selected;
        this.slotList = new WorldSlotList(rightOfList, this.field_146295_m, 25, this.field_146295_m, 28);
        this.slotList.selected = idx;
        this.updateButtons();
    }

    private void updateButtons() {
        int selected = this.slotList.getSelected();
        try {
            for (GuiButton b : this.field_146292_n) {
                b.field_146124_l = true;
            }
            if (selected == 0) {
                ((ButtonIds)ButtonIds.MOVE_UP).getButton((ConfigWorldDataListGui)this).field_146124_l = false;
            }
            if (selected == this.tree.getWorldList().size() - 1) {
                ((ButtonIds)ButtonIds.MOVE_DOWN).getButton((ConfigWorldDataListGui)this).field_146124_l = false;
            }
            if (selected == -1) {
                ((ButtonIds)ButtonIds.MOVE_UP).getButton((ConfigWorldDataListGui)this).field_146124_l = false;
                ((ButtonIds)ButtonIds.MOVE_DOWN).getButton((ConfigWorldDataListGui)this).field_146124_l = false;
                ((ButtonIds)ButtonIds.EDIT).getButton((ConfigWorldDataListGui)this).field_146124_l = false;
                ((ButtonIds)ButtonIds.DELETE).getButton((ConfigWorldDataListGui)this).field_146124_l = false;
            }
        }
        catch (NullPointerException e) {
            Log.error("Unable to update button states: " + e);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        Gui.func_73734_a((int)0, (int)24, (int)this.field_146294_l, (int)this.field_146295_m, (int)0x55000000);
        this.slotList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73730_a(0, this.field_146294_l, 24, -16777216);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 8, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            DefaultWorldGenerator.modConfig.restoreSettings();
            this.field_146297_k.func_147108_a(this.parent);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        Enum currentButton = null;
        for (ButtonIds id : ButtonIds.values()) {
            if (id.getBtnId() != button.field_146127_k) continue;
            currentButton = id;
        }
        if (currentButton == null) {
            return;
        }
        switch (1.$SwitchMap$com$ezrol$terry$minecraft$defaultworldgenerator$gui$ConfigWorldDataListGui$ButtonIds[currentButton.ordinal()]) {
            case 1: {
                if (this.slotList.getSelected() == -1) break;
                this.nodeBeingEdited = this.slotList.getSelected();
                if (this.nodeBeingEdited >= this.tree.getWorldList().size()) break;
                this.field_146297_k.func_147108_a((GuiScreen)new ConfigWorldDataGui(this.tree.getWorldList().get(this.nodeBeingEdited), this));
                break;
            }
            case 2: {
                this.nodeBeingEdited = -1;
                this.field_146297_k.func_147108_a((GuiScreen)new ConfigWorldDataGui(new WorldTypeNode(null), this));
                break;
            }
            case 3: {
                int slot = this.slotList.getSelected();
                if (slot >= this.tree.getWorldList().size() - 1 || slot < 0) break;
                this.tree.getWorldList().add(slot + 1, this.tree.getWorldList().remove(slot));
                ++this.slotList.selected;
                this.updateButtons();
                break;
            }
            case 4: {
                int slot = this.slotList.getSelected();
                if (slot < 1 || slot >= this.tree.getWorldList().size()) break;
                this.tree.getWorldList().add(slot - 1, this.tree.getWorldList().remove(slot));
                --this.slotList.selected;
                this.updateButtons();
                break;
            }
            case 5: {
                int slot = this.slotList.getSelected();
                if (slot < 0 || slot >= this.tree.getWorldList().size()) break;
                this.tree.getWorldList().remove(slot);
                this.slotList.selected = -1;
                this.updateButtons();
                break;
            }
            case 6: {
                DefaultWorldGenerator.modConfig.restoreSettings();
                this.tree = DefaultWorldGenerator.modConfig.getSettings();
                this.slotList.selected = -1;
                this.updateButtons();
                break;
            }
            case 7: {
                DefaultWorldGenerator.modConfig.writeToDisk();
                this.field_146297_k.func_147108_a(this.parent);
                break;
            }
            case 8: {
                DefaultWorldGenerator.modConfig.restoreSettings();
                this.field_146297_k.func_147108_a(this.parent);
            }
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.slotList.func_178039_p();
    }

    private class WorldSlotList
    extends GuiSlot {
        int selected;

        private WorldSlotList(int width, int height, int topOff, int bottomOff, int slotHeight) {
            super(ConfigWorldDataListGui.this.field_146297_k, width, height, topOff, bottomOff, slotHeight);
            this.selected = -1;
            this.field_148152_e = 8;
            this.field_148155_a -= 8;
        }

        protected int func_148127_b() {
            if (ConfigWorldDataListGui.this.tree.getWorldList().size() == 0) {
                ConfigWorldDataListGui.this.tree.getWorldList().add(new WorldTypeNode(null));
            }
            return ConfigWorldDataListGui.this.tree.getWorldList().size();
        }

        private int getSelected() {
            return this.selected;
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            this.selected = slotIndex;
            ConfigWorldDataListGui.this.updateButtons();
            if (isDoubleClick) {
                ConfigWorldDataListGui.this.nodeBeingEdited = this.getSelected();
                if (ConfigWorldDataListGui.this.nodeBeingEdited >= ConfigWorldDataListGui.this.tree.getWorldList().size()) {
                    return;
                }
                this.field_148161_k.func_147108_a((GuiScreen)new ConfigWorldDataGui(ConfigWorldDataListGui.this.tree.getWorldList().get(ConfigWorldDataListGui.this.nodeBeingEdited), ConfigWorldDataListGui.this));
            }
        }

        protected boolean func_148131_a(int slotIndex) {
            return slotIndex == this.selected;
        }

        protected void func_148123_a() {
        }

        protected void func_192637_a(int entryID, int insideLeft, int yPos, int insideSlotHeight, int mouseXIn, int mouseYIn, float partialTicks) {
            WorldTypeNode node = ConfigWorldDataListGui.this.tree.getWorldList().get(entryID);
            String name = ((StringTypeNode)node.getField(WorldTypeNode.Fields.CONFIGURATION_NAME)).getValue();
            boolean hidden = !((BooleanTypeNode)node.getField(WorldTypeNode.Fields.SHOW_IN_LIST)).getValue();
            String type = ((StringTypeNode)node.getField(WorldTypeNode.Fields.WORLD_GENERATOR)).getValue();
            boolean primary = false;
            if (hidden && entryID == 0) {
                primary = true;
                for (WorldTypeNode n : ConfigWorldDataListGui.this.tree.getWorldList()) {
                    if (!((BooleanTypeNode)n.getField(WorldTypeNode.Fields.SHOW_IN_LIST)).getValue()) continue;
                    primary = false;
                }
            }
            ConfigWorldDataListGui.this.field_146289_q.func_175063_a(name, (float)(insideLeft + 10), (float)(yPos + 3), 0xFFFFFF);
            if (primary) {
                ConfigWorldDataListGui.this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"defaultworldgenerator-port.config.lst.primary", (Object[])new Object[0]), insideLeft + 14, yPos + 15, 0x88FF88);
            } else {
                ConfigWorldDataListGui.this.field_146289_q.func_78276_b(hidden ? I18n.func_135052_a((String)"defaultworldgenerator-port.config.lst.hidden", (Object[])new Object[0]) : I18n.func_135052_a((String)"defaultworldgenerator-port.config.lst.shown", (Object[])new Object[0]), insideLeft + 14, yPos + 15, hidden ? 0xFF8888 : 0x88FF88);
            }
            ConfigWorldDataListGui.this.field_146289_q.func_78276_b(type, insideLeft + this.field_148155_a / 2, yPos + 15, 0xEEEEEE);
        }

        public int func_148139_c() {
            if (this.func_148135_f() > 0) {
                return this.field_148155_a - 12;
            }
            return this.field_148155_a;
        }

        protected int func_148137_d() {
            return this.field_148151_d - 4;
        }
    }

    private static enum ButtonIds {
        SAVE(85),
        CANCEL(86),
        MOVE_UP(87),
        MOVE_DOWN(88),
        NEW(89),
        RESTORE(90),
        EDIT(91),
        DELETE(92);

        private final int btnId;

        private ButtonIds(int id) {
            this.btnId = id;
        }

        public int getBtnId() {
            return this.btnId;
        }

        private GuiButton getButton(ConfigWorldDataListGui window) {
            for (GuiButton b : window.field_146292_n) {
                if (b.field_146127_k != this.btnId) continue;
                return b;
            }
            return null;
        }
    }
}

