/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator;

import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringListTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.WorldTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.datapack.WorldWrapper;
import com.ezrol.terry.minecraft.defaultworldgenerator.lib.Log;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class WorldInitCommands {
    private WorldWrapper worldInfo;
    private boolean initDone;

    public WorldInitCommands(WorldWrapper worldInfo) {
        this.worldInfo = worldInfo;
        this.initDone = false;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void unload() {
        if (!this.initDone) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    private void runInitCommands(ICommandManager manager, World w) {
        StringListTypeNode commands = (StringListTypeNode)this.worldInfo.getWorldType().getField(WorldTypeNode.Fields.WORLD_LOAD_COMMANDS);
        for (String command : commands.getValue()) {
            manager.func_71556_a((ICommandSender)new VCommandSender(w), command);
        }
    }

    @SubscribeEvent
    public void onServerWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.type != TickEvent.Type.WORLD) {
            return;
        }
        int dim = event.world.field_73011_w.getDimension();
        if (dim != 0) {
            return;
        }
        if (this.initDone) {
            return;
        }
        ICommandManager manager = Optional.ofNullable(event.world.func_73046_m()).flatMap(s -> Optional.of(s.func_71187_D())).orElse(null);
        if (manager != null) {
            this.runInitCommands(manager, event.world);
            this.initDone = true;
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    private static class VCommandSender
    implements ICommandSender {
        private static final String name = "DWG_INIT";
        private World world;

        private VCommandSender(World w) {
            this.world = w;
        }

        public void func_145747_a(ITextComponent component) {
            Log.info(String.format("%s: %s", name, component.func_150260_c()));
        }

        public String func_70005_c_() {
            return name;
        }

        public boolean func_70003_b(int permLevel, String commandName) {
            return permLevel <= 2;
        }

        public BlockPos func_180425_c() {
            return this.world.func_175694_M();
        }

        public Vec3d func_174791_d() {
            BlockPos pos = this.func_180425_c();
            return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }

        public World func_130014_f_() {
            return this.world;
        }

        @Nullable
        public Entity func_174793_f() {
            return null;
        }

        public boolean func_174792_t_() {
            return false;
        }

        public void func_174794_a(CommandResultStats.Type type, int amount) {
        }

        @Nullable
        public MinecraftServer func_184102_h() {
            return this.world.func_73046_m();
        }
    }
}

