/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.lib.huffstruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class StructNode {
    public abstract List<StructNode> getArray();

    public abstract byte[] getBinaryString();

    public static StructNode newArray() {
        return new ListNode(new ArrayList());
    }

    public static StructNode newArray(List<StructNode> lst) {
        return new ListNode(lst);
    }

    public static StructNode newBinaryString(byte[] s) {
        return new StringNode(s);
    }

    private static class StringNode
    extends StructNode {
        private final byte[] nodeData;

        private StringNode(byte[] dat) {
            this.nodeData = dat;
        }

        @Override
        public List<StructNode> getArray() {
            return null;
        }

        @Override
        public byte[] getBinaryString() {
            return this.nodeData;
        }

        public String toString() {
            return "StringNode{nodeData=" + Arrays.toString(this.nodeData) + '}';
        }
    }

    private static class ListNode
    extends StructNode {
        private final List nodeList;

        private ListNode(List<StructNode> lst) {
            this.nodeList = lst;
        }

        @Override
        public List<StructNode> getArray() {
            return this.nodeList;
        }

        @Override
        public byte[] getBinaryString() {
            return null;
        }

        public String toString() {
            return "ListNode{nodeList=" + this.nodeList + '}';
        }
    }
}

