/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.util.Location2I;
import chanceCubes.util.RewardBlockCache;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class MazeGenerator {
    private int width;
    private int height;
    private int[][] map;
    private ArrayList<Location2I> walls = new ArrayList();
    private RewardBlockCache cache;
    private Random r = new Random();
    private int currentX = 1;
    private int currentY = 1;
    private final int nonWall = 0;
    private final int wall = 1;
    private BlockPos startPos;
    private Location2I endBlock;
    public BlockPos endBlockWorldCords;

    public MazeGenerator(World world, BlockPos pos, BlockPos playerPos) {
        this.cache = new RewardBlockCache(world, pos, playerPos);
        this.startPos = pos;
    }

    public void generate(World world, int width, int height) {
        this.width = width;
        this.height = height;
        this.map = new int[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.map[x][y] = 1;
            }
        }
        this.map[1][1] = 0;
        this.walls.add(new Location2I(1, 1));
        Location2I current = new Location2I(0, 0);
        Location2I north = new Location2I(0, 0);
        Location2I east = new Location2I(0, 0);
        Location2I south = new Location2I(0, 0);
        Location2I west = new Location2I(0, 0);
        do {
            int randomLoc = this.r.nextInt(this.walls.size());
            this.currentX = this.walls.get(randomLoc).getX();
            this.currentY = this.walls.get(randomLoc).getY();
            current.setXY(this.currentX, this.currentY);
            north = current.add(0, -1);
            east = current.add(1, 0);
            south = current.add(0, 1);
            west = current.add(-1, 0);
            if (!this.checkwalls(current)) {
                this.map[this.currentX][this.currentY] = 0;
                this.walls.remove(randomLoc);
                if (north.getY() > 0 && this.map[north.getX()][north.getY()] == 1 && this.map[north.getX()][north.getY() - 1] == 1 && !this.walls.contains(north)) {
                    this.walls.add(north);
                }
                if (east.getX() + 1 < width && this.map[east.getX()][east.getY()] == 1 && this.map[east.getX() + 1][east.getY()] == 1 && !this.walls.contains(east)) {
                    this.walls.add(east);
                }
                if (south.getY() + 1 < height && this.map[south.getX()][south.getY()] == 1 && this.map[south.getX()][south.getY() + 1] == 1 && !this.walls.contains(south)) {
                    this.walls.add(south);
                }
                if (west.getX() <= 0 || this.map[west.getX()][west.getY()] != 1 || this.map[west.getX() - 1][west.getY()] != 1 || this.walls.contains(west)) continue;
                this.walls.add(west);
                continue;
            }
            this.walls.remove(randomLoc);
        } while (this.walls.size() > 0);
        int endBlockX = width - 1;
        int endBlockZ = height - 1;
        boolean run = true;
        int i = 0;
        int xx = 0;
        int zz = 0;
        while (run) {
            for (xx = 0; xx <= i; ++xx) {
                for (zz = i; zz >= 0; --zz) {
                    if (this.map[endBlockX - xx][endBlockZ - zz] != this.nonWall || !run) continue;
                    this.endBlock = new Location2I(endBlockX - xx, endBlockZ - zz);
                    run = false;
                }
            }
            ++i;
        }
        this.placeBlocks(world);
    }

    private boolean checkwalls(Location2I loc) {
        Location2I north = loc.add(0, -1);
        Location2I east = loc.add(1, 0);
        Location2I south = loc.add(0, 1);
        Location2I west = loc.add(-1, 0);
        int yes = 0;
        if (north.getY() >= 0 && this.map[north.getX()][north.getY()] == 0) {
            ++yes;
        }
        if (east.getX() < this.width && this.map[east.getX()][east.getY()] == 0) {
            ++yes;
        }
        if (south.getY() < this.height && this.map[south.getX()][south.getY()] == 0) {
            ++yes;
        }
        if (west.getX() >= 0 && this.map[west.getX()][west.getY()] == 0) {
            ++yes;
        }
        return yes > 1;
    }

    private void placeBlocks(World world) {
        int xoff = -(this.width / 2);
        int zoff = -(this.height / 2);
        for (int xx = 0; xx < this.width; ++xx) {
            for (int zz = 0; zz < this.height; ++zz) {
                if (this.map[xx][zz] == 0) {
                    this.cache.cacheBlock(new BlockPos(xoff + xx, -1, zoff + zz), Blocks.field_150357_h.func_176223_P());
                    this.cache.cacheBlock(new BlockPos(xoff + xx, 0, zoff + zz), Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.UP));
                    this.cache.cacheBlock(new BlockPos(xoff + xx, 1, zoff + zz), Blocks.field_150350_a.func_176223_P());
                    this.cache.cacheBlock(new BlockPos(xoff + xx, 2, zoff + zz), Blocks.field_150357_h.func_176223_P());
                    continue;
                }
                this.cache.cacheBlock(new BlockPos(xoff + xx, -1, zoff + zz), Blocks.field_150350_a.func_176223_P());
                this.cache.cacheBlock(new BlockPos(xoff + xx, 0, zoff + zz), Blocks.field_150357_h.func_176223_P());
                this.cache.cacheBlock(new BlockPos(xoff + xx, 1, zoff + zz), Blocks.field_150357_h.func_176223_P());
                this.cache.cacheBlock(new BlockPos(xoff + xx, 2, zoff + zz), Blocks.field_150350_a.func_176223_P());
            }
        }
        this.endBlockWorldCords = new BlockPos(this.startPos.func_177958_n() + xoff + this.endBlock.getX(), this.startPos.func_177956_o(), this.startPos.func_177952_p() + zoff + this.endBlock.getY());
        this.cache.cacheBlock(new BlockPos(xoff + this.endBlock.getX(), 0, zoff + this.endBlock.getY()), Blocks.field_150472_an.func_176223_P().func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf(7)));
        TileEntity te = world.func_175625_s(new BlockPos(this.startPos.func_177958_n() + xoff + this.endBlock.getX(), this.startPos.func_177956_o(), this.startPos.func_177952_p() + zoff + this.endBlock.getY()));
        if (te instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)te;
            sign.field_145915_a[0] = new TextComponentString("Break me");
            sign.field_145915_a[1] = new TextComponentString("To beat the");
            sign.field_145915_a[2] = new TextComponentString("Maze");
        }
    }

    public void endMaze(World world, EntityPlayer player) {
        this.cache.restoreBlocks((Entity)player);
    }
}

