/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.CCubesDamageSource;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class MatchingReward
extends BaseCustomReward {
    public MatchingReward() {
        super("chancecubes:Matching", 0);
    }

    @Override
    public void trigger(final World world, final BlockPos pos, final EntityPlayer player) {
        int i;
        final int[] metas = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4};
        final RewardBlockCache cache = new RewardBlockCache(world, pos, player.func_180425_c());
        for (i = 0; i < 500; ++i) {
            int index1 = RewardsUtil.rand.nextInt(9);
            int index2 = RewardsUtil.rand.nextInt(9);
            int metaTemp = metas[index1];
            metas[index1] = metas[index2];
            metas[index2] = metaTemp;
        }
        for (i = 0; i < metas.length; ++i) {
            int x = i % 3 - 1;
            int z = i / 3 - 1;
            cache.cacheBlock(new BlockPos(x, -1, z), RewardsUtil.getBlockStateFromBlockMeta(Blocks.field_150325_L, metas[i]));
        }
        player.func_145747_a((ITextComponent)new TextComponentString("Memerize these blocks!"));
        Scheduler.scheduleTask(new Task("Matching_Reward_Memerize_Delay", 200, 20){

            @Override
            public void callback() {
                for (int i = 0; i < metas.length; ++i) {
                    int x = i % 3 - 1;
                    int z = i / 3 - 1;
                    world.func_175656_a(pos.func_177982_a(x, -1, z), Blocks.field_150359_w.func_176223_P());
                }
                MatchingReward.this.match(world, pos, player, metas, cache);
            }

            @Override
            public void update() {
                this.showTimeLeft(player, SPacketTitle.Type.ACTIONBAR);
            }
        });
    }

    public void match(final World world, final BlockPos pos, final EntityPlayer player, final int[] metas, final RewardBlockCache cache) {
        player.func_145747_a((ITextComponent)new TextComponentString("Now break the matching blocks (in pairs with white last)! You have 45 seconds!"));
        Scheduler.scheduleTask(new Task("Matching_Reward_Memerize_Delay", 900, 2){
            boolean[] checked;
            int lastBroken;
            int matches;
            {
                super(name, delay, updateTick);
                this.checked = new boolean[9];
                this.lastBroken = -1;
                this.matches = 0;
            }

            @Override
            public void callback() {
                this.lose();
            }

            @Override
            public void update() {
                if (this.delayLeft % 20 == 0 && this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, SPacketTitle.Type.ACTIONBAR);
                }
                for (int i = 0; i < metas.length; ++i) {
                    int x = i % 3 - 1;
                    int z = i / 3 - 1;
                    if (!world.func_175623_d(pos.func_177982_a(x, -1, z)) || this.checked[i]) continue;
                    this.checked[i] = true;
                    world.func_175656_a(pos.func_177982_a(x, -1, z), RewardsUtil.getBlockStateFromBlockMeta(Blocks.field_150325_L, metas[i]));
                    if (this.lastBroken != -1) {
                        if (metas[i] == metas[this.lastBroken]) {
                            ++this.matches;
                            this.lastBroken = -1;
                            break;
                        }
                        this.lose();
                        Scheduler.removeTask(this);
                        break;
                    }
                    this.lastBroken = i;
                    if (this.matches != 4) continue;
                    this.win();
                    Scheduler.removeTask(this);
                    break;
                }
            }

            private void lose() {
                player.field_70170_p.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, false);
                player.func_70097_a((DamageSource)CCubesDamageSource.MATCHING_FAIL, Float.MAX_VALUE);
                this.reset();
            }

            private void win() {
                player.func_145747_a((ITextComponent)new TextComponentString("Good job! Have a cool little item!"));
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(RewardsUtil.getRandomItem(), 1)));
                this.reset();
            }

            public void reset() {
                cache.restoreBlocks((Entity)player);
            }
        });
    }
}

