/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.registry;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.items.ItemChancePendant;
import chanceCubes.registry.IRewardRegistry;
import chanceCubes.rewards.IChanceCubeReward;
import chanceCubes.rewards.defaultRewards.AnvilRain;
import chanceCubes.rewards.defaultRewards.ArmorStandArmorReward;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.defaultRewards.BookOfMemesReward;
import chanceCubes.rewards.defaultRewards.CakeIsALieReward;
import chanceCubes.rewards.defaultRewards.ChanceCubeRenameReward;
import chanceCubes.rewards.defaultRewards.ClearInventoryReward;
import chanceCubes.rewards.defaultRewards.CoinFlipReward;
import chanceCubes.rewards.defaultRewards.CountDownReward;
import chanceCubes.rewards.defaultRewards.CreeperSurroundedReward;
import chanceCubes.rewards.defaultRewards.CustomUserReward;
import chanceCubes.rewards.defaultRewards.DidYouKnowReward;
import chanceCubes.rewards.defaultRewards.DigBuildReward;
import chanceCubes.rewards.defaultRewards.DoubleRainbow;
import chanceCubes.rewards.defaultRewards.HerobrineReward;
import chanceCubes.rewards.defaultRewards.ItemChestReward;
import chanceCubes.rewards.defaultRewards.ItemOfDestinyReward;
import chanceCubes.rewards.defaultRewards.ItemRenamer;
import chanceCubes.rewards.defaultRewards.JukeBoxReward;
import chanceCubes.rewards.defaultRewards.MagicFeetReward;
import chanceCubes.rewards.defaultRewards.MatchingReward;
import chanceCubes.rewards.defaultRewards.MathReward;
import chanceCubes.rewards.defaultRewards.MazeReward;
import chanceCubes.rewards.defaultRewards.MobEffectsReward;
import chanceCubes.rewards.defaultRewards.MobTowerReward;
import chanceCubes.rewards.defaultRewards.MontyHallReward;
import chanceCubes.rewards.defaultRewards.OneIsLuckyReward;
import chanceCubes.rewards.defaultRewards.QuestionsReward;
import chanceCubes.rewards.defaultRewards.RainingCatsAndCogsReward;
import chanceCubes.rewards.defaultRewards.SkyblockReward;
import chanceCubes.rewards.defaultRewards.SurroundedReward;
import chanceCubes.rewards.defaultRewards.TableFlipReward;
import chanceCubes.rewards.defaultRewards.TicTacToeReward;
import chanceCubes.rewards.defaultRewards.TrollTNTReward;
import chanceCubes.rewards.defaultRewards.WaitForItReward;
import chanceCubes.rewards.defaultRewards.WitherReward;
import chanceCubes.rewards.defaultRewards.WolvesToCreepersReward;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardparts.EffectPart;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardparts.ExpirencePart;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.rewards.rewardparts.ParticlePart;
import chanceCubes.rewards.rewardparts.SoundPart;
import chanceCubes.rewards.rewardtype.BlockRewardType;
import chanceCubes.rewards.rewardtype.CommandRewardType;
import chanceCubes.rewards.rewardtype.EffectRewardType;
import chanceCubes.rewards.rewardtype.EntityRewardType;
import chanceCubes.rewards.rewardtype.ExperienceRewardType;
import chanceCubes.rewards.rewardtype.ItemRewardType;
import chanceCubes.rewards.rewardtype.MessageRewardType;
import chanceCubes.rewards.rewardtype.ParticleEffectRewardType;
import chanceCubes.rewards.rewardtype.SchematicRewardType;
import chanceCubes.rewards.rewardtype.SoundRewardType;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.rewards.variableTypes.StringVar;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardData;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.SchematicUtil;
import chanceCubes.util.Task;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

public class ChanceCubeRegistry
implements IRewardRegistry {
    public static ChanceCubeRegistry INSTANCE = new ChanceCubeRegistry();
    private List<IChanceCubeReward> customRewards = Lists.newArrayList();
    private Map<String, IChanceCubeReward> nameToReward = Maps.newHashMap();
    private List<IChanceCubeReward> sortedRewards = Lists.newArrayList();
    private Map<String, IChanceCubeReward> disabledNameToReward = Maps.newHashMap();
    private static IChanceCubeReward lastReward = null;
    private static List<IChanceCubeReward> cooldownList = new ArrayList<IChanceCubeReward>();

    public static void loadDefaultRewards() {
        RewardsUtil.initData();
        if (!CCubesSettings.enableHardCodedRewards) {
            return;
        }
        INSTANCE.registerReward(new BasicReward("chancecubes:Tnt_Structure", -30, new BlockRewardType(RewardsUtil.addBlocksLists(RewardsUtil.fillArea(3, 1, 3, Blocks.field_150335_W, -1, 0, -1, true, 0, false, false), RewardsUtil.fillArea(3, 1, 3, Blocks.field_150451_bX, -1, 1, -1, true, 40, true, false)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Bedrock", -20, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.field_150357_h, false))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Redstone_Diamond", 10, new ItemRewardType(RewardsUtil.generateItemParts(Items.field_151137_ax, Items.field_151045_i))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Sethbling_Reward", 30, new MessageRewardType(new MessagePart("Welcome back, SethBling here :)")), new ItemRewardType(RewardsUtil.generateItemParts(new ItemStack(Items.field_151137_ax, 32), new ItemStack(Items.field_151107_aW, 3), new ItemStack(Items.field_151132_bS, 3), new ItemStack(Blocks.field_150379_bu, 3), new ItemStack(Blocks.field_150429_aA, 3)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:EXP", 35, new ExperienceRewardType(new ExpirencePart(100).setNumberofOrbs(10))));
        INSTANCE.registerReward(new BasicReward("chancecubes:EXP_Shower", 35, new ExperienceRewardType(new ExpirencePart(10), new ExpirencePart(10, 10), new ExpirencePart(10, 10), new ExpirencePart(10, 20), new ExpirencePart(10, 30), new ExpirencePart(10, 40), new ExpirencePart(10, 50), new ExpirencePart(10, 60), new ExpirencePart(10, 70), new ExpirencePart(10, 80), new ExpirencePart(10, 90), new ExpirencePart(10, 100), new ExpirencePart(10, 110), new ExpirencePart(10, 120), new ExpirencePart(10, 130), new ExpirencePart(10, 140), new ExpirencePart(10, 150))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Poison", -25, new EffectRewardType(new EffectPart(MobEffects.field_76436_u, 25, 1).setRadius(30))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Wither_Status_Effect", -25, new EffectRewardType(new EffectPart(new StringVar(String.valueOf(Potion.func_188409_a((Potion)MobEffects.field_82731_v))), new IntVar(new Integer[]{3, 5, 6, 8, 10}), new IntVar(new Integer[]{1, 2})).setRadius(30))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Chat_Message", 0, new MessageRewardType(new MessagePart("You have escaped the wrath of the Chance Cubes........."), new MessagePart("For now......"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Hearts", 0, new ParticleEffectRewardType(RewardsUtil.spawnXParticles(34, 5))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Explosion", 0, new ParticleEffectRewardType(new ParticlePart(2)), new SoundRewardType(new SoundPart(SoundEvents.field_187539_bB))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Wool", 25, new ItemRewardType(RewardsUtil.generateItemParts(new ItemStack(Blocks.field_150325_L, 4, 0), new ItemStack(Blocks.field_150325_L, 4, 1), new ItemStack(Blocks.field_150325_L, 4, 2), new ItemStack(Blocks.field_150325_L, 4, 3), new ItemStack(Blocks.field_150325_L, 4, 4), new ItemStack(Blocks.field_150325_L, 4, 5), new ItemStack(Blocks.field_150325_L, 4, 6), new ItemStack(Blocks.field_150325_L, 4, 7), new ItemStack(Blocks.field_150325_L, 4, 8), new ItemStack(Blocks.field_150325_L, 4, 9), new ItemStack(Blocks.field_150325_L, 4, 10), new ItemStack(Blocks.field_150325_L, 4, 11), new ItemStack(Blocks.field_150325_L, 4, 12), new ItemStack(Blocks.field_150325_L, 4, 13), new ItemStack(Blocks.field_150325_L, 4, 14), new ItemStack(Blocks.field_150325_L, 4, 15)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Enchanting", 80, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150381_bn)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Bookshelves", 60, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150342_X, 8)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Ores_Galore", 50, new ItemRewardType(RewardsUtil.generateItemParts(Items.field_151044_h, Items.field_151137_ax, Items.field_151042_j, Items.field_151043_k, Items.field_151045_i, Items.field_151166_bC))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Have_Another", -10, new ItemRewardType(new ItemPart(new ItemStack((Block)CCubesBlocks.CHANCE_CUBE, 3))), new MessageRewardType(new MessagePart("I hear you like Chance Cubes."), new MessagePart("So I put some Chance Cubes in your Chance Cubes!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Icsahedron", 0, new ItemRewardType(new ItemPart(new ItemStack((Block)CCubesBlocks.CHANCE_ICOSAHEDRON)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Saplings", 35, new MessageRewardType(new MessagePart("Seems you have purchased the saplings DLC")), new ItemRewardType(RewardsUtil.generateItemParts(new ItemStack(Blocks.field_150345_g, 4, 0), new ItemStack(Blocks.field_150345_g, 4, 1), new ItemStack(Blocks.field_150345_g, 4, 2), new ItemStack(Blocks.field_150345_g, 4, 3), new ItemStack(Blocks.field_150345_g, 4, 4), new ItemStack(Blocks.field_150345_g, 4, 5)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Farmer", 35, new MessageRewardType(new MessagePart("Time to farm!")), new ItemRewardType(new ItemPart(new ItemStack(Items.field_151019_K)), new ItemPart(new ItemStack(Items.field_151133_ar)), new ItemPart(new ItemStack(Items.field_151014_N, 16)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Rancher", 60, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_180407_aO, 32)), new ItemPart(RewardsUtil.getSpawnEggForEntity(new ResourceLocation("Pig"))), new ItemPart(RewardsUtil.getSpawnEggForEntity(new ResourceLocation("Cow"))), new ItemPart(RewardsUtil.getSpawnEggForEntity(new ResourceLocation("Sheep"))))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Fighter", 25, new MessageRewardType(new MessagePart("SPARTAAA!!!")), new ItemRewardType(RewardsUtil.generateItemParts(new Item[]{Items.field_151040_l, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab}))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Pssst", -5, new MessageRewardType(new MessagePart("Pssssst.... Over here!")), new EntityRewardType(new EntityPart(EntityRewardType.getBasicNBTForEntity("Creeper")))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Explorer", 30, new MessageRewardType(new MessagePart("Lets go on a journey!")), new ItemRewardType(RewardsUtil.generateItemParts(new ItemStack(Items.field_151111_aL), new ItemStack(Items.field_151113_aN), new ItemStack(Blocks.field_150478_aa, 64), new ItemStack(Items.field_151035_b)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Mitas", 50, new ItemRewardType(RewardsUtil.generateItemParts(new ItemStack(Items.field_151074_bl, 32), new ItemStack(Items.field_151043_k, 8), new ItemStack(Items.field_151150_bK, 16), new ItemStack((Item)Items.field_151169_ag)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Horde", -25, new MessageRewardType(new MessagePart("Release the horde!")), new EntityRewardType(RewardsUtil.spawnXEntities(EntityRewardType.getBasicNBTForEntity("Zombie"), 15))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Lava_Ring", -40, new BlockRewardType(new OffsetBlock(1, -1, 0, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, 1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 0, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, -1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, -1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, -1, (Block)Blocks.field_150353_l, false).setRelativeToPlayer(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Rain", -5, new CommandRewardType(new CommandPart("/weather thunder 20000"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Silverfish_Surround", -20, new BlockRewardType(new OffsetBlock(1, 0, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(1, 1, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, 1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, 1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(-1, 0, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(-1, 1, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, -1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, -1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 2, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Fish_Dog", 20, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151115_aP, 5)), new ItemPart(RewardsUtil.getSpawnEggForEntity(new ResourceLocation("wolf"))))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Bone_Cat", 20, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151103_aS, 5)), new ItemPart(RewardsUtil.getSpawnEggForEntity(new ResourceLocation("ocelot"))))));
        INSTANCE.registerReward(new BasicReward("chancecubes:XP_Crystal", -60, new CommandRewardType(new CommandPart("/summon xp_orb ~ ~1 ~ {Value:1,Passengers:[{id:\"ender_crystal\"}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:TNT_Cat", -25, new CommandRewardType(new CommandPart("/summon ocelot ~ ~1 ~ {CatType:0,Sitting:0,Passengers:[{id:\"tnt\",Fuse:80}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Slime_Man", 10, new CommandRewardType(new CommandPart("/summon slime ~ ~1 ~ {Size:3,Glowing:1b,Passengers:[{id:\"Slime\",Size:2,Glowing:1b,Passengers:[{id:\"Slime\",CustomName:\"Slime Man\",CustomNameVisible:1,Size:1,Glowing:1b}]}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Sail_Away", 5, new BlockRewardType(new OffsetBlock(0, -1, 0, (Block)Blocks.field_150355_j, false)), new CommandRewardType(new CommandPart("/summon Boat %x %y %z")), new MessageRewardType(new MessagePart("Come sail away!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Witch", -15, new CommandRewardType(new CommandPart("/summon witch %x %y %z "))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Cluckington", 25, new CommandRewardType(new CommandPart("/summon Chicken ~ ~1 ~ {CustomName:\"Cluckington\",CustomNameVisible:1,ActiveEffects:[{Id:1,Amplifier:3,Duration:199980}],Passengers:[{id:\"Zombie\",CustomName:\"wyld\",CustomNameVisible:1,IsVillager:0,IsBaby:1,ArmorItems:[{},{},{},{id:\"minecraft:skull\",Damage:3,tag:{SkullOwner:\"wyld\"},Count:1}]}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Jerry", 25, new CommandRewardType(new CommandPart("/summon slime %x %y %z {Size:1,CustomName:\"Jerry\",CustomNameVisible:1}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Glenn", 25, new CommandRewardType(new CommandPart("/summon zombie %x %y %z {CustomName:\"Glenn\",CustomNameVisible:1}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Dr_Trayaurus", 25, new CommandRewardType(new CommandPart("/summon villager %x %y %z {CustomName:\"Dr Trayaurus\",CustomNameVisible:1,Profession:1}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Pickles", 25, new CommandRewardType(new CommandPart("/summon mooshroom ~ ~1 ~ {Age:-10000,CustomName:\"Pickles\"}")), new MessageRewardType(new MessagePart("Why is his name pickles? The world may never know"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Want_To_Build_A_Snowman", 45, new MessageRewardType(new MessagePart("Do you want to build a snowman?")), new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150433_aE, 2)), new ItemPart(new ItemStack(Blocks.field_150423_aK)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Diamond_Block", 85, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.field_150484_ah, true, 200))));
        INSTANCE.registerReward(new BasicReward("chancecubes:TNT_Diamond", -35, new BlockRewardType(new OffsetBlock(0, 1, 0, Blocks.field_150484_ah, false), new OffsetBlock(0, -1, 0, Blocks.field_150484_ah, false), new OffsetBlock(1, 0, 0, Blocks.field_150484_ah, false), new OffsetBlock(-1, 0, 0, Blocks.field_150484_ah, false), new OffsetBlock(0, 0, 1, Blocks.field_150484_ah, false), new OffsetBlock(0, 0, -1, Blocks.field_150484_ah, false)), new CommandRewardType(RewardsUtil.executeXCommands("/summon tnt %x %y %z {Fuse:40}", 3, 5))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Anti_Slab", -15, new BlockRewardType(RewardsUtil.fillArea(3, 1, 3, Blocks.field_150343_Z, -1, 2, -1, false, 0, false, true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Chance_Cube_Cube", -10, new MessageRewardType(new MessagePart("Hey, at least it isn't a Giant Chance Cube >:)")), new BlockRewardType(RewardsUtil.fillArea(2, 2, 2, CCubesBlocks.CHANCE_CUBE, -2, 0, -2, false, 1, false, false))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Fake_TNT", 0, new SoundRewardType(new SoundPart(SoundEvents.field_187904_gd), new SoundPart(SoundEvents.field_187904_gd), new SoundPart(SoundEvents.field_187904_gd), new SoundPart(SoundEvents.field_187539_bB, 120).setAtPlayersLocation(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Invisible_Ghasts", 0, new SoundRewardType(new SoundPart(SoundEvents.field_189105_bM).setServerWide(true), new SoundPart(SoundEvents.field_187559_bL).setServerWide(true), new SoundPart(SoundEvents.field_187559_bL).setServerWide(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:No", 0, new BlockRewardType(new OffsetBlock(0, 0, 0, (Block)CCubesBlocks.CHANCE_CUBE, false)), new MessageRewardType(new MessagePart("No"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Invisible_Creeper", -30, new CommandRewardType(new CommandPart("/summon Creeper %x %y %z {ActiveEffects:[{Id:14,Amplifier:0,Duration:200,ShowParticles:0b}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Knockback_Zombie", -35, new CommandRewardType(new CommandPart("/summon Zombie ~ ~1 ~ {CustomName:\"Leonidas\",CustomNameVisible:1,IsVillager:0,IsBaby:1,HandItems:[{id:stick,Count:1,tag:{AttributeModifiers:[{AttributeName:\"generic.knockbackResistance\",Name:\"generic.knockbackResistance\",Amount:100,Operation:0,UUIDLeast:724513,UUIDMost:715230}],ench:[{id:19,lvl:100}],display:{Name:\"The Spartan Kick\"}}},{}],HandDropChances:[0.0F,0.085F],ActiveEffects:[{Id:1,Amplifier:5,Duration:199980,ShowParticles:0b},{Id:8,Amplifier:2,Duration:199980}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Actual_Invisible_Ghast", -80, new CommandRewardType(new CommandPart("/summon Ghast ~ ~10 ~ {ActiveEffects:[{Id:14,Amplifier:0,Duration:2000,ShowParticles:0b}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Giant_Chance_Cube", -45, new BlockRewardType(RewardsUtil.fillArea(3, 3, 3, CCubesBlocks.CHANCE_CUBE, -1, 0, -1, false, 0, true, false))), false);
        INSTANCE.registerReward(new BasicReward("chancecubes:Fireworks", 5, new CommandRewardType(RewardsUtil.executeXCommands("/summon fireworks_rocket ~ ~1 ~ {LifeTime:15,FireworksItem:{id:fireworks,Count:1,tag:{Fireworks:{Explosions:[{Type:0,Colors:[I;16711680],FadeColors:[I;16711680]}]}}}}", 4))));
        INSTANCE.registerReward(new BasicReward("chancecubes:STRING!", 7, new BlockRewardType(RewardsUtil.fillArea(11, 5, 11, Blocks.field_150473_bD, -5, 0, -5, false, 0, false, true)), new MessageRewardType(new MessagePart("STRING!!!!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:CARPET!", 7, new BlockRewardType(RewardsUtil.fillArea(11, 5, 11, Blocks.field_150404_cg, -5, 0, -5, false, 0, false, true)), new MessageRewardType(new MessagePart("CARPET!!!!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:TNT_Bats", -50, new CommandRewardType(RewardsUtil.executeXCommands("/summon Bat ~ ~1 ~ {Passengers:[{id:\"tnt\",Fuse:80}]}", 10))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Nether_Jelly_Fish", -40, new CommandRewardType(RewardsUtil.executeXCommands("/summon bat ~ ~1 ~ {Passengers:[{id:\"magma_cube\",CustomName:\"Nether Jelly Fish\",CustomNameVisible:1,Size:3}]}", 10))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Pig_Of_Destiny", 15, new CommandRewardType(new CommandPart("/summon Pig ~ ~1 ~ {CustomName:\"The Pig of Destiny\",CustomNameVisible:1,ArmorItems:[{},{},{id:diamond_chestplate,Count:1,tag:{ench:[{id:7,lvl:1000}]}},{}],ArmorDropChances:[0.085F,0.085F,0.0F,0.085F]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Squid_Horde", 5, new MessageRewardType(new MessagePart("Release the horde!").setRange(32), new MessagePart("Of squids!!", 20).setRange(32)), new EntityRewardType(RewardsUtil.spawnXEntities(EntityRewardType.getBasicNBTForEntity("Squid"), 15)), new BlockRewardType(RewardsUtil.fillArea(3, 2, 3, (Block)Blocks.field_150355_j, -1, 0, -1, false, 5, true, false))));
        INSTANCE.registerReward(new BasicReward("chancecubes:D-rude_SandStorm", -10, new BlockRewardType(RewardsUtil.fillArea(5, 3, 5, (Block)Blocks.field_150354_m, -2, 0, -2, true, 0, false, true)), new MessageRewardType(new MessagePart("Well that was D-rude", 40))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Ice_Cold", -10, new BlockRewardType(RewardsUtil.fillArea(5, 3, 5, Blocks.field_150432_aD, -2, 0, -2, false, 0, false, true)), new MessageRewardType(new MessagePart("<Shinauko> You're as cold as ice"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:DIY_Pie", 5, new BlockRewardType(new OffsetBlock(1, 0, 0, Blocks.field_150423_aK, false), new OffsetBlock(1, 1, 0, (Block)Blocks.field_150436_aH, false)), new CommandRewardType(new CommandPart("/summon Chicken ~ ~1 ~ {CustomName:\"Zeeth_Kyrah\",CustomNameVisible:1}")), new MessageRewardType(new MessagePart("Do it yourself Pumpkin Pie!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Watch_World_Burn", -5, new BlockRewardType(RewardsUtil.fillArea(7, 1, 7, (Block)Blocks.field_150480_ab, -3, 0, -3, false, 0, true, true)), new MessageRewardType(new MessagePart("Some people just want to watch the world burn."))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Coal_To_Diamonds", 10, new BlockRewardType(new OffsetBlock(0, 1, 0, Blocks.field_150402_ci, false), new OffsetBlock(0, -1, 0, Blocks.field_150402_ci, false), new OffsetBlock(1, 0, 0, Blocks.field_150402_ci, false), new OffsetBlock(-1, 0, 0, Blocks.field_150402_ci, false), new OffsetBlock(0, 0, 1, Blocks.field_150402_ci, false), new OffsetBlock(0, 0, -1, Blocks.field_150402_ci, false)), new CommandRewardType(RewardsUtil.executeXCommands("/summon tnt %x %y %z {Fuse:40}", 3, 5)), new ItemRewardType(new ItemPart(new ItemStack(Items.field_151045_i, 5), 50))));
        INSTANCE.registerReward(new BasicReward("chancecubes:SpongeBob_SquarePants", 15, new CommandRewardType(new CommandPart("/summon Item ~ ~ ~ {Item:{id:sponge,Count:1,tag:{display:{Name:\"SpongeBob\"}}}}"), new CommandPart("/summon Item ~ ~ ~ {Item:{id:leather_leggings,Count:1,tag:{display:{Name:\"SquarePants\"}}}}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Hot_Tub", -15, new BlockRewardType(RewardsUtil.addBlocksLists(RewardsUtil.fillArea(7, 1, 7, (Block)Blocks.field_150355_j, -3, -1, -3, false, 0, true, true), RewardsUtil.fillArea(7, 1, 7, Blocks.field_150350_a, -3, -1, -3, false, 98, true, true), RewardsUtil.fillArea(7, 1, 7, (Block)Blocks.field_150353_l, -3, -1, -3, false, 100, true, true))), new MessageRewardType(new MessagePart("No no no. I wanted a hot tub!", 40))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Quidditch", -30, new CommandRewardType(RewardsUtil.executeXCommands("/summon Bat ~ ~ ~ {Passengers:[{id:\"Witch\"}]}", 7)), new MessageRewardType(new MessagePart("Quidditch anyone?").setRange(32))));
        INSTANCE.registerReward(new BasicReward("chancecubes:One_Man_Army", -10, new EntityRewardType(new EntityPart(EntityRewardType.getBasicNBTForEntity("zombie_pigman"))), new CommandRewardType(RewardsUtil.executeXCommands("/summon zombie_pigman ~ ~ ~ {Silent:1,ActiveEffects:[{Id:14,Amplifier:0,Duration:19980,ShowParticles:1b}]}", 9)), new MessageRewardType(new MessagePart("One man army").setRange(32))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Cuteness", 10, new CommandRewardType(RewardsUtil.executeXCommands("/summon rabbit ~ ~1 ~ {CustomName:\"Fluffy\",CustomNameVisible:1,RabbitType:5}", 20)), new MessageRewardType(new MessagePart("Cuteness overload!").setRange(32))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Silvermite_Stacks", -35, new CommandRewardType(RewardsUtil.executeXCommands("/summon Silverfish ~ ~1 ~ {Passengers:[{id:\"Endermite\",Passengers:[{id:\"Silverfish\",Passengers:[{id:\"Endermite\",Passengers:[{id:\"Silverfish\",Passengers:[{id:\"Endermite\",Passengers:[{id:\"Silverfish\",Passengers:[{id:\"Endermite\",Passengers:[{id:\"Silverfish\",Passengers:[{id:\"Endermite\",Passengers:[{id:\"Silverfish\"}]}]}]}]}]}]}]}]}]}]}", 5))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Take_This", 55, new BlockRewardType(RewardsUtil.addBlocksLists(RewardsUtil.fillArea(1, 3, 1, Blocks.field_150336_V, 0, 0, 0, false, 1, false, false), RewardsUtil.fillArea(1, 3, 1, Blocks.field_150350_a, 0, 0, 0, false, 0, false, false))), new CommandRewardType(new CommandPart("/summon item_frame ~ ~ ~1 {Item:{id:\"minecraft:stick\", Count:1b},Facing:0,ItemRotation:7}", 2), new CommandPart("/summon item_frame ~ ~1 ~1 {Item:{id:\"minecraft:diamond\", Count:1b},Facing:0,ItemRotation:0}", 2), new CommandPart("/summon item_frame ~ ~2 ~1 {Item:{id:\"minecraft:diamond\", Count:1b},Facing:0,ItemRotation:0}", 2)), new MessageRewardType(new MessagePart("It's dangerous to go alone, here take this!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Invizible_Silverfish", -55, new CommandRewardType(RewardsUtil.executeXCommands("/summon Silverfish ~ ~1 ~ {Glowing:1b,ActiveEffects:[{Id:1,Amplifier:1,Duration:200000},{Id:14,Amplifier:0,Duration:20000}],Passengers:[{id:\"Silverfish\",ActiveEffects:[{Id:14,Amplifier:0,Duration:20000}]}]}", 5))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Arrow_Trap", -25, new SchematicRewardType(SchematicUtil.loadCustomSchematic(RewardData.getArrowTrapSchematic(), 1, -1, 1, 0.0f, false, true, true, true, 0))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Trampoline", 15, new MessageRewardType(new MessagePart("Time to bounce!")), new SchematicRewardType(SchematicUtil.loadCustomSchematic(RewardData.getTrampolineSchematic(), 1, -3, 1, 0.0f, false, true, true, true, 0)), new BlockRewardType(new OffsetBlock(2, -2, -2, Blocks.field_150451_bX, false, 3).setRelativeToPlayer(true).setCausesBlockUpdate(true), new OffsetBlock(2, -2, -2, (Block)Blocks.field_150488_af, false, 5).setRelativeToPlayer(true).setCausesBlockUpdate(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Skeleton_Bats", -40, new CommandRewardType(RewardsUtil.executeXCommands("/summon Bat ~ ~1 ~ {Passengers:[{id:\"Skeleton\",ArmorItems:[{},{},{},{id:leather_helmet,Count:1}],HandItems:[{id:bow,Count:1},{}]}]}", 10))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Cave_Spider_Web", -30, new BlockRewardType(RewardsUtil.fillArea(7, 4, 7, Blocks.field_150321_G, -3, 0, -3, false, 0, false, true)), new CommandRewardType(RewardsUtil.executeXCommands("/summon cave_spider ~ ~1 ~ {CustomName:\"CascadingDongs\",CustomNameVisible:1}", 6))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Guardians", -35, new BlockRewardType(RewardsUtil.fillArea(5, 5, 5, (Block)Blocks.field_150355_j, -2, 0, -2, false, 0, false, false)), new EntityRewardType(new EntityPart(EntityRewardType.getBasicNBTForEntity("guardian"), 5), new EntityPart(EntityRewardType.getBasicNBTForEntity("guardian"), 5))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Cookie_Monster", -5, new MessageRewardType(new MessagePart("Here have some cookies!").setRange(32), new MessagePart("[Cookie Monster] Hey! Those are mine!", 30).setRange(32)), new CommandRewardType(new CommandPart("/summon item ~ ~1 ~ {Item:{id:\"minecraft:cookie\",Count:8b}}"), new CommandPart("/summon zombie ~ ~1 ~ {CustomName:\"Cookie Monster\",CustomNameVisible:1,IsVillager:0,IsBaby:1}", 30))));
        NBTTagCompound nbt = new NBTTagCompound();
        ItemStack stack = new ItemStack(Items.field_151055_y);
        stack.func_77966_a(Enchantment.func_180305_b((String)"sharpness"), 5);
        stack.func_151001_c("A Big Stick");
        INSTANCE.registerReward(new BasicReward("chancecubes:Roosevelt's_Stick", 70, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Item)Items.field_151112_aM);
        stack.func_77964_b(stack.func_77958_k() / 2);
        INSTANCE.registerReward(new BasicReward("chancecubes:Half_Fishingrod", 5, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151153_ao, 1, 1);
        stack.func_151001_c("Notch");
        INSTANCE.registerReward(new BasicReward("chancecubes:Notch", 70, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151156_bN);
        stack.func_151001_c("North Star");
        INSTANCE.registerReward(new BasicReward("chancecubes:Nether_Star", 100, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151048_u);
        stack.func_77966_a(Enchantment.func_180305_b((String)"sharpness"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"unbreaking"), 10);
        stack.func_77964_b(stack.func_77958_k() - 2);
        stack.func_151001_c("The Divine Sword");
        INSTANCE.registerReward(new BasicReward("chancecubes:Divine_Sword", 95, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Item)Items.field_151161_ac);
        stack.func_77966_a(Enchantment.func_180305_b((String)"protection"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"aqua_affinity"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"unbreaking"), 10);
        stack.func_77964_b(stack.func_77958_k() - 2);
        stack.func_151001_c("The Divine Helmet");
        INSTANCE.registerReward(new BasicReward("chancecubes:Divine_Helmet", 95, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Item)Items.field_151163_ad);
        stack.func_77966_a(Enchantment.func_180305_b((String)"blast_protection"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"thorns"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"unbreaking"), 10);
        stack.func_77964_b(stack.func_77958_k() - 2);
        stack.func_151001_c("The Divine Chestplate");
        INSTANCE.registerReward(new BasicReward("chancecubes:Divine_Chestplate", 95, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Item)Items.field_151173_ae);
        stack.func_77966_a(Enchantment.func_180305_b((String)"projectile_protection"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"unbreaking"), 10);
        stack.func_77964_b(stack.func_77958_k() - 2);
        stack.func_151001_c("The Divine Leggings");
        INSTANCE.registerReward(new BasicReward("chancecubes:Divine_Leggings", 95, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Item)Items.field_151175_af);
        stack.func_77966_a(Enchantment.func_180305_b((String)"fire_protection"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"unbreaking"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"feather_falling"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"depth_strider"), 10);
        stack.func_77964_b(stack.func_77958_k() - 2);
        stack.func_151001_c("The Divine Boots");
        INSTANCE.registerReward(new BasicReward("chancecubes:Divine_Boots", 95, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151039_o);
        stack.func_77966_a(Enchantment.func_180305_b((String)"efficiency"), 10);
        stack.func_77966_a(Enchantment.func_180305_b((String)"fortune"), 3);
        stack.func_151001_c("Giga Breaker");
        INSTANCE.registerReward(new BasicReward("chancecubes:Giga_Breaker", 70, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Item)Items.field_151031_f);
        stack.func_77964_b(stack.func_77958_k());
        stack.func_77966_a(Enchantment.func_180305_b((String)"power"), 5);
        stack.func_77966_a(Enchantment.func_180305_b((String)"punch"), 3);
        stack.func_77966_a(Enchantment.func_180305_b((String)"flame"), 2);
        INSTANCE.registerReward(new BasicReward("chancecubes:One_Shot", 75, new ItemRewardType(new ItemPart(stack), new ItemPart(new ItemStack(Items.field_151032_g, 1)))));
        stack = new ItemStack(Items.field_151115_aP, 1, 2);
        stack.func_151001_c("Nemo");
        INSTANCE.registerReward(new BasicReward("chancecubes:Finding_Nemo", 10, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151115_aP, 1, 2);
        stack.func_151001_c("Marlin");
        INSTANCE.registerReward(new BasicReward("chancecubes:Finding_Marlin", 10, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151059_bz, 1);
        stack.func_77966_a(Enchantment.func_180305_b((String)"fire_aspect"), 2);
        stack.func_151001_c("Why not?");
        INSTANCE.registerReward(new BasicReward("chancecubes:Fire_Aspect_Fire", 60, new ItemRewardType(new ItemPart(stack))));
        TileEntitySign sign = new TileEntitySign();
        sign.field_145915_a[0] = new TextComponentString("The broken path");
        sign.field_145915_a[1] = new TextComponentString("to succeed");
        nbt = new NBTTagCompound();
        sign.func_189515_b(nbt);
        INSTANCE.registerReward(new BasicReward("chancecubes:Path_To_Succeed", 0, new BlockRewardType(new OffsetBlock[]{new OffsetTileEntity(0, 0, -5, Blocks.field_150472_an, nbt, true, 20), new OffsetBlock(0, -1, 0, Blocks.field_150347_e, true, 0), new OffsetBlock(0, -1, -1, Blocks.field_150347_e, true, 4), new OffsetBlock(0, -1, -2, Blocks.field_150347_e, true, 8), new OffsetBlock(0, -1, -3, Blocks.field_150347_e, true, 12), new OffsetBlock(0, -1, -4, Blocks.field_150347_e, true, 16), new OffsetBlock(0, -1, -5, Blocks.field_150347_e, true, 20)})));
        OffsetTileEntity[] signs = new OffsetTileEntity[4];
        for (int i = 0; i < signs.length; ++i) {
            sign = new TileEntitySign();
            sign.field_145915_a[0] = new TextComponentString("Help Me!");
            nbt = new NBTTagCompound();
            sign.func_189515_b(nbt);
            OffsetTileEntity temp = new OffsetTileEntity(i == 2 ? -2 : (i == 3 ? 2 : 0), 1, i == 0 ? -2 : (i == 1 ? 2 : 0), Blocks.field_150444_as, nbt, false, 5);
            temp.setBlockState(Blocks.field_150444_as.func_176223_P().func_177226_a((IProperty)BlockWallSign.field_176412_a, (Comparable)EnumFacing.func_176731_b((int)(i + 2))));
            signs[i] = temp;
        }
        INSTANCE.registerReward(new BasicReward("chancecubes:Help_Me", -10, new BlockRewardType(RewardsUtil.addBlocksLists(RewardsUtil.fillArea(3, 1, 3, Blocks.field_150417_aV, -1, -1, -1, false, 0, true, false), RewardsUtil.fillArea(3, 3, 3, Blocks.field_150411_aY, -1, 0, -1, false, 0, true, false), RewardsUtil.fillArea(1, 3, 1, Blocks.field_150350_a, 0, 0, 0, false, 1, true, false), signs)), new EntityRewardType(new EntityPart(EntityRewardType.getBasicNBTForEntity("Villager"), 5).setRemovedBlocks(false)), new CommandRewardType(new CommandPart("/summon tnt %x %y %z {Fuse:80}", 5))));
        OffsetBlock[] blocks = new OffsetBlock[35];
        int i = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    if (y == 1 && (x == 0 || x == 4 || z == 0 || z == 4)) continue;
                    blocks[i] = new OffsetBlock(x - 2, y, z - 2, Blocks.field_150339_S, true, i * 5);
                    ++i;
                }
            }
        }
        blocks[i] = new OffsetBlock(0, 2, 0, (Block)Blocks.field_150461_bJ, true, 200);
        INSTANCE.registerReward(new BasicReward("chancecubes:Beacon_Build", 100, new BlockRewardType(blocks)));
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Half_Heart", -30){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                player.func_70606_j(1.0f);
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:No_Exp", -40){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                player.field_71068_ca = 0;
                player.field_71067_cb = 0;
                player.field_71106_cc = 0.0f;
                player.func_145747_a((ITextComponent)new TextComponentString("Rip EXP"));
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Smite", -10){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                world.func_72942_c((Entity)new EntityLightningBolt(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, false));
                player.func_145747_a((ITextComponent)new TextComponentString("Thou has been smitten!"));
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Cookie-splosion", 35){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                for (double xx = 1.0; xx > -1.0; xx -= 0.25) {
                    for (double zz = 1.0; zz > -1.0; zz -= 0.25) {
                        EntityItem cookie = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p(), new ItemStack(Items.field_151106_aX));
                        world.func_72838_d((Entity)cookie);
                        cookie.field_70159_w = xx;
                        cookie.field_70181_x = Math.random();
                        cookie.field_70179_y = zz;
                    }
                }
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Random_Status_Effect", 0){

            @Override
            public void trigger(World world, BlockPos pos, final EntityPlayer player) {
                player.func_145747_a((ITextComponent)new TextComponentString("Selecting random potion effect to apply..."));
                Scheduler.scheduleTask(new Task("Cookie Monster", 30){

                    @Override
                    public void callback() {
                        PotionEffect effect = RewardsUtil.getRandomPotionEffect();
                        player.func_145747_a((ITextComponent)new TextComponentString("You have been given " + I18n.func_74838_a((String)effect.func_76453_d()).trim() + " " + (effect.func_76458_c() + 1) + " for " + effect.func_76459_b() / 20 + " seconds!"));
                        player.func_70690_d(effect);
                    }
                });
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Arrow_Spray", -15){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                for (double xx = 1.0; xx > -1.0; xx -= 0.25) {
                    for (double zz = 1.0; zz > -1.0; zz -= 0.25) {
                        EntityTippedArrow arrow = new EntityTippedArrow(world);
                        arrow.func_70012_b((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 0.5f), (double)pos.func_177952_p(), 0.0f, 0.0f);
                        arrow.field_70159_w = xx;
                        arrow.field_70181_x = 0.3;
                        arrow.field_70179_y = zz;
                        world.func_72838_d((Entity)arrow);
                    }
                }
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Lingering_Potions_Ring", -10){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                for (double rad = -Math.PI; rad <= Math.PI; rad += 0.3141592653589793) {
                    PotionType potionType = (PotionType)PotionType.field_185176_a.func_148754_a(RewardsUtil.rand.nextInt(PotionType.field_185176_a.func_148742_b().size()));
                    EntityPotion pot = new EntityPotion(world, (EntityLivingBase)player, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)potionType));
                    pot.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                    pot.field_70159_w = Math.cos(rad) * 0.25;
                    pot.field_70181_x = 1.0;
                    pot.field_70179_y = Math.sin(rad) * 0.25;
                    world.func_72838_d((Entity)pot);
                }
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Charged_Creeper", -40){

            @Override
            public void trigger(final World world, final BlockPos pos, EntityPlayer player) {
                RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, pos.func_177982_a(0, 1, 0));
                final EntityCreeper ent = new EntityCreeper(world);
                ent.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                ent.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, 99, true, false));
                ent.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 300, 99, true, false));
                world.func_72838_d((Entity)ent);
                Scheduler.scheduleTask(new Task("Charged Creeper Reward", 2){

                    @Override
                    public void callback() {
                        world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false));
                        ent.func_70015_d(0);
                    }
                });
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Disco", 40){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                for (int xx = -4; xx < 5; ++xx) {
                    for (int zz = -4; zz < 5; ++zz) {
                        RewardsUtil.placeBlock(Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.func_176764_b((int)RewardsUtil.rand.nextInt(16))), world, pos.func_177982_a(xx, -1, zz));
                    }
                }
                for (int i = 0; i < 10; ++i) {
                    EntitySheep sheep = new EntitySheep(world);
                    sheep.func_96094_a("jeb_");
                    sheep.func_70012_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.0f, 0.0f);
                    world.func_72838_d((Entity)sheep);
                }
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_ICOSAHEDRON.func_176223_P(), world, pos.func_177982_a(0, 3, 0));
                RewardsUtil.sendMessageToNearPlayers(world, pos, 32, "Disco Party!!!!");
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Ender_Crystal_Timer", -90){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                for (int i = 30; i > 0; --i) {
                    RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, pos.func_177982_a(0, i, 0));
                }
                EntityEnderCrystal ent = new EntityEnderCrystal(world);
                ent.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)ent);
                EntityTippedArrow arrow = new EntityTippedArrow(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 29), (double)pos.func_177952_p() + 0.5);
                arrow.field_70159_w = 0.0;
                arrow.field_70181_x = -0.25;
                arrow.field_70179_y = 0.0;
                world.func_72838_d((Entity)arrow);
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:5_Prongs", -10){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                for (int xx = pos.func_177958_n() - 3; xx <= pos.func_177958_n() + 3; ++xx) {
                    for (int zz = pos.func_177952_p() - 3; zz <= pos.func_177952_p() + 3; ++zz) {
                        for (int yy = pos.func_177956_o(); yy <= pos.func_177956_o() + 4; ++yy) {
                            RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, new BlockPos(xx, yy, zz));
                        }
                    }
                }
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos);
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos.func_177982_a(0, 1, 0));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_ICOSAHEDRON.func_176223_P(), world, pos.func_177982_a(0, 2, 0));
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos.func_177982_a(-3, 0, -3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.func_176223_P(), world, pos.func_177982_a(-3, 1, -3));
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos.func_177982_a(-3, 0, 3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.func_176223_P(), world, pos.func_177982_a(-3, 1, 3));
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos.func_177982_a(3, 0, -3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.func_176223_P(), world, pos.func_177982_a(3, 1, -3));
                RewardsUtil.placeBlock(Blocks.field_150371_ca.func_176223_P(), world, pos.func_177982_a(3, 0, 3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.func_176223_P(), world, pos.func_177982_a(3, 1, 3));
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Inventory_Bomb", -55){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                int i;
                player.field_71071_by.func_70436_m();
                for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    player.field_71071_by.field_70462_a.set(i, (Object)new ItemStack((Block)Blocks.field_150330_I, 64));
                }
                for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
                    ItemStack stack = new ItemStack((Block)Blocks.field_150330_I, 64);
                    if (i == 0) {
                        stack.func_151001_c("ButtonBoy");
                        stack.func_190920_e(13);
                    } else if (i == 1) {
                        stack.func_151001_c("TheBlackswordsman");
                        stack.func_190920_e(13);
                    }
                    player.field_71071_by.field_70460_b.set(i, (Object)stack);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Inventory Bomb!!!!"));
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Nuke", -75){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                RewardsUtil.sendMessageToNearPlayers(world, pos, 32, "May death rain upon them");
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 6), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 6), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 6), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 6), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 2), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 2), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 2), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() - 2), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 2), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 2), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 2), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 2), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 6), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() - 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 6), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() + 2), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 6), null));
                world.func_72838_d((Entity)new EntityTNTPrimed(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 65), (double)(pos.func_177952_p() + 6), null));
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Random_Teleport", -15){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                int xChange = world.field_73012_v.nextInt(50) + 20 + pos.func_177958_n() - 35;
                int zChange = world.field_73012_v.nextInt(50) + 20 + pos.func_177952_p() - 35;
                int yChange = -1;
                for (int yy = 0; yy <= world.func_72940_L(); ++yy) {
                    if (!world.func_175623_d(new BlockPos(xChange, yy, zChange)) || !world.func_175623_d(new BlockPos(xChange, yy + 1, zChange))) continue;
                    yChange = yy;
                    break;
                }
                if (yChange == -1) {
                    return;
                }
                player.func_70634_a((double)xChange, (double)yChange, (double)zChange);
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Rotten_Food", -30){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFood)) continue;
                    player.field_71071_by.field_70462_a.set(i, (Object)new ItemStack(Items.field_151078_bh, stack.func_190916_E()));
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Ewwww it's all rotten"));
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Thrown_In_Air", -35){

            @Override
            public void trigger(World world, BlockPos pos, final EntityPlayer player) {
                int px = (int)Math.floor(player.field_70165_t);
                int py = (int)Math.floor(player.field_70163_u) + 1;
                int pz = (int)Math.floor(player.field_70161_v);
                for (int y = 0; y < 40; ++y) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, pos.func_177982_a(px + x, py + y, pz + z));
                        }
                    }
                }
                Scheduler.scheduleTask(new Task("Thrown_In_Air_Reward", 5){

                    @Override
                    public void callback() {
                        player.field_70160_al = true;
                        player.field_70181_x = 20.0;
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(player.func_145782_y(), player.field_70159_w, player.field_70181_x, player.field_70179_y));
                    }
                });
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Torches_To_Creepers", -40){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                for (int yy = -32; yy <= 32; ++yy) {
                    for (int xx = -32; xx <= 32; ++xx) {
                        for (int zz = -32; zz <= 32; ++zz) {
                            IBlockState b = world.func_180495_p(pos.func_177982_a(xx, yy, zz));
                            if (b.getLightValue((IBlockAccess)world, pos) <= 0 || b.func_177230_c() == Blocks.field_150353_l || b.func_177230_c().hasTileEntity(b)) continue;
                            RewardsUtil.placeBlock(Blocks.field_150350_a.func_176223_P(), world, pos.func_177982_a(xx, yy, zz));
                            EntityCreeper creeper = new EntityCreeper(world);
                            creeper.func_70012_b((double)(pos.func_177958_n() + xx) + 0.5, (double)(pos.func_177956_o() + yy), (double)(pos.func_177952_p() + zz) + 0.5, 0.0f, 0.0f);
                            world.func_72838_d((Entity)creeper);
                        }
                    }
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Those lights seem a little weird.... O.o"));
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Traveller", 15){

            @Override
            public void trigger(World world, BlockPos pos, EntityPlayer player) {
                int x = RewardsUtil.rand.nextInt(1000) + 200;
                int z = RewardsUtil.rand.nextInt(1000) + 200;
                BlockPos newPos = pos.func_177982_a(x, 0, z);
                RewardsUtil.placeBlock(Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.WEST), world, newPos);
                TileEntityChest chest = (TileEntityChest)world.func_175625_s(newPos);
                for (int i = 0; i < 10; ++i) {
                    chest.func_70299_a(i, new ItemStack(RewardsUtil.getRandomItem()));
                }
                RewardsUtil.sendMessageToNearPlayers(world, pos, 25, "" + newPos.func_177958_n() + ", " + newPos.func_177956_o() + ", " + newPos.func_177952_p());
            }
        });
        INSTANCE.registerReward(new BaseCustomReward("chancecubes:Troll_Hole", -20){

            @Override
            public void trigger(World world, BlockPos pos, final EntityPlayer player) {
                BlockPos worldPos = new BlockPos(Math.floor(player.field_70165_t), Math.floor(player.field_70163_u) - 1.0, Math.floor(player.field_70161_v));
                final RewardBlockCache cache = new RewardBlockCache(world, worldPos, new BlockPos(worldPos.func_177958_n(), worldPos.func_177956_o() + 1, worldPos.func_177952_p()));
                for (int y = 0; y > -75; --y) {
                    for (int x = -2; x < 3; ++x) {
                        for (int z = -2; z < 3; ++z) {
                            cache.cacheBlock(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
                Scheduler.scheduleTask(new Task("TrollHole", 35){

                    @Override
                    public void callback() {
                        cache.restoreBlocks((Entity)player);
                        player.field_70181_x = 0.0;
                        player.field_70143_R = 0.0f;
                    }
                });
            }
        });
        INSTANCE.registerReward(new AnvilRain());
        INSTANCE.registerReward(new HerobrineReward());
        INSTANCE.registerReward(new SurroundedReward());
        INSTANCE.registerReward(new CreeperSurroundedReward());
        INSTANCE.registerReward(new WitherReward());
        INSTANCE.registerReward(new TrollTNTReward());
        INSTANCE.registerReward(new WaitForItReward());
        INSTANCE.registerReward(new ClearInventoryReward());
        INSTANCE.registerReward(new ItemOfDestinyReward());
        INSTANCE.registerReward(new JukeBoxReward());
        INSTANCE.registerReward(new BookOfMemesReward());
        INSTANCE.registerReward(new TableFlipReward());
        INSTANCE.registerReward(new MazeReward());
        INSTANCE.registerReward(new OneIsLuckyReward());
        INSTANCE.registerReward(new SkyblockReward());
        INSTANCE.registerReward(new CakeIsALieReward());
        INSTANCE.registerReward(new ItemRenamer());
        INSTANCE.registerReward(new DoubleRainbow());
        INSTANCE.registerReward(new WolvesToCreepersReward());
        INSTANCE.registerReward(new DidYouKnowReward());
        INSTANCE.registerReward(new ArmorStandArmorReward());
        INSTANCE.registerReward(new RainingCatsAndCogsReward());
        INSTANCE.registerReward(new ItemChestReward());
        INSTANCE.registerReward(new MagicFeetReward());
        INSTANCE.registerReward(new DigBuildReward());
        INSTANCE.registerReward(new ChanceCubeRenameReward());
        INSTANCE.registerReward(new CountDownReward());
        INSTANCE.registerReward(new MobTowerReward());
        INSTANCE.registerReward(new MontyHallReward());
        INSTANCE.registerReward(new MatchingReward());
        INSTANCE.registerReward(new TicTacToeReward());
        INSTANCE.registerReward(new MobEffectsReward());
        MathReward math = new MathReward();
        MinecraftForge.EVENT_BUS.register((Object)math);
        INSTANCE.registerReward(math);
        QuestionsReward question = new QuestionsReward();
        MinecraftForge.EVENT_BUS.register((Object)question);
        INSTANCE.registerReward(question);
        CoinFlipReward coinFlip = new CoinFlipReward();
        MinecraftForge.EVENT_BUS.register((Object)coinFlip);
        INSTANCE.registerReward(coinFlip);
    }

    public static void loadCustomUserRewards(MinecraftServer server) {
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            CustomUserReward.getCustomUserReward(player.func_110124_au());
        }
    }

    @Override
    public void registerReward(IChanceCubeReward reward) {
        this.registerReward(reward, true);
    }

    public void registerReward(IChanceCubeReward reward, boolean enabledDefault) {
        if (ConfigLoader.config.getBoolean(reward.getName(), "Rewards", enabledDefault, "") && !this.nameToReward.containsKey(reward.getName())) {
            this.nameToReward.put(reward.getName(), reward);
            this.redoSort(reward);
        } else {
            this.disabledNameToReward.put(reward.getName(), reward);
        }
    }

    public boolean enableReward(String reward) {
        if (this.disabledNameToReward.containsKey(reward) && this.nameToReward.containsKey(reward)) {
            return this.enableReward(this.nameToReward.get(reward));
        }
        return this.isRewardEnabled(reward);
    }

    public boolean enableReward(IChanceCubeReward reward) {
        this.disabledNameToReward.remove(reward.getName());
        this.redoSort(reward);
        return this.isRewardEnabled(reward.getName());
    }

    public boolean disableReward(String reward) {
        if (!this.disabledNameToReward.containsKey(reward) && this.nameToReward.containsKey(reward)) {
            return this.disableReward(this.nameToReward.get(reward));
        }
        return !this.isRewardEnabled(reward);
    }

    public boolean disableReward(IChanceCubeReward reward) {
        if (reward != null) {
            this.disabledNameToReward.put(reward.getName(), reward);
            return this.sortedRewards.remove(reward);
        }
        return false;
    }

    public boolean isRewardEnabled(String reward) {
        return !this.disabledNameToReward.containsKey(reward);
    }

    @Override
    public boolean unregisterReward(String name) {
        IChanceCubeReward reward = this.nameToReward.get(name);
        if (reward != null) {
            return this.sortedRewards.remove(reward);
        }
        return false;
    }

    public void addCustomReward(IChanceCubeReward reward) {
        this.customRewards.add(reward);
    }

    @Override
    public IChanceCubeReward getRewardByName(String name) {
        return this.nameToReward.get(name);
    }

    public Set<String> getRewardNames() {
        return this.nameToReward.keySet();
    }

    public Set<String> getDisabledRewardNames() {
        return this.disabledNameToReward.keySet();
    }

    @Override
    public void triggerRandomReward(World world, BlockPos pos, EntityPlayer player, int chance) {
        int upperRange;
        if (CCubesSettings.testRewards) {
            IChanceCubeReward pickedReward = this.sortedRewards.get(CCubesSettings.testingRewardIndex);
            pickedReward.trigger(world, pos, player);
            if (++CCubesSettings.testingRewardIndex >= this.sortedRewards.size()) {
                CCubesSettings.testingRewardIndex = 0;
            }
            CCubesCore.logger.log(Level.INFO, "Testing the reward with the name of: " + pickedReward.getName());
            return;
        }
        if (CCubesSettings.testCustomRewards) {
            IChanceCubeReward pickedReward = this.customRewards.get(CCubesSettings.testingRewardIndex);
            pickedReward.trigger(world, pos, player);
            if (++CCubesSettings.testingRewardIndex >= this.customRewards.size()) {
                CCubesSettings.testingRewardIndex = 0;
            }
            CCubesCore.logger.log(Level.INFO, "Testing the reward with the name of: " + pickedReward.getName());
            return;
        }
        if (this.sortedRewards.size() == 0) {
            CCubesCore.logger.log(Level.WARN, "There are no registered rewards with ChanceCubes and no reward was able to be given");
            return;
        }
        if (CCubesSettings.doesHolidayRewardTrigger && CCubesSettings.holidayReward != null) {
            CCubesSettings.holidayReward.trigger(world, pos, player);
            CCubesCore.logger.log(Level.INFO, "The " + CCubesSettings.holidayReward.getName() + " holiday reward has been triggered!!!!");
            CCubesSettings.doesHolidayRewardTrigger = false;
            CCubesSettings.holidayRewardTriggered = true;
            ConfigLoader.config.get("General Settings", "HolidayRewardTriggered", false, "Don't touch! Well I mean you can touch it, if you want. I can't stop you. I'm only text.").setValue(true);
            ConfigLoader.config.save();
            return;
        }
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemChancePendant)) continue;
                ItemChancePendant pendant = (ItemChancePendant)stack.func_77973_b();
                pendant.damage(stack);
                if (stack.func_77952_i() >= CCubesSettings.pendantUses) {
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
                if ((chance += pendant.getChanceIncrease()) <= 100) break;
                chance = 100;
                break;
            }
        }
        int lowerIndex = 0;
        int upperIndex = this.sortedRewards.size() - 1;
        int lowerRange = chance - CCubesSettings.rangeMin < -100 ? -100 : chance - CCubesSettings.rangeMin;
        int n = upperRange = chance + CCubesSettings.rangeMax > 100 ? 100 : chance + CCubesSettings.rangeMax;
        while (this.sortedRewards.get(lowerIndex).getChanceValue() < lowerRange) {
            if (++lowerIndex < this.sortedRewards.size()) continue;
            --lowerIndex;
            break;
        }
        while (this.sortedRewards.get(upperIndex).getChanceValue() > upperRange) {
            if (--upperIndex >= 0) continue;
            ++upperIndex;
            break;
        }
        int range = upperIndex - lowerIndex > 0 ? upperIndex - lowerIndex : 1;
        int pick = RewardsUtil.rand.nextInt(range) + lowerIndex;
        IChanceCubeReward pickedReward = this.sortedRewards.get(pick);
        if (lastReward != null || cooldownList.contains(pickedReward)) {
            for (int atempts = 0; atempts < 5 && cooldownList.contains(pickedReward); atempts = (int)((byte)(atempts + 1))) {
                pick = RewardsUtil.rand.nextInt(range) + lowerIndex;
                pickedReward = this.sortedRewards.get(pick);
            }
        }
        CCubesCore.logger.log(Level.INFO, "Triggered the reward with the name of: " + pickedReward.getName());
        pickedReward.trigger(world, pos, player);
        lastReward = pickedReward;
        cooldownList.add(lastReward);
        if (cooldownList.size() > 15) {
            cooldownList.remove(0);
        }
    }

    private void redoSort(@Nullable IChanceCubeReward newReward) {
        if (newReward != null) {
            this.sortedRewards.add(newReward);
        }
        Collections.sort(this.sortedRewards, new Comparator<IChanceCubeReward>(){

            @Override
            public int compare(IChanceCubeReward o1, IChanceCubeReward o2) {
                return o1.getChanceValue() - o2.getChanceValue();
            }
        });
    }

    public int getNumberOfLoadedRewards() {
        return this.sortedRewards.size();
    }

    public int getNumberOfDisabledRewards() {
        return this.disabledNameToReward.size();
    }

    public void ClearRewards() {
        this.sortedRewards.clear();
        this.nameToReward.clear();
        this.disabledNameToReward.clear();
    }
}

