/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.profiles;

import chanceCubes.CCubesCore;
import chanceCubes.profiles.IProfile;
import chanceCubes.profiles.ProfileManager;
import chanceCubes.profiles.triggers.ITrigger;
import chanceCubes.registry.ChanceCubeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class BasicProfile
implements IProfile {
    private String id;
    private String name;
    private String desc;
    private StringBuilder descFull = new StringBuilder();
    private List<ITrigger<?>> triggers = new ArrayList();
    private List<String> rewardsToEnable = new ArrayList<String>();
    private List<String> rewardsToDisable = new ArrayList<String>();
    private List<IProfile> subProfiles = new ArrayList<IProfile>();
    private Map<String, Integer> chanceChanges = new HashMap<String, Integer>();

    public BasicProfile(String id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public BasicProfile addEnabledRewards(String ... rewards) {
        this.rewardsToEnable.addAll(Arrays.asList(rewards));
        return this;
    }

    public BasicProfile addDisabledRewards(String ... rewards) {
        this.rewardsToDisable.addAll(Arrays.asList(rewards));
        return this;
    }

    public BasicProfile addTriggers(ITrigger<?> ... triggers) {
        this.triggers.addAll(Arrays.asList(triggers));
        return this;
    }

    public BasicProfile addSubProfile(IProfile ... profiles) {
        this.subProfiles.addAll(Arrays.asList(profiles));
        return this;
    }

    public BasicProfile addRewardChanceChange(String rewardName, int newChance) {
        this.chanceChanges.put(rewardName, newChance);
        return this;
    }

    @Override
    public void onEnable() {
        for (String string : this.rewardsToDisable) {
            if (ChanceCubeRegistry.INSTANCE.disableReward(string)) continue;
            CCubesCore.logger.log(Level.ERROR, this.name + " failed to disable reward " + string);
        }
        for (String string : this.rewardsToEnable) {
            if (ChanceCubeRegistry.INSTANCE.enableReward(string)) continue;
            CCubesCore.logger.log(Level.ERROR, this.name + " failed to enable reward " + string);
        }
        for (IProfile iProfile : this.subProfiles) {
            iProfile.onEnable();
        }
        for (Map.Entry entry : this.chanceChanges.entrySet()) {
            ProfileManager.setRewardChanceValue((String)entry.getKey(), (Integer)entry.getValue());
        }
    }

    @Override
    public void onDisable() {
        for (String string : this.rewardsToDisable) {
            if (ChanceCubeRegistry.INSTANCE.enableReward(string)) continue;
            CCubesCore.logger.log(Level.ERROR, this.name + " failed to enable reward " + string);
        }
        for (String string : this.rewardsToEnable) {
            if (ChanceCubeRegistry.INSTANCE.disableReward(string)) continue;
            CCubesCore.logger.log(Level.ERROR, this.name + " failed to disable reward " + string);
        }
        for (IProfile iProfile : this.subProfiles) {
            iProfile.onDisable();
        }
        for (Map.Entry entry : this.chanceChanges.entrySet()) {
            ProfileManager.resetRewardChanceValue((String)entry.getKey(), (Integer)entry.getValue());
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public List<String> getRewardsToEnable() {
        return this.rewardsToEnable;
    }

    public List<String> getRewardsToDisable() {
        return this.rewardsToDisable;
    }

    public List<String> getChanceValueChanges() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Map.Entry<String, Integer> change : this.chanceChanges.entrySet()) {
            toReturn.add(change.getKey() + " -> " + change.getValue());
        }
        return toReturn;
    }

    public List<IProfile> getSubProfiles() {
        return this.subProfiles;
    }

    @Override
    public String getDescLong() {
        if (this.descFull.length() == 0 && !this.desc.isEmpty()) {
            this.descFull.append(this.desc);
            this.descFull.append("\n");
            this.descFull.append("=== Rewards Enabled ===");
            this.descFull.append("\n");
            if (this.rewardsToEnable.size() == 0) {
                this.descFull.append("None\n");
            }
            for (String string : this.rewardsToEnable) {
                this.descFull.append(string);
                this.descFull.append("\n");
            }
            this.descFull.append("=== Rewards Disabled ===");
            this.descFull.append("\n");
            if (this.rewardsToDisable.size() == 0) {
                this.descFull.append("None\n");
            }
            for (String string : this.rewardsToDisable) {
                this.descFull.append(string);
                this.descFull.append("\n");
            }
            this.descFull.append("=== Triggers ===");
            this.descFull.append("\n");
            if (this.triggers.size() == 0) {
                this.descFull.append("None\n");
            }
            for (ITrigger iTrigger : this.triggers) {
                this.descFull.append(iTrigger.getTriggerDesc());
                this.descFull.append("\n");
            }
            this.descFull.append("=== Reward Chance Value Changes ===");
            this.descFull.append("\n");
            if (this.chanceChanges.size() == 0) {
                this.descFull.append("None\n");
            }
            for (Map.Entry entry : this.chanceChanges.entrySet()) {
                this.descFull.append((String)entry.getKey() + " -> " + entry.getValue());
                this.descFull.append("\n");
            }
            this.descFull.append("=== Sub Profiles ===");
            this.descFull.append("\n");
            if (this.subProfiles.size() == 0) {
                this.descFull.append("None\n");
            }
            for (IProfile iProfile : this.subProfiles) {
                this.descFull.append(iProfile.getName() + " (" + iProfile.getID() + ")");
                this.descFull.append("\n");
            }
        }
        return this.descFull.toString();
    }

    @Override
    public List<ITrigger<?>> getTriggers() {
        return this.triggers;
    }
}

