/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.items;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.profiles.ProfileManager;
import chanceCubes.tileentities.TileChanceCube;
import chanceCubes.tileentities.TileChanceD20;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemChanceCube
extends ItemBlock {
    public ItemChanceCube(Block b) {
        super(b);
    }

    public void setChance(ItemStack stack, int chance) {
        NBTTagCompound nbt;
        if (chance > 100 || chance < -101) {
            chance = -101;
        }
        if ((nbt = stack.func_77978_p()) == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74768_a("Chance", chance);
        stack.func_77982_d(nbt);
    }

    public int getChance(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return -101;
        }
        return stack.func_77978_p().func_74764_b("Chance") ? stack.func_77978_p().func_74762_e("Chance") : -101;
    }

    public String getChanceAsStringValue(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return "Random";
        }
        return stack.func_77978_p().func_74764_b("Chance") ? (stack.func_77978_p().func_74762_e("Chance") == -101 ? "Random" : "" + stack.func_77978_p().func_74762_e("Chance")) : "Random";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        Item item = stack.func_77973_b();
        if (!item.equals(Item.func_150898_a((Block)CCubesBlocks.CUBE_DISPENSER))) {
            String chance = this.getChanceAsStringValue(stack);
            list.add("Chance Value: " + chance);
        }
        if (item.equals(Item.func_150898_a((Block)CCubesBlocks.COMPACT_GIANT_CUBE))) {
            list.add("WARNING: The Giant Chance Cube will probably cause lots damage and/or place a lot of blocks down... You've been warned.");
        } else if (item.equals(Item.func_150898_a((Block)CCubesBlocks.CHANCE_CUBE))) {
            list.add("Warning: It is recommended you don't open these in or next toy your base.");
        }
        if (item.equals(Item.func_150898_a((Block)CCubesBlocks.CHANCE_CUBE)) || item.equals(Item.func_150898_a((Block)CCubesBlocks.CHANCE_ICOSAHEDRON))) {
            list.add("==== Enabled Profiles ====");
            for (String profile : ProfileManager.getEnabledProfileNames()) {
                list.add(profile);
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, IBlockState blockState) {
        int chance;
        boolean placed = super.placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, blockState);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && (chance = this.getChance(stack)) != -101) {
            if (te instanceof TileChanceCube) {
                ((TileChanceCube)te).setChance(chance);
            } else if (te instanceof TileChanceD20) {
                ((TileChanceD20)te).setChance(chance);
            }
        }
        return placed;
    }
}

