/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.config;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.variableParts.ListPart;
import chanceCubes.rewards.variableParts.StringPart;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.FloatVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.rewards.variableTypes.NBTVar;
import chanceCubes.rewards.variableTypes.StringVar;
import java.io.File;
import java.util.Arrays;
import org.apache.logging.log4j.Level;

public class BaseLoader {
    protected String currentParsingReward = "";
    protected String currentParsingPart = "";
    protected int lineNumber = 0;
    protected File folder;

    public IntVar getInt(String input, int defaultVal) {
        String[] parts;
        IntVar var = new IntVar();
        for (String part : parts = input.split("%%")) {
            if (part.isEmpty()) continue;
            if (part.startsWith("RND")) {
                var.addPart(IntVar.parseRandom(part));
                continue;
            }
            if (part.charAt(0) == '[' && part.indexOf(93) != -1) {
                var.addPart(new ListPart(Arrays.stream(part.replaceAll(" ", "").substring(1, part.lastIndexOf(93)).split(",")).mapToInt(Integer::parseInt).boxed().toArray(Integer[]::new)));
                continue;
            }
            if (IntVar.isInteger(part)) {
                var.addPart(new StringPart(part));
                continue;
            }
            CCubesCore.logger.log(Level.ERROR, "An integer was expected, but " + part + " was recieved for the " + this.currentParsingPart + " reward part in the \"" + this.currentParsingReward + "\" reward.");
            CCubesCore.logger.log(Level.ERROR, "If " + part + " was not what you entered than this may be an issue with the mod and please report to the mod author!");
        }
        if (var.isEmpty()) {
            var.addPart(new StringPart(defaultVal));
        }
        return var;
    }

    public FloatVar getFloat(String input, float defaultVal) {
        String[] parts;
        FloatVar var = new FloatVar();
        for (String part : parts = input.split("%%")) {
            if (part.isEmpty()) continue;
            if (part.startsWith("RND")) {
                var.addPart(FloatVar.parseRandom(part));
            } else if (part.charAt(0) == '[' && part.indexOf(93) != -1) {
                var.addPart(new ListPart(Arrays.stream(part.replaceAll(" ", "").substring(1, part.lastIndexOf(93)).split(",")).map(Float::parseFloat).toArray(Float[]::new)));
            }
            if (FloatVar.isFloat(part)) {
                var.addPart(new StringPart(part));
                continue;
            }
            CCubesCore.logger.log(Level.ERROR, "An float was expected, but " + part + " was recieved for the " + this.currentParsingPart + " reward part in the \"" + this.currentParsingReward + "\" reward.");
            CCubesCore.logger.log(Level.ERROR, "If " + part + " was not what you entered than this may be an issue with the mod and please report to the mod author!");
        }
        if (var.isEmpty()) {
            var.addPart(new StringPart(defaultVal));
        }
        return var;
    }

    public BoolVar getBoolean(String input, boolean defaultVal) {
        String[] parts;
        BoolVar var = new BoolVar();
        for (String part : parts = input.split("%%")) {
            if (part.isEmpty()) continue;
            if (part.startsWith("RND")) {
                var.addPart(BoolVar.parseRandom(part));
                continue;
            }
            if (part.charAt(0) == '[' && part.indexOf(93) != -1) {
                var.addPart(new ListPart(Arrays.stream(part.replaceAll(" ", "").substring(1, part.lastIndexOf(93)).split(",")).map(Boolean::parseBoolean).toArray(Boolean[]::new)));
                continue;
            }
            var.addPart(new StringPart(part));
        }
        if (var.isEmpty()) {
            var.addPart(new StringPart(defaultVal));
        }
        return var;
    }

    public StringVar getString(String input, String defaultVal) {
        String[] parts;
        StringVar var = new StringVar();
        for (String part : parts = input.split("%%")) {
            if (part.isEmpty()) continue;
            if (part.startsWith("RND")) {
                var.addPart(IntVar.parseRandom(part));
                continue;
            }
            if (part.charAt(0) == '[' && part.indexOf(93) != -1) {
                var.addPart(new ListPart<String>(part.replaceAll(" ", "").substring(1, part.lastIndexOf(93) - 1).split(",")));
                continue;
            }
            var.addPart(new StringPart(part));
        }
        if (var.isEmpty()) {
            var.addPart(new StringPart(defaultVal));
        }
        return var;
    }

    public NBTVar getNBT(String input) {
        String[] parts;
        NBTVar var = new NBTVar();
        for (String part : parts = input.split("%%")) {
            if (part.isEmpty()) continue;
            if (part.startsWith("RND")) {
                var.addPart(IntVar.parseRandom(part));
                continue;
            }
            if (part.charAt(0) == '[' && part.indexOf(93) != -1) {
                var.addPart(new ListPart<String>(part.replaceAll(" ", "").substring(1, part.lastIndexOf(93)).split(",")));
                continue;
            }
            var.addPart(new StringPart(part));
        }
        if (var.isEmpty()) {
            var.addPart(new StringPart(""));
        }
        return var;
    }
}

