/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.item;

import com.latmod.mods.tesslocator.block.BlockTesslocator;
import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.EnumPartType;
import com.latmod.mods.tesslocator.block.part.TesslocatorPart;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTesslocator
extends Item {
    public final EnumPartType type;
    public boolean disabled;

    public ItemTesslocator(EnumPartType t) {
        this.type = t;
        this.disabled = false;
    }

    public ItemTesslocator setDisabled() {
        this.disabled = true;
        return this;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.disabled) {
            return EnumActionResult.SUCCESS;
        }
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (player.func_175151_a(pos, facing, stack) && (tileEntity instanceof TileTesslocator || world.func_190527_a(world.func_180495_p(pos).func_177230_c(), pos, false, facing, null))) {
            if (!(tileEntity instanceof TileTesslocator)) {
                world.func_180501_a(pos, BlockTesslocator.INSTANCE.func_176223_P(), 11);
                tileEntity = world.func_175625_s(pos);
            }
            if (tileEntity instanceof TileTesslocator) {
                TesslocatorPart part;
                TileTesslocator tile = (TileTesslocator)tileEntity;
                EnumFacing opposite = facing.func_176734_d();
                if (tile.parts[opposite.func_176745_a()] != null) {
                    return EnumActionResult.FAIL;
                }
                tile.parts[opposite.func_176745_a()] = part = this.type.provider.createPart(tile, opposite);
                part.onPlaced(player, stack);
                tileEntity.func_70296_d();
            }
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 11);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
            SoundType soundtype = state.func_177230_c().getSoundType(state, world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.disabled) {
            tooltip.add(TextFormatting.RED + "Currently disabled, because it's not finished!");
        }
        if (this.type.isAdvanced) {
            int col = stack.func_77942_o() ? stack.func_77978_p().func_74771_c("colors") & 0xFF : 0;
            tooltip.add("Color A: " + I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)(col & 0xF)).func_176762_d()), (Object[])new Object[0]));
            tooltip.add("Color B: " + I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)(col >> 4 & 0xF)).func_176762_d()), (Object[])new Object[0]));
            tooltip.add("");
            tooltip.add(TextFormatting.DARK_GRAY + "Change colors by holding dye in each hand and right-clicking on block");
        }
    }
}

