/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.data;

import com.latmod.mods.tesslocator.data.TessNet;
import com.latmod.mods.tesslocator.data.TessNetKey;
import com.latmod.mods.tesslocator.data.TesslocatorData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyData
extends TesslocatorData
implements IEnergyStorage {
    public int energy = 0;

    public EnergyData(TessNet n, TessNetKey k) {
        super(n, k);
    }

    @Override
    public void write(NBTTagCompound nbt) {
        nbt.func_74768_a("energy", this.energy);
    }

    @Override
    public void read(NBTTagCompound nbt) {
        this.energy = nbt.func_74762_e("energy");
    }

    @Override
    public boolean shouldSave() {
        return this.energy > 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.energy, maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
            this.net.markDirty();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
            this.net.markDirty();
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return 2048000000;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

