/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.block.part;

import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.BasicTesslocatorPart;
import com.latmod.mods.tesslocator.block.part.EnumPartType;
import com.latmod.mods.tesslocator.block.part.TesslocatorPart;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BasicEnergyTesslocatorPart
extends BasicTesslocatorPart
implements IEnergyStorage {
    private final BasicEnergyTesslocatorPart[] temp = new BasicEnergyTesslocatorPart[5];
    public int energy = 0;

    public BasicEnergyTesslocatorPart(TileTesslocator t, EnumFacing f) {
        super(t, f);
    }

    @Override
    public EnumPartType getType() {
        return EnumPartType.BASIC_ENERGY;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.energy > 0) {
            nbt.func_74768_a("energy", this.energy);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.energy = nbt.func_74762_e("energy");
    }

    @Override
    public boolean hasCapability(Capability<?> capability) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability) {
        return (T)(capability == CapabilityEnergy.ENERGY ? this : null);
    }

    public void func_73660_a() {
        if (this.energy <= 0) {
            return;
        }
        if (this.mode == 0) {
            int e;
            IEnergyStorage outHandler;
            TileEntity outEntity = this.block.func_145831_w().func_175625_s(this.block.func_174877_v().func_177972_a(this.facing));
            if (outEntity != null && (outHandler = (IEnergyStorage)outEntity.getCapability(CapabilityEnergy.ENERGY, this.facing.func_176734_d())) != null && outHandler.canReceive() && (e = outHandler.receiveEnergy(this.energy, false)) > 0) {
                this.energy -= e;
                this.block.func_70296_d();
            }
            return;
        }
        int tempParts = 0;
        for (TesslocatorPart part : this.block.parts) {
            if (part == this || !(part instanceof BasicEnergyTesslocatorPart)) continue;
            BasicEnergyTesslocatorPart part1 = (BasicEnergyTesslocatorPart)part;
            if (part1.mode == 1) continue;
            this.temp[tempParts] = part1;
            ++tempParts;
        }
        if (tempParts == 0) {
            return;
        }
        int p = Math.min(this.energy / tempParts, 256);
        if (p > 0) {
            int e = this.energy;
            for (int i = 0; i < tempParts; ++i) {
                this.energy -= this.temp[i].receiveEnergy(p, false);
            }
            if (this.energy != e) {
                this.block.func_70296_d();
            }
        }
    }

    @Override
    public void onRightClick(EntityPlayer player, EnumHand hand) {
        this.mode = 1 - this.mode;
        this.block.func_70296_d();
        this.block.rerender();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.energy, Math.min(256, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            this.block.func_70296_d();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(256, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            this.block.func_70296_d();
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return 32000;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

