/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator.block;

import com.latmod.mods.tesslocator.block.part.EnumPartType;
import com.latmod.mods.tesslocator.block.part.TesslocatorPart;
import com.latmod.mods.tesslocator.data.TessNet;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileTesslocator
extends TileEntity
implements ITickable {
    private boolean isDirty = false;
    public final TesslocatorPart[] parts = new TesslocatorPart[6];

    public void writeData(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (TesslocatorPart part : this.parts) {
            if (part == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            part.writeData(nbt1);
            nbt1.func_74774_a("side", (byte)part.facing.func_176745_a());
            nbt1.func_74778_a("type", part.getType().id);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("parts", (NBTBase)list);
    }

    public void readData(NBTTagCompound nbt) {
        Arrays.fill(this.parts, null);
        NBTTagList list = nbt.func_150295_c("parts", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            EnumPartType type;
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte s = nbt1.func_74771_c("side");
            if (s < 0 || s >= 6 || (type = EnumPartType.byID(nbt1.func_74779_i("type"))) == null) continue;
            this.parts[s] = type.provider.createPart(this, EnumFacing.field_82609_l[s]);
            this.parts[s].readData(nbt1);
            this.parts[s].clearCache();
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return facing != null && this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.parts[facing.func_176745_a()] != null && this.parts[facing.func_176745_a()].hasCapability(capability) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        Object object = this.field_145850_b != null && !this.field_145850_b.field_72995_K && facing != null && this.parts[facing.func_176745_a()] != null ? this.parts[facing.func_176745_a()].getCapability(capability) : null;
        return (T)(object != null ? object : super.getCapability(capability, facing));
    }

    public void func_145836_u() {
        super.func_145836_u();
        for (TesslocatorPart part : this.parts) {
            if (part == null) continue;
            part.clearCache();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        this.writeData(nbt);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readData(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeData(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readData(packet.func_148857_g());
        this.rerender();
    }

    public void func_70296_d() {
        this.isDirty = true;
    }

    public void func_73660_a() {
        int p = 0;
        for (TesslocatorPart part : this.parts) {
            if (part == null) continue;
            ++p;
            if (this.field_145850_b.field_72995_K || TessNet.SERVER == null) continue;
            part.func_73660_a();
        }
        if (p == 0) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        if (this.isDirty) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            this.isDirty = false;
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void rerender() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 11);
    }
}

