/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.tesslocator;

import com.latmod.mods.tesslocator.block.BlockTesslocator;
import com.latmod.mods.tesslocator.block.TileTesslocator;
import com.latmod.mods.tesslocator.block.part.EnumPartType;
import com.latmod.mods.tesslocator.data.TessNet;
import com.latmod.mods.tesslocator.item.AdvancedTesslocatorColorRecipe;
import com.latmod.mods.tesslocator.item.ItemTesslocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="tesslocator")
public class TesslocatorEventHandler {
    private static Item withName(Item item, String id) {
        item.func_77637_a(CreativeTabs.field_78028_d);
        item.func_77655_b("tesslocator." + id);
        item.setRegistryName(id);
        return item;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register(new BlockTesslocator().setRegistryName("tesslocator"));
        GameRegistry.registerTileEntity(TileTesslocator.class, (ResourceLocation)new ResourceLocation("tesslocator", "tesslocator"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        r.register((IForgeRegistryEntry)TesslocatorEventHandler.withName(new ItemTesslocator(EnumPartType.BASIC_ITEM), "basic_item_tesslocator"));
        r.register((IForgeRegistryEntry)TesslocatorEventHandler.withName(new ItemTesslocator(EnumPartType.BASIC_FLUID).setDisabled(), "basic_fluid_tesslocator"));
        r.register((IForgeRegistryEntry)TesslocatorEventHandler.withName(new ItemTesslocator(EnumPartType.BASIC_ENERGY), "basic_energy_tesslocator"));
        r.register((IForgeRegistryEntry)TesslocatorEventHandler.withName(new ItemTesslocator(EnumPartType.ADVANCED_ITEM).setDisabled(), "advanced_item_tesslocator"));
        r.register((IForgeRegistryEntry)TesslocatorEventHandler.withName(new ItemTesslocator(EnumPartType.ADVANCED_FLUID).setDisabled(), "advanced_fluid_tesslocator"));
        r.register((IForgeRegistryEntry)TesslocatorEventHandler.withName(new ItemTesslocator(EnumPartType.ADVANCED_ENERGY), "advanced_energy_tesslocator"));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register(new AdvancedTesslocatorColorRecipe().setRegistryName("advanced_tesslocator_color"));
    }

    @SubscribeEvent
    public static void worldLoaded(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            TessNet.SERVER = new TessNet();
            File file = new File(event.getWorld().func_72860_G().func_75765_b(), "data/tesslocators.nbt");
            if (file.exists()) {
                try {
                    TessNet.SERVER.read(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void worldUnloaded(WorldEvent.Unload event) {
        if (TessNet.SERVER != null && !event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            TessNet.SERVER = null;
        }
    }

    @SubscribeEvent
    public static void worldSaved(WorldEvent.Save event) {
        if (TessNet.SERVER != null && TessNet.SERVER.isDirty && !event.getWorld().field_72995_K) {
            try {
                File file = new File(event.getWorld().func_72860_G().func_75765_b(), "data/tesslocators.nbt");
                if (!file.exists() && !file.createNewFile()) {
                    return;
                }
                NBTTagCompound nbt = new NBTTagCompound();
                TessNet.SERVER.write(nbt);
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)new FileOutputStream(file));
                TessNet.SERVER.isDirty = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

