/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.core.modules;

import T145.metalchests.api.BlocksMC;
import T145.metalchests.api.chests.IMetalChest;
import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.api.immutable.ModSupport;
import T145.metalchests.blocks.BlockSortingMetalChest;
import T145.metalchests.client.render.blocks.RenderSortingMetalChest;
import T145.metalchests.core.ModLoader;
import T145.metalchests.tiles.TileHungryMetalChest;
import T145.metalchests.tiles.TileMetalChest;
import T145.metalchests.tiles.TileSortingHungryMetalChest;
import T145.metalchests.tiles.TileSortingMetalChest;
import net.blay09.mods.refinedrelocation.item.ItemSortingUpgrade;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;

public class ModuleRefinedRelocation {

    @Mod.EventBusSubscriber(modid="metalchests", value={Side.CLIENT})
    static class ClientLoader {
        ClientLoader() {
        }

        @Optional.Method(modid="refinedrelocation")
        @SubscribeEvent
        public static void onModelRegistration(ModelRegistryEvent event) {
            if (ModSupport.hasRefinedRelocation()) {
                for (ChestType type : ChestType.values()) {
                    ModLoader.registerModel(BlocksMC.SORTING_METAL_CHEST, type.ordinal(), ModLoader.getVariantName(type));
                }
                ModLoader.registerTileRenderer(TileSortingMetalChest.class, (TileEntitySpecialRenderer)new RenderSortingMetalChest());
                if (ModSupport.hasThaumcraft()) {
                    for (ChestType type : ChestType.values()) {
                        ModLoader.registerModel(BlocksMC.SORTING_HUNGRY_METAL_CHEST, type.ordinal(), ModLoader.getVariantName(type));
                    }
                    ModLoader.registerTileRenderer(TileSortingHungryMetalChest.class, (TileEntitySpecialRenderer)new RenderSortingMetalChest(BlocksMC.SORTING_HUNGRY_METAL_CHEST){

                        @Override
                        protected ResourceLocation getActiveResource(ChestType type) {
                            return new ResourceLocation("metalchests", "textures/entity/chest/hungry/" + type.func_176610_l() + ".png");
                        }

                        @Override
                        protected ResourceLocation getActiveOverlay(ChestType type) {
                            return new ResourceLocation("metalchests", "textures/entity/chest/hungry/overlay/" + type.func_176610_l() + ".png");
                        }
                    });
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="metalchests")
    static class ServerLoader {
        ServerLoader() {
        }

        @Optional.Method(modid="refinedrelocation")
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            if (ModSupport.hasRefinedRelocation()) {
                IForgeRegistry registry = event.getRegistry();
                BlocksMC.SORTING_METAL_CHEST = new BlockSortingMetalChest();
                registry.register((IForgeRegistryEntry)BlocksMC.SORTING_METAL_CHEST);
                ModLoader.registerTileEntity(TileSortingMetalChest.class);
            }
        }

        @Optional.Method(modid="refinedrelocation")
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            if (ModSupport.hasRefinedRelocation()) {
                IForgeRegistry registry = event.getRegistry();
                ModLoader.registerItemBlock((IForgeRegistry<Item>)registry, BlocksMC.SORTING_METAL_CHEST, ChestType.class);
            }
        }

        @Optional.Method(modid="refinedrelocation")
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            if (ModSupport.hasRefinedRelocation()) {
                for (ChestType type : ChestType.values()) {
                    if (!type.isRegistered()) continue;
                    OreDictionary.registerOre((String)("chestSorting" + WordUtils.capitalize((String)type.func_176610_l())), (ItemStack)new ItemStack(BlocksMC.SORTING_METAL_CHEST, 1, type.ordinal()));
                }
            }
        }

        @Optional.Method(modid="refinedrelocation")
        @SubscribeEvent
        public static void processInitialInteract(PlayerInteractEvent event) {
            BlockPos pos;
            World world;
            TileEntity te;
            if (event.getWorld().field_72995_K) {
                return;
            }
            ItemStack stack = event.getItemStack();
            if (stack.func_77973_b() instanceof ItemSortingUpgrade && (te = (world = event.getWorld()).func_175625_s(pos = event.getPos())) instanceof TileMetalChest) {
                TileSortingMetalChest newChest;
                Block block;
                TileMetalChest oldChest = (TileMetalChest)te;
                if (te instanceof TileHungryMetalChest) {
                    block = BlocksMC.SORTING_HUNGRY_METAL_CHEST;
                    newChest = new TileSortingHungryMetalChest(oldChest.getChestType());
                } else {
                    block = BlocksMC.SORTING_METAL_CHEST;
                    newChest = new TileSortingMetalChest(oldChest.getChestType());
                }
                te.func_145836_u();
                world.func_175713_t(pos);
                world.func_175698_g(pos);
                world.func_175690_a(pos, (TileEntity)newChest);
                IBlockState state = block.func_176223_P().func_177226_a(IMetalChest.VARIANT, (Comparable)((Object)newChest.getChestType()));
                world.func_180501_a(pos, state, 3);
                world.func_184138_a(pos, state, state, 3);
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileMetalChest) {
                    TileMetalChest chest = (TileMetalChest)tile;
                    chest.setInventory(oldChest.getInventory());
                    chest.setFront(oldChest.getFront());
                }
            }
        }
    }
}

