/*
 * Decompiled with CFR 0.152.
 */
package T145.metalchests.core.modules;

import T145.metalchests.api.BlocksMC;
import T145.metalchests.api.immutable.ChestType;
import T145.metalchests.api.immutable.ModSupport;
import cubex2.mods.chesttransporter.api.TransportableChest;
import cubex2.mods.chesttransporter.chests.TransportableChestImpl;
import cubex2.mods.chesttransporter.chests.TransportableChestOld;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.blocks.BlocksTC;

@Mod.EventBusSubscriber(modid="metalchests")
class ModuleChestTransporter {
    ModuleChestTransporter() {
    }

    @Optional.Method(modid="chesttransporter")
    @SubscribeEvent
    public static void registerChestTransporter(RegistryEvent.Register<TransportableChest> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new MetalChest(BlocksMC.METAL_CHEST, "metal_chest"));
        if (ModSupport.hasThaumcraft()) {
            registry.register((IForgeRegistryEntry)new TransportableChestOld(BlocksTC.hungryChest, -1, 1, "vanilla"));
            registry.register((IForgeRegistryEntry)new MetalChest(BlocksMC.HUNGRY_METAL_CHEST, "hungry/", "hungry_metal_chest"));
        }
        if (ModSupport.hasRefinedRelocation()) {
            registry.register((IForgeRegistryEntry)new MetalChest(BlocksMC.SORTING_METAL_CHEST, "sorting_metal_chest"));
            if (ModSupport.hasThaumcraft()) {
                registry.register((IForgeRegistryEntry)new MetalChest(BlocksMC.SORTING_HUNGRY_METAL_CHEST, "hungry/", "sorting_hungry_metal_chest"));
            }
        }
    }

    static class MetalChest
    extends TransportableChestImpl {
        private final String prefix;

        public MetalChest(Block chestBlock, String prefix, String name) {
            super(chestBlock, -1, name);
            this.prefix = prefix;
        }

        public MetalChest(Block chestBlock, String name) {
            this(chestBlock, "", name);
        }

        public boolean copyTileEntity() {
            return true;
        }

        public ItemStack createChestStack(ItemStack transporter) {
            ItemStack stack = super.createChestStack(transporter);
            NBTTagCompound tag = transporter.func_77978_p().func_74775_l("ChestTile");
            String chestType = tag.func_74779_i("ChestType");
            stack.func_77964_b(ChestType.valueOf(chestType).ordinal());
            return stack;
        }

        public ResourceLocation getChestModel(ItemStack transporter) {
            NBTTagCompound tag = transporter.func_77978_p().func_74775_l("ChestTile");
            String chestType = tag.func_74779_i("ChestType");
            return new ResourceLocation("metalchests", "item/chesttransporter/" + this.prefix + chestType.toLowerCase());
        }

        public Collection<ResourceLocation> getChestModels() {
            ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>();
            for (ChestType type : ChestType.values()) {
                models.add(new ResourceLocation("metalchests", "item/chesttransporter/" + this.prefix + type.func_176610_l()));
            }
            return models;
        }

        public NBTTagCompound modifyTileCompound(NBTTagCompound tag, World world, BlockPos pos, EntityPlayer player, ItemStack transporter) {
            tag.func_74778_a("Front", player.func_174811_aO().func_176734_d().toString());
            return super.modifyTileCompound(tag, world, pos, player, transporter);
        }
    }
}

