/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguides.gui.components;

import com.feed_the_beast.ftblib.lib.util.text_components.TextComponentParser;
import com.feed_the_beast.mods.ftbguides.gui.GuidePage;
import com.feed_the_beast.mods.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.HRGuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.ImageGuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.LineBreakGuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.TextGuideComponent;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class ComponentPage {
    public static final Pattern COMMENT_PATTERN = Pattern.compile("\\<\\!--(?:.|\\s)*?--\\>\\s?", 8);
    public static final Pattern I18N_PATTERN = Pattern.compile("\\{([a-zA-Z0-9\\._\\-]*?)\\}", 8);
    public static final Pattern REFERENCE_PATTERN = Pattern.compile("^\\[\\s*(.*?)\\s*\\]\\:\\s*(.*?)\\s*$\\s?", 8);
    public static final Pattern STRIKETHROUGH_PATTERN = Pattern.compile("(?<!\\\\)(\\~\\~)(.+?)\\1");
    public static final String STRIKETHROUGH_REPLACE = "&m$2&m";
    public static final Pattern BOLD_PATTERN = Pattern.compile("(?<!\\\\)(\\*\\*|__)(.+?)\\1");
    public static final String BOLD_REPLACE = "&l$2&l";
    public static final Pattern ITALIC_PATTERN = Pattern.compile("(?<!\\\\)(\\*|_)(.+?)\\1");
    public static final String ITALIC_REPLACE = "&o$2&o";
    public static final Pattern LINK_PATTERN = Pattern.compile("^(!)?\\[(.*)\\]\\((.*)\\)$");
    public static final Pattern HR_PATTERN = Pattern.compile("^-{3,}|\\*{3,}|_{3,}$");
    public static final Pattern HEADING_PATTERN = Pattern.compile("^(#+)\\s*(.*)$");
    public static final Pattern POST_PROCESSING_PATTERN = Pattern.compile("\\\\(\\\\|\\*|_|\\~)");
    public static final String POST_PROCESSING_REPLACE = "$1";
    public final GuidePage page;
    public final List<GuideComponent> components;
    private final Map<String, String> references;

    public ComponentPage(GuidePage p) {
        this.page = p;
        this.components = new ArrayList<GuideComponent>();
        this.references = new HashMap<String, String>();
    }

    public String getReference(String key) {
        String s = this.references.get(key);
        return s == null ? "" : s;
    }

    public void println(GuideComponent component) {
        if (!this.components.isEmpty() && component.isInline()) {
            this.components.add(LineBreakGuideComponent.INSTANCE);
        }
        this.components.add(component);
    }

    public void println(String text) {
        this.println(text.isEmpty() ? LineBreakGuideComponent.INSTANCE : new TextGuideComponent(text));
    }

    public void println() {
        this.println(LineBreakGuideComponent.INSTANCE);
    }

    public void println(@Nullable ITextComponent component) {
        if (component != null) {
            for (ITextComponent c : component) {
                TextGuideComponent t = new TextGuideComponent(c.func_150261_e());
                t.bold = c.func_150256_b().func_150223_b();
                t.italic = c.func_150256_b().func_150242_c();
                t.strikethrough = c.func_150256_b().func_150236_d();
                t.underlined = c.func_150256_b().func_150234_e();
                ClickEvent clickEvent = c.func_150256_b().func_150235_h();
                if (clickEvent != null) {
                    t.click = clickEvent.func_150669_a().func_150673_b() + ":" + clickEvent.func_150668_b();
                }
                this.components.add(t);
            }
        }
        this.components.add(LineBreakGuideComponent.INSTANCE);
    }

    public void processAsMarkdown(String text) {
        String[] lines;
        if (text.isEmpty()) {
            return;
        }
        text = COMMENT_PATTERN.matcher(text).replaceAll("");
        Matcher i18nMatcher = I18N_PATTERN.matcher(text);
        while (i18nMatcher.find()) {
            i18nMatcher.reset();
            StringBuffer sb = new StringBuffer(text.length());
            while (i18nMatcher.find()) {
                i18nMatcher.appendReplacement(sb, I18n.func_135052_a((String)i18nMatcher.group(1), (Object[])new Object[0]));
            }
            i18nMatcher.appendTail(sb);
            text = sb.toString();
            i18nMatcher = I18N_PATTERN.matcher(text);
        }
        Matcher refMatcher = REFERENCE_PATTERN.matcher(text);
        while (refMatcher.find()) {
            String key = refMatcher.group(1);
            String value = refMatcher.group(2);
            if (key.startsWith("#")) {
                if (key.length() <= 1) continue;
                this.page.properties.put(key.substring(1), (JsonElement)new JsonPrimitive(value));
                continue;
            }
            this.references.put(key, value);
        }
        text = refMatcher.replaceAll("");
        for (String s : lines = text.split("\n")) {
            this.printlnMarkdown(s);
        }
    }

    private void printlnMarkdown(String s) {
        if ((s = s.trim()).isEmpty()) {
            this.println(LineBreakGuideComponent.INSTANCE);
            return;
        }
        if (HR_PATTERN.matcher(s).matches()) {
            this.println(HRGuideComponent.INSTANCE);
            return;
        }
        boolean b = false;
        b = !s.equals(s = STRIKETHROUGH_PATTERN.matcher(s).replaceAll(STRIKETHROUGH_REPLACE)) | b;
        String string = s;
        s = BOLD_PATTERN.matcher(s).replaceAll(BOLD_REPLACE);
        b = !string.equals(s) | b;
        String string2 = s;
        b = !string2.equals(s = ITALIC_PATTERN.matcher(s).replaceAll(ITALIC_REPLACE)) | b;
        if (b) {
            s = TextComponentParser.parse((String)s, null).func_150254_d();
        }
        s = POST_PROCESSING_PATTERN.matcher(s).replaceAll(POST_PROCESSING_REPLACE);
        double scale = 1.0;
        boolean bold = false;
        int heading = 0;
        Matcher matcher = HEADING_PATTERN.matcher(s);
        if (matcher.find()) {
            heading = matcher.group(1).length();
            s = matcher.group(2);
        }
        if (heading >= 3) {
            scale = 1.25;
        } else if (heading == 2) {
            scale = 1.25;
            bold = true;
        } else if (heading == 1) {
            scale = 1.5;
            bold = true;
        }
        matcher = LINK_PATTERN.matcher(s);
        if (matcher.find()) {
            if (matcher.group(1) != null && matcher.group(1).equals("!")) {
                ImageGuideComponent component = new ImageGuideComponent(this, this.page.getIcon(matcher.group(3)));
                component.hover = matcher.group(2);
                this.println(component);
                return;
            }
            TextGuideComponent component = new TextGuideComponent(matcher.group(2));
            component.textScale = scale;
            component.bold = bold;
            component.click = matcher.group(3);
            this.println(component);
            return;
        }
        TextGuideComponent component = new TextGuideComponent(s);
        component.textScale = scale;
        component.bold = bold;
        this.println(component);
    }
}

