/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguides.gui;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.ScrollBar;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftblib.lib.util.NetUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.mods.ftbguides.FTBGuides;
import com.feed_the_beast.mods.ftbguides.FTBGuidesConfig;
import com.feed_the_beast.mods.ftbguides.FTBGuidesLocalConfig;
import com.feed_the_beast.mods.ftbguides.GuideTheme;
import com.feed_the_beast.mods.ftbguides.gui.GuidePage;
import com.feed_the_beast.mods.ftbguides.gui.SpecialGuideButton;
import com.feed_the_beast.mods.ftbguides.gui.components.ComponentPanel;
import com.feed_the_beast.mods.ftbguides.gui.components.GuideComponent;
import com.google.gson.JsonElement;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiGuide
extends GuiBase {
    private static final int SCROLLBAR_SIZE = 7;
    private Theme guideTheme;
    public final GuidePage page;
    public final ComponentPanel panelText;
    public final Panel panelTitle;
    public final Panel panelSpecialButtons;
    public final PanelScrollBar scrollBarH;
    public final PanelScrollBar scrollBarV;

    public GuiGuide(GuidePage p) {
        if (p.getRoot() == p && p.pages.size() == 1) {
            p = p.pages.get(0);
        }
        this.page = p;
        this.guideTheme = new GuideGuiTheme(this.page);
        if (FTBLibConfig.debugging.print_more_info) {
            FTBGuides.LOGGER.info("Gui opened for page " + this.page.getPath());
        }
        this.setUnicode(FTBGuidesLocalConfig.general.use_unicode_font);
        this.panelText = new ComponentPanel((Panel)this){

            @Override
            public List<GuideComponent> getComponents() {
                return GuiGuide.this.page.text.components;
            }

            @Override
            public void addWidgets() {
                this.setPosAndSize(2, 1 + GuiGuide.this.panelSpecialButtons.height, this.getGui().width - 3 - 7, this.getGui().height - 2 - GuiGuide.this.panelSpecialButtons.height - 7);
                this.maxWidth = this.width;
            }

            @Override
            public void alignWidgets() {
                GuiGuide.this.scrollBarH.setMaxValue(this.totalWidth);
                GuiGuide.this.scrollBarV.setMaxValue(this.totalHeight);
            }
        };
        this.panelTitle = new Panel((Panel)this){

            public void addWidgets() {
                ArrayList<ButtonSelectPage> list = new ArrayList<ButtonSelectPage>(1);
                list.add(new ButtonSelectPage(this, GuiGuide.this.page));
                this.addToList(GuiGuide.this.page, list);
                Collections.reverse(list);
                if (list.size() > 2 && GuiGuide.this.page.getRoot().pages.size() == 1) {
                    list.remove(0);
                    list.remove(0);
                }
                this.addAll(list);
            }

            public void alignWidgets() {
                int a = this.align(WidgetLayout.HORIZONTAL);
                this.setWidth(Math.min(a, this.parent.width - 4 - GuiGuide.this.panelSpecialButtons.width));
                if (a > this.width) {
                    this.setScrollX(-(this.width - a));
                }
            }

            public boolean isDefaultScrollVertical() {
                return false;
            }

            private void addToList(GuidePage page, List<ButtonSelectPage> list) {
                if (page.parent != null) {
                    list.add(new ButtonSelectPage(this, null));
                    list.add(new ButtonSelectPage(this, page.parent));
                    this.addToList(page.parent, list);
                }
            }
        };
        this.panelTitle.setPosAndSize(3, 1, 0, 9);
        this.panelTitle.setUnicode(FTBGuidesLocalConfig.general.use_unicode_font);
        this.panelSpecialButtons = new Panel((Panel)this){

            public void addWidgets() {
                this.add((Widget)new ButtonSpecial(this, new SpecialGuideButton(new TextComponentTranslation("ftbguides.general.theme", new Object[0]).func_150258_a(": ").func_150257_a(GuideTheme.get((String)FTBGuidesLocalConfig.general.theme).title), GuiIcons.COLOR_RGB, "theme:/")));
                this.add((Widget)new ButtonSpecial(this, new SpecialGuideButton((ITextComponent)new TextComponentTranslation("selectServer.refresh", new Object[0]), GuiIcons.REFRESH, "refresh:" + GuiGuide.this.page.getPath())));
                JsonElement url = GuiGuide.this.page.getProperty("browser_url");
                if (url.isJsonPrimitive() && !url.getAsString().isEmpty()) {
                    this.add((Widget)new ButtonSpecial(this, new SpecialGuideButton((ITextComponent)new TextComponentTranslation("ftbguides.lang.open_in_browser", new Object[0]), GuiIcons.GLOBE, url.getAsString())));
                }
                this.add((Widget)new ButtonSpecial(this, new SpecialGuideButton((ITextComponent)new TextComponentTranslation("gui.close", new Object[0]), GuiIcons.CLOSE, "close:/")));
            }

            public void alignWidgets() {
                this.setWidth(this.align(WidgetLayout.HORIZONTAL));
            }

            public void drawBackground(Theme theme, int x, int y, int w, int h) {
            }
        };
        this.panelSpecialButtons.setHeight(12);
        this.scrollBarH = new PanelScrollBar((Panel)this, ScrollBar.Plane.HORIZONTAL, (Panel)this.panelText);
        this.scrollBarH.setCanAlwaysScrollPlane(false);
        this.scrollBarH.setScrollStep(10);
        this.scrollBarV = new PanelScrollBar((Panel)this, (Panel)this.panelText);
        this.scrollBarV.setCanAlwaysScrollPlane(false);
        this.scrollBarV.setScrollStep(30);
    }

    public void addWidgets() {
        this.add((Widget)this.scrollBarH);
        this.add((Widget)this.scrollBarV);
        this.add((Widget)this.panelText);
        this.add((Widget)this.panelTitle);
        this.add((Widget)this.panelSpecialButtons);
    }

    public void alignWidgets() {
        this.panelSpecialButtons.alignWidgets();
        this.panelSpecialButtons.setPos(this.width - this.panelSpecialButtons.width, 0);
        this.scrollBarH.setPosAndSize(0, this.height - 7, this.width - 7, 7);
        this.scrollBarV.setPosAndSize(this.width - 7, this.panelSpecialButtons.height - 1, 7, this.height - 7 - 4);
        this.panelText.alignWidgets();
        this.panelTitle.alignWidgets();
    }

    public boolean onInit() {
        if (this.page == this.page.getRoot() && !FTBGuidesLocalConfig.general.last_guide_version.equals(FTBGuidesConfig.general.modpack_guide_version)) {
            FTBGuidesLocalConfig.general.last_guide_version = FTBGuidesConfig.general.modpack_guide_version;
            FTBGuidesConfig.sync();
            FTBGuides.openGuidesGui("/modpack_guide");
        }
        int w = (int)((double)FTBGuidesLocalConfig.general.width_percent * this.getScreen().func_78327_c() * 0.01);
        this.setWidth(w);
        this.setX(w / 2);
        this.setHeight(this.getScreen().func_78328_b() - 6);
        this.setY(3);
        return true;
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        this.page.background.bindTexture();
        if (this.page.background instanceof ImageIcon) {
            GuiHelper.drawTexturedRect((int)this.posX, (int)this.posY, (int)this.width, (int)this.height, (Color4I)Color4I.WHITE, (double)0.0, (double)0.0, (double)((double)this.width / 128.0), (double)((double)this.height / 128.0));
        } else {
            this.page.background.draw(this.posX, this.posY, this.width, this.height);
        }
        GuiHelper.drawHollowRect((int)this.posX, (int)this.posY, (int)w, (int)h, (Color4I)this.page.lineColor, (boolean)false);
        this.page.lineColor.draw(this.scrollBarV.getX(), this.scrollBarV.getY(), 1, this.scrollBarV.height);
        this.page.lineColor.draw(this.posX, this.scrollBarH.getY(), this.scrollBarH.width, 1);
        this.page.lineColor.draw(this.posX, this.posY + this.panelSpecialButtons.height - 1, w, 1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public Theme getTheme() {
        return this.guideTheme;
    }

    public boolean keyPressed(int key, char keyChar) {
        if (key == 63) {
            return this.handleClick("refresh:" + this.page.getPath());
        }
        if (key == 199) {
            FTBGuides.openGuidesGui("/");
            return true;
        }
        if (key == 14) {
            if (this.page.parent != null) {
                FTBGuides.openGuidesGui(this.page.parent.getPath());
            }
            return true;
        }
        if (key == 209) {
            return true;
        }
        return super.keyPressed(key, keyChar);
    }

    public boolean mousePressed(MouseButton button) {
        if (button.id == 3) {
            return this.keyPressed(14, '\u0000');
        }
        if (button.id == 4) {
            return this.keyPressed(209, '\u0000');
        }
        return super.mousePressed(button);
    }

    public boolean handleClick(String scheme, String path) {
        if (scheme.isEmpty() || scheme.equals("page")) {
            GuidePage p = this.page.getSubFromPath(path);
            if (p != null) {
                block9: {
                    if (GuiGuide.isShiftKeyDown() && GuiGuide.isCtrlKeyDown()) {
                        try {
                            URI uri = p.resolveURI("./");
                            if (uri != null) {
                                NetUtils.openURI((URI)uri);
                                return true;
                            }
                            break block9;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            return false;
                        }
                    }
                    FTBGuides.openGuidesGui(p.getPath());
                }
                return true;
            }
            return false;
        }
        if (scheme.equals("close")) {
            this.closeGui(false);
            return true;
        }
        if (scheme.equals("refresh")) {
            String p = this.page.getPath();
            FTBGuides.setShouldReload();
            Minecraft.func_71410_x().func_110434_K().func_110549_a(Minecraft.func_71410_x().func_110442_L());
            FTBGuides.openGuidesGui(p);
            return true;
        }
        if (scheme.equals("theme")) {
            FTBGuidesLocalConfig.general.theme = GuideTheme.get((String)FTBGuidesLocalConfig.general.theme).next.getID();
            FTBGuidesConfig.sync();
            this.page.getRoot().updateCachedProperties(true);
            this.refreshWidgets();
            return true;
        }
        return super.handleClick(scheme, path);
    }

    public boolean onClosedByKey(int key) {
        return super.onClosedByKey(key) || FTBGuides.KEY_GUIDE.isActiveAndMatches(key);
    }

    private static class ButtonSpecial
    extends Button {
        private final SpecialGuideButton specialInfoButton;

        public ButtonSpecial(Panel panel, SpecialGuideButton b) {
            super(panel);
            this.setSize(12, 12);
            this.specialInfoButton = b;
            this.setTitle(this.specialInfoButton.title.func_150254_d());
        }

        public void onClicked(MouseButton button) {
            if (this.handleClick(this.specialInfoButton.click)) {
                GuiHelper.playClickSound();
            }
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            this.specialInfoButton.icon.draw(x + 2, y + 2, 8, 8);
        }
    }

    private static class ButtonSelectPage
    extends Button {
        private GuidePage page;

        public ButtonSelectPage(Panel panel, @Nullable GuidePage p) {
            super(panel, p == null ? "/" : p.getDisplayName().func_150254_d(), (Icon)Icon.EMPTY);
            this.setSize(this.getGui().getTheme().getStringWidth(this.getTitle()), 9);
            this.page = p;
        }

        public void onClicked(MouseButton button) {
            if (this.page != null) {
                GuiHelper.playClickSound();
                this.handleClick("page:" + this.page.getPath());
            }
        }

        public void addMouseOverText(List<String> list) {
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            boolean mouseOver = this.page != null && this.isMouseOver();
            theme.drawString(this.getTitle(), x, y, mouseOver ? 16 : 0);
        }
    }

    public static class GuideGuiTheme
    extends Theme {
        public final GuidePage page;

        public GuideGuiTheme(GuidePage p) {
            this.page = p;
        }

        public Color4I getContentColor(WidgetType type) {
            return type == WidgetType.MOUSE_OVER ? this.page.textColorMouseOver : this.page.textColor;
        }

        public void drawGui(int x, int y, int w, int h, WidgetType type) {
        }

        public void drawWidget(int x, int y, int w, int h, WidgetType type) {
        }

        public void drawSlot(int x, int y, int w, int h, WidgetType type) {
        }

        public void drawPanelBackground(int x, int y, int w, int h) {
        }

        public void drawScrollBarBackground(int x, int y, int w, int h, WidgetType type) {
        }

        public void drawScrollBar(int x, int y, int w, int h, WidgetType type, boolean vertical) {
            this.getContentColor(type).withAlpha(100).draw(x + 1, y + 1, w - 2, h - 2);
        }
    }
}

