/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguides;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.mods.ftbguides.FTBGuides;
import com.feed_the_beast.mods.ftbguides.FTBGuidesConfig;
import com.feed_the_beast.mods.ftbguides.GuideTheme;
import com.feed_the_beast.mods.ftbguides.events.ClientGuideEvent;
import com.feed_the_beast.mods.ftbguides.gui.GuiGuide;
import com.feed_the_beast.mods.ftbguides.gui.GuidePage;
import com.feed_the_beast.mods.ftbguides.gui.GuideTitlePage;
import com.feed_the_beast.mods.ftbguides.gui.GuideType;
import com.feed_the_beast.mods.ftbguides.gui.SpecialGuideButton;
import com.feed_the_beast.mods.ftbguides.gui.components.HRGuideComponent;
import com.feed_the_beast.mods.ftbguides.gui.components.ImageGuideComponent;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.Proxy;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

class ThreadLoadGuides
extends Thread {
    GuiLoading gui;
    GuidePage root;
    private boolean loaded = false;

    ThreadLoadGuides() {
        super("Guide Loader");
        this.setDaemon(true);
        this.gui = new GuiLoading(){

            public void finishLoading() {
                FTBGuides.reloadingThread = null;
                if (ThreadLoadGuides.this.loaded) {
                    FTBGuides.guidesGui = new GuiGuide(ThreadLoadGuides.this.root);
                    FTBGuides.openGuidesGui("");
                } else {
                    ThreadLoadGuides.this.gui.closeGui(false);
                }
            }
        };
    }

    @Override
    public void run() {
        try {
            String s = this.run1();
            if (!s.isEmpty()) {
                FTBGuides.LOGGER.error(s);
            }
            this.loaded = true;
        }
        catch (Exception ex) {
            FTBGuides.reloadingThread = null;
            ex.printStackTrace();
        }
        this.gui.setFinished();
    }

    public String run1() {
        IResourceManager resourceManager;
        Proxy proxy;
        Minecraft mc;
        block26: {
            mc = Minecraft.func_71410_x();
            GuideTheme.THEMES.clear();
            proxy = mc.func_110437_J();
            resourceManager = mc.func_110442_L();
            try {
                for (IResource resource : resourceManager.func_135056_b(new ResourceLocation("ftbguides", "themes/index.json"))) {
                    JsonElement json = DataReader.get((IResource)resource).json();
                    if (!json.isJsonArray()) continue;
                    for (JsonElement element : json.getAsJsonArray()) {
                        String id = element.getAsString();
                        JsonElement json1 = DataReader.get((IResource)resourceManager.func_110536_a(new ResourceLocation("ftbguides", "themes/" + (String)id + ".json"))).json();
                        if (!json1.isJsonObject()) continue;
                        JsonObject o = json1.getAsJsonObject();
                        GuideTheme theme = new GuideTheme(id);
                        GuideTheme.THEMES.put(id, theme);
                        theme.title = o.has("title") ? JsonUtils.deserializeTextComponent((JsonElement)o.get("title")) : new TextComponentString(id);
                        theme.background = Icon.getIcon((JsonElement)o.get("background"));
                        theme.text = Color4I.fromJson((JsonElement)o.get("text"));
                        theme.textMouseOver = Color4I.fromJson((JsonElement)o.get("text_mouse_over"));
                        theme.lines = Color4I.fromJson((JsonElement)o.get("lines"));
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) break block26;
                ex.printStackTrace();
            }
        }
        if (!GuideTheme.THEMES.isEmpty()) {
            GuideTheme prevTheme = null;
            for (GuideTheme theme : GuideTheme.THEMES.values()) {
                if (prevTheme != null) {
                    prevTheme.next = theme;
                }
                prevTheme = theme;
            }
            if (prevTheme != null) {
                prevTheme.next = GuideTheme.THEMES.values().iterator().next();
            }
        }
        if (FTBLibConfig.debugging.print_more_info) {
            FTBGuides.LOGGER.info("Loaded Guide Themes: " + GuideTheme.THEMES.values());
        }
        String langCode = mc.func_135016_M().func_135041_c().func_135034_a();
        this.gui.setTitle("Loading Guides\n" + I18n.func_135052_a((String)"ftbguides.lang.type.modpack", (Object[])new Object[0]));
        File modpackGuideFile = new File(Loader.instance().getConfigDir(), "ftbguides/modpack_guide/");
        if (!modpackGuideFile.exists()) {
            modpackGuideFile.mkdirs();
        }
        URI modpackGuide = modpackGuideFile.toURI();
        URI modpackGuideFallback = null;
        if (!langCode.equals("en_us")) {
            modpackGuideFallback = modpackGuide;
            modpackGuide = new File(Loader.instance().getConfigDir(), "ftbguides/modpack_guide_" + langCode + "/").toURI();
        }
        this.root = new GuidePage("root", null);
        this.root.title = new TextComponentTranslation("ftbguides.lang.home", new Object[0]);
        GuideTitlePage modpackGuidePage = new GuideTitlePage("modpack", this.root, GuideType.MODPACK);
        modpackGuidePage.textURI = modpackGuide.resolve("README.md");
        modpackGuidePage.fallbackTextURI = modpackGuideFallback == null ? null : modpackGuideFallback.resolve("README.md");
        modpackGuidePage.title = new TextComponentTranslation(GuideType.MODPACK.title, new Object[0]);
        this.loadChildPages(modpackGuidePage, modpackGuide, modpackGuideFallback, proxy, 0);
        modpackGuidePage.cleanup();
        if (!modpackGuidePage.isEmpty()) {
            this.root.addSub(modpackGuidePage);
        }
        if (!FTBGuidesConfig.general.disable_non_modpack_guides) {
            for (String modid : resourceManager.func_135055_a()) {
                GuideTitlePage page;
                this.gui.setTitle("Loading Guides\n" + I18n.func_135052_a((String)"ftbguides.lang.type.mod", (Object[])new Object[0]) + "\n" + modid);
                ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modid);
                if (mod != null) {
                    String s;
                    page = new GuideTitlePage(modid, this.root, GuideType.MOD);
                    page.title = new TextComponentString(mod.getName());
                    String logo = mod.getMetadata().logoFile;
                    Color4I logoIcon = Icon.EMPTY;
                    if (!logo.isEmpty() && logo.startsWith(s = "assets/" + modid + "/")) {
                        page.icon = Icon.getIcon((String)(modid + ":" + logo.substring(s.length())));
                    }
                    if (!logoIcon.isEmpty()) {
                        page.icon = logoIcon;
                    }
                    if (!mod.getMetadata().url.isEmpty()) {
                        this.root.properties.put("browser_url", (JsonElement)new JsonPrimitive(mod.getMetadata().url));
                    }
                    page.text.println(new ImageGuideComponent(page.text, page.icon));
                    page.text.println("(Auto-generated)");
                    if (!mod.getMetadata().description.isEmpty()) {
                        page.text.println(HRGuideComponent.INSTANCE);
                        for (String s2 : mod.getMetadata().description.split("\n")) {
                            page.text.println(s2);
                        }
                    }
                } else {
                    page = new GuideTitlePage(modid, this.root, GuideType.OTHER);
                    page.title = new TextComponentString(modid);
                }
                try {
                    URI uri = new URI("mcresource:/" + modid + ":guide/");
                    URI fallbackUri = null;
                    this.loadChildPages(page, uri, fallbackUri, proxy, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.root.addSub(page);
            }
        }
        this.gui.setTitle("Loading Guides\nCustom Mod Guides");
        new ClientGuideEvent(this.root).post();
        this.gui.setTitle("Loading Guides\nFinishing");
        this.root.cleanup();
        this.root.textLoadingState = 1;
        List modpackText = Collections.emptyList();
        try {
            URI modpackGuideURI = modpackGuidePage.resolveTextURI();
            if (modpackGuideURI != null) {
                modpackText = DataReader.get((URI)modpackGuideURI, (Proxy)proxy).safeStringList();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        modpackGuidePage.onPageLoaded(modpackText);
        this.root.updateCachedProperties(true);
        this.root.onPageLoaded(Collections.emptyList());
        return "";
    }

    private void loadChildPages(GuidePage parent, URI parentURI, @Nullable URI fallbackParentURI, Proxy proxy, int depth) {
        if (depth > 10) {
            FTBGuides.LOGGER.warn("Depth is > 10, stopping at " + parent.getID());
            return;
        }
        URI indexJson = parent.resolveURI("./index.json");
        if (indexJson == null) {
            return;
        }
        JsonElement index = DataReader.get((URI)indexJson, (Proxy)proxy).safeJson();
        if (index.isJsonArray()) {
            for (JsonElement element : index.getAsJsonArray()) {
                Iterator t;
                JsonObject pageData;
                if (!element.isJsonObject() || !(pageData = element.getAsJsonObject()).has("id")) continue;
                GuidePage page = parent.getSub(pageData.get("id").getAsString());
                URI uri = parentURI.resolve(page.getID() + "/");
                URI fallbackUri = fallbackParentURI == null ? null : fallbackParentURI.resolve(page.getID() + "/");
                FTBGuides.LOGGER.info("Loading " + page.getPath() + " from " + uri);
                page.title = pageData.has("title") ? (((String)((Object)(t = pageData.get("title").getAsString()))).startsWith("${") && ((String)((Object)t)).endsWith("}") ? new TextComponentTranslation(((String)((Object)t)).substring(2, ((String)((Object)t)).length() - 1), new Object[0]) : new TextComponentString((String)((Object)t))) : new TextComponentString(page.getID());
                page.textURI = uri.resolve("README.md");
                URI uRI = page.fallbackTextURI = fallbackUri == null ? null : fallbackUri.resolve("README.md");
                if (pageData.has("icon")) {
                    page.icon = page.getIcon(pageData.get("icon"));
                    if (page.icon.isEmpty()) {
                        page.icon = GuidePage.DEFAULT_ICON;
                    }
                }
                if (pageData.has("buttons")) {
                    t = pageData.get("buttons").getAsJsonArray().iterator();
                    while (t.hasNext()) {
                        JsonElement e = (JsonElement)t.next();
                        page.specialButtons.add(new SpecialGuideButton(e.getAsJsonObject()));
                    }
                }
                if (pageData.has("properties")) {
                    t = pageData.get("properties").getAsJsonObject().entrySet().iterator();
                    while (t.hasNext()) {
                        Map.Entry entry = (Map.Entry)t.next();
                        page.properties.put((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                }
                try {
                    this.loadChildPages(page, uri, fallbackUri, proxy, depth + 1);
                }
                catch (StackOverflowError error) {
                    FTBGuides.LOGGER.error("Failed to load " + page.getPath() + " child pages!");
                }
            }
        }
    }
}

