/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguides;

import com.feed_the_beast.mods.ftbguides.FTBGuidesConfig;
import com.feed_the_beast.mods.ftbguides.GuideReloadListener;
import com.feed_the_beast.mods.ftbguides.ThreadLoadGuides;
import com.feed_the_beast.mods.ftbguides.gui.GuiGuide;
import com.feed_the_beast.mods.ftbguides.gui.GuidePage;
import com.feed_the_beast.mods.ftbguides.gui.ThreadLoadPage;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ftbguides", name="FTB Guides", version="2.0.0.47", clientSideOnly=true, dependencies="required-after:ftblib@[5.4.3.115,);after:tconstruct", acceptedMinecraftVersions="[1.12.2]")
public class FTBGuides {
    public static final String MOD_ID = "ftbguides";
    public static final String MOD_NAME = "FTB Guides";
    public static final String VERSION = "2.0.0.47";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Guides");
    public static KeyBinding KEY_GUIDE;
    static GuiGuide guidesGui;
    static ThreadLoadGuides reloadingThread;
    public static String pageToOpen;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        FTBGuidesConfig.sync();
        KEY_GUIDE = new KeyBinding("key.ftbguides.guide", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 0, "key.categories.ftbmods");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_GUIDE);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        if (Minecraft.func_71410_x().func_110442_L() instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new GuideReloadListener());
        }
    }

    public static void setShouldReload() {
        guidesGui = null;
        if (reloadingThread != null) {
            try {
                reloadingThread.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            reloadingThread = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean openGuidesGui(String path) {
        GuidePage page;
        if (!path.isEmpty()) {
            pageToOpen = path;
        }
        if (guidesGui == null) {
            if (reloadingThread == null) {
                reloadingThread = new ThreadLoadGuides();
                reloadingThread.start();
            }
            FTBGuides.reloadingThread.gui.openGui();
            return false;
        }
        if (!pageToOpen.isEmpty() && (page = FTBGuides.guidesGui.page.getSubFromPath(pageToOpen)) != null) {
            if (page.textLoadingState == 0) {
                if (page.textURI != null) {
                    new ThreadLoadPage(page).start();
                    return false;
                }
                page.onPageLoaded(Collections.emptyList());
                pageToOpen = "";
            } else {
                guidesGui = new GuiGuide(page);
                pageToOpen = "";
            }
        }
        guidesGui.openGui();
        return true;
    }

    static {
        guidesGui = null;
        reloadingThread = null;
        pageToOpen = "";
    }
}

