/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.world.saved_data;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class AncientCacheSavedData
extends WorldSavedData {
    private List<BlockPos> caches = Lists.newArrayList();

    public AncientCacheSavedData() {
        super("tg:AncientCacheSavedData");
    }

    public AncientCacheSavedData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagList list;
        if (compound.func_74764_b("caches") && (list = compound.func_150295_c("caches", 10)).func_74745_c() > 0) {
            this.caches.clear();
            for (int q = 0; q < list.func_74745_c(); ++q) {
                NBTTagCompound t = list.func_150305_b(q);
                this.caches.add(new BlockPos(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z")));
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        if (!this.caches.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (BlockPos p : this.caches) {
                NBTTagCompound pos = new NBTTagCompound();
                pos.func_74768_a("x", p.func_177958_n());
                pos.func_74768_a("y", p.func_177956_o());
                pos.func_74768_a("z", p.func_177952_p());
                list.func_74742_a((NBTBase)pos);
            }
            compound.func_74782_a("caches", (NBTBase)list);
        }
        return compound;
    }

    public AncientCacheSavedData addNewPos(BlockPos pos) {
        this.caches.add(pos);
        this.func_76185_a();
        return this;
    }

    public List<BlockPos> getCaches() {
        return this.caches;
    }

    public BlockPos getNearestCache(BlockPos pos) {
        Vec3d vec = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        return this.getNearestCache(vec);
    }

    public BlockPos getNearestCache(Vec3d pos) {
        if (!this.caches.isEmpty()) {
            double distance = Double.MAX_VALUE;
            int id = -1;
            for (int q = 0; q < this.caches.size(); ++q) {
                double dis = new Vec3d((double)this.caches.get(q).func_177958_n(), (double)this.caches.get(q).func_177956_o(), (double)this.caches.get(q).func_177952_p()).func_72438_d(pos);
                if (!(dis < distance)) continue;
                distance = dis;
                id = q;
            }
            if (id > -1) {
                return this.caches.get(id);
            }
        }
        return null;
    }

    public static AncientCacheSavedData get(World world) {
        AncientCacheSavedData data = (AncientCacheSavedData)world.getPerWorldStorage().func_75742_a(AncientCacheSavedData.class, "tg:AncientCacheSavedData");
        if (data == null) {
            data = new AncientCacheSavedData("tg:AncientCacheSavedData");
            world.getPerWorldStorage().func_75745_a("tg:AncientCacheSavedData", (WorldSavedData)data);
        }
        return data;
    }
}

