/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.util.handlers;

import com.ancient.thaumicgadgets.blocks.plants.BlockPlant;
import com.ancient.thaumicgadgets.init.ModBlocks;
import com.ancient.thaumicgadgets.init.ModItems;
import com.ancient.thaumicgadgets.items.seeds.ItemSeed;
import com.google.common.collect.Lists;
import java.util.List;

public class PlantsManager {
    public static final PlantsManager INSTANCE = new PlantsManager();
    private final List<PlantEntryChild> list = Lists.newArrayList();

    public PlantsManager() {
        this.list.clear();
        this.addPlant((ItemSeed)ModItems.SHADE_ROSE_BUSH_SEED, (BlockPlant)ModBlocks.SHADE_ROSE_BUSH, (ItemSeed)ModItems.SHADE_ROSE_SEED, (BlockPlant)ModBlocks.SHADE_ROSE);
        this.addPlant((ItemSeed)ModItems.SHADE_ROSE_SEED, (BlockPlant)ModBlocks.SHADE_ROSE, null, null);
        this.addPlant((ItemSeed)ModItems.LIGHT_ROSE_BUSH_SEED, (BlockPlant)ModBlocks.LIGHT_ROSE_BUSH, (ItemSeed)ModItems.LIGHT_ROSE_SEED, (BlockPlant)ModBlocks.LIGHT_ROSE);
        this.addPlant((ItemSeed)ModItems.LIGHT_ROSE_SEED, (BlockPlant)ModBlocks.LIGHT_ROSE, null, null);
    }

    public static PlantsManager getInstance() {
        return INSTANCE;
    }

    public void addPlant(ItemSeed seed, BlockPlant plant, ItemSeed childSeed, BlockPlant childPlant) {
        if (seed != null && plant != null) {
            this.list.add(new PlantEntryChild(seed, plant, childSeed, childPlant));
        }
    }

    public void addPlant(PlantEntry main, PlantEntry child) {
        this.addPlant(main.getSeed(), main.getPlant(), child.getSeed(), child.getPlant());
    }

    public BlockPlant getCrop(ItemSeed seed) {
        BlockPlant b = null;
        for (PlantEntryChild e : this.list) {
            if (!e.getSeed().equals(seed)) continue;
            b = e.getPlant();
        }
        return b;
    }

    public ItemSeed getSeed(BlockPlant plant) {
        ItemSeed s = null;
        for (PlantEntryChild e : this.list) {
            if (!e.getPlant().equals(plant)) continue;
            s = e.getSeed();
        }
        return s;
    }

    public boolean hasChild(ItemSeed seed) {
        return !this.getChild(seed).isEmpty();
    }

    public boolean hasChild(BlockPlant plant) {
        return !this.getChild(plant).isEmpty();
    }

    public PlantEntry getChild(ItemSeed seed) {
        PlantEntry p = new PlantEntry(null, null);
        for (PlantEntryChild e : this.list) {
            if (!e.getSeed().equals(seed)) continue;
            p = e.getChildEntry();
        }
        return p;
    }

    public PlantEntry getChild(BlockPlant plant) {
        PlantEntry p = new PlantEntry(null, null);
        for (PlantEntryChild e : this.list) {
            if (!e.getPlant().equals(plant)) continue;
            p = e.getChildEntry();
        }
        return p;
    }

    public class PlantEntryChild
    extends PlantEntry {
        protected ItemSeed childSeed;
        protected BlockPlant childPlant;

        public PlantEntryChild(PlantEntry main, PlantEntry child) {
            super(main.getSeed(), main.getPlant());
            this.childSeed = child.getSeed();
            this.childPlant = child.getPlant();
        }

        public PlantEntryChild(ItemSeed mainSeed, BlockPlant mainPlant, ItemSeed childSeed, BlockPlant childPlant) {
            super(mainSeed, mainPlant);
            this.childSeed = childSeed;
            this.childPlant = childPlant;
        }

        public BlockPlant getChildPlant() {
            return this.childPlant;
        }

        public ItemSeed getChildSeed() {
            return this.childSeed;
        }

        public PlantEntry getMainEntry() {
            return this.getEntry();
        }

        public PlantEntry getChildEntry() {
            return new PlantEntry(this.getChildSeed(), this.getChildPlant());
        }

        public PlantEntryChild getFullEntry() {
            return this;
        }
    }

    public class PlantEntry {
        protected ItemSeed seed;
        protected BlockPlant plant;

        public PlantEntry(ItemSeed seed, BlockPlant plant) {
            this.seed = seed;
            this.plant = plant;
        }

        public ItemSeed getSeed() {
            return this.seed;
        }

        public BlockPlant getPlant() {
            return this.plant;
        }

        public PlantEntry getEntry() {
            return this;
        }

        public boolean isEmpty() {
            return this.equals(new PlantEntry(null, null));
        }

        public boolean equals(Object obj) {
            PlantEntry o;
            return obj instanceof PlantEntry && this.seed == (o = (PlantEntry)obj).getSeed() && this.plant == o.getPlant();
        }
    }
}

