/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.teleportator;

import com.ancient.thaumicgadgets.gui.GuiDynamic;
import com.ancient.thaumicgadgets.gui.GuiFilterList;
import com.ancient.thaumicgadgets.gui.GuiTabButton;
import com.ancient.thaumicgadgets.gui.GuiTexturedButton;
import com.ancient.thaumicgadgets.network.MessageServerTeleportatorActiveTp;
import com.ancient.thaumicgadgets.network.MessageServerTeleportatorName;
import com.ancient.thaumicgadgets.objects.machines.teleportator.TileEntityTeleportator;
import com.ancient.thaumicgadgets.util.IFunctionLibrary;
import com.ancient.thaumicgadgets.util.IWorldPos;
import com.ancient.thaumicgadgets.util.Reference;
import com.ancient.thaumicgadgets.util.handlers.IRandomNameGenerator;
import com.ancient.thaumicgadgets.util.handlers.NetworkHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class GuiTeleportator
extends GuiDynamic {
    private static final ResourceLocation FONT_TEXTURE = new ResourceLocation("tg", "textures/gui/teleportator.png");
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("tg", "textures/gui/gui.png");
    private GuiTextField nameField;
    private String name = "";
    private Map<IWorldPos.worldPos, String> pos = Maps.newHashMap();
    private static final Random rd = new Random();
    TileEntityTeleportator tp;
    private GuiTexturedButton TpActive;
    private final List<String> ActiveDescr = Lists.newArrayList();

    public GuiTeleportator() {
        this.tp = null;
    }

    public GuiTeleportator(TileEntityTeleportator tp) {
        this.tp = tp;
    }

    @Override
    public void func_73866_w_() {
        this.ActiveDescr.add(I18n.func_135052_a((String)"teleportator.description.not_enought", (Object[])new Object[0]));
        this.ActiveDescr.add(I18n.func_135052_a((String)"teleportator.description.start_tp", (Object[])new Object[0]));
        GuiTabButton tabMenu = new GuiTabButton(0, true, this.field_146294_l / 2 - 118, this.field_146295_m / 2 - 114, 57, 15, "Menu", GUI_TEXTURE, 73, 4, 5, 4, 256, 256);
        GuiTabButton tabOptions = new GuiTabButton(1, false, this.field_146294_l / 2 - 60, this.field_146295_m / 2 - 114, 57, 15, "Options", GUI_TEXTURE, 73, 4, 5, 4, 256, 256);
        this.nameField = new GuiTextField(3, this.field_146289_q, this.field_146294_l / 2 - 114, this.field_146295_m / 2 - 72, 107, 13);
        this.nameField.func_146203_f(64);
        this.name = this.tp.getCustomName();
        if (this.name.equals("")) {
            IWorldPos.worldPos pos = new IWorldPos.worldPos(this.tp.func_145831_w().field_73011_w.getDimension(), this.tp.func_174877_v().func_177958_n(), this.tp.func_174877_v().func_177956_o(), this.tp.func_174877_v().func_177952_p());
            this.name = I18n.func_135052_a((String)"teleportator.description.pos", (Object[])new Object[0]) + " " + pos.x + " " + pos.y + " " + pos.z;
            this.tp.setCustomName(this.name);
            NetworkHandler.sendToServer(new MessageServerTeleportatorName(pos, this.name));
        }
        this.nameField.func_146180_a(this.name);
        GuiDynamic.Tab tab0 = new GuiDynamic.Tab(0, tabMenu);
        GuiDynamic.Tab tab1 = new GuiDynamic.Tab(1, tabOptions);
        tab1.textFields.put(this.nameField, this.name);
        EntityPlayerSP pl = this.field_146297_k.field_71439_g;
        NBTTagCompound tag = pl.getEntityData();
        NBTTagList list = tag.func_150295_c("thaumic_gadgets", 10);
        NBTTagCompound tp = list.func_150305_b(Reference.getNBTPlayerIndexFromString("tpCoords"));
        NBTTagList coords = tp.func_150295_c("tpCoords", 10);
        this.pos.clear();
        if (coords.func_74745_c() > 0) {
            for (int q = 0; q < coords.func_74745_c(); ++q) {
                NBTTagCompound t = coords.func_150305_b(q);
                this.pos.put(new IWorldPos.worldPos(t.func_74762_e("dimension"), t.func_74762_e("posX"), t.func_74762_e("posY"), t.func_74762_e("posZ")), t.func_74779_i("name"));
            }
        }
        ArrayList st = Lists.newArrayList();
        for (String s : this.pos.values()) {
            st.add(s);
        }
        GuiFilterList filterList = new GuiFilterList(25, this.field_146294_l / 2 - 114, this.field_146295_m / 2 - 74, 136, 170, st, 8, this.field_146289_q, 0xA0A0A0, 0, 26);
        tab0.filterList.add(filterList);
        GuiLabel ch = new GuiLabel(this.field_146289_q, 47, this.field_146294_l / 2 - 110, this.field_146295_m / 2 - 90, 107, 13, 3976521);
        ch.func_175202_a(I18n.func_135052_a((String)"teleportator.description.choose_address", (Object[])new Object[0]));
        tab0.labels.add(ch);
        this.TpActive = new GuiTexturedButton(6, this.field_146294_l / 2 + 30, this.field_146295_m / 2 - 74, 31, 31, "", GUI_TEXTURE, 136, 21, 256, 256);
        tab0.guiButtons.add(this.TpActive);
        tab1.guiButtons.add(new GuiTexturedButton(4, this.field_146294_l / 2 + 7, this.field_146295_m / 2 - 40, 17, 17, "", GUI_TEXTURE, 142, 137, 256, 256));
        tab1.guiButtons.add(new GuiTexturedButton(5, this.field_146294_l / 2 + 1, this.field_146295_m / 2 - 78, 31, 31, "", GUI_TEXTURE, 136, 21, 256, 256));
        GuiLabel lbl = new GuiLabel(this.field_146289_q, 47, this.field_146294_l / 2 - 114, this.field_146295_m / 2 - 90, 107, 13, 3976521);
        lbl.func_175202_a(I18n.func_135052_a((String)"teleportator.description.name", (Object[])new Object[0]));
        tab1.labels.add(lbl);
        this.tabsList.put(tab0.id, tab0);
        this.tabsList.put(tab1.id, tab1);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(FONT_TEXTURE);
        this.func_73729_b(this.field_146294_l / 2 - 128, this.field_146295_m / 2 - 128, 0, 0, 256, 256);
        GlStateManager.func_179084_k();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.currentTabId == 0) {
            GlStateManager.func_179147_l();
            this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
            float per = this.tp.getVisCount() / 500.0f;
            this.func_175174_a(this.field_146294_l / 2 + 82, (float)(this.field_146295_m / 2 - 70) + 48.0f * (1.0f - per), 186, 28, 8, (int)Math.ceil(48.0f * per));
            this.func_73729_b(this.field_146294_l / 2 + 81, this.field_146295_m / 2 - 74, 200, 24, 10, 56);
            GlStateManager.func_179084_k();
            this.func_73731_b(this.field_146289_q, Float.toString(this.tp.getVisCount()), this.field_146294_l / 2 + 79, this.field_146295_m / 2 - 85, 3976521);
            if (IFunctionLibrary.isPointInRegion(this.TpActive.field_146128_h, this.TpActive.field_146129_i, this.TpActive.field_146120_f, this.TpActive.field_146121_g, mouseX, mouseY)) {
                int m = 0;
                if (this.tp.getVisCount() >= 500.0f) {
                    m = 1;
                }
                this.func_146279_a(this.ActiveDescr.get(m), mouseX, mouseY);
            }
        } else if (this.currentTabId == 1) {
            // empty if block
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        int z;
        int y;
        int x;
        int dim;
        if (button.field_146127_k <= 1) {
            this.currentTabId = button.field_146127_k;
        }
        if (button.field_146127_k == 4) {
            this.name = IRandomNameGenerator.generateName(rd);
            this.nameField.func_146180_a(this.name);
            this.tp.setCustomName(this.name);
            dim = this.tp.func_145831_w().field_73011_w.getDimension();
            x = this.tp.func_174877_v().func_177958_n();
            y = this.tp.func_174877_v().func_177956_o();
            z = this.tp.func_174877_v().func_177952_p();
            NetworkHandler.sendToServer(new MessageServerTeleportatorName(new IWorldPos.worldPos(dim, x, y, z), this.name));
        }
        if (button.field_146127_k == 5) {
            this.name = this.nameField.func_146179_b();
            this.tp.setCustomName(this.name);
            dim = this.tp.func_145831_w().field_73011_w.getDimension();
            x = this.tp.func_174877_v().func_177958_n();
            y = this.tp.func_174877_v().func_177956_o();
            z = this.tp.func_174877_v().func_177952_p();
            NetworkHandler.sendToServer(new MessageServerTeleportatorName(new IWorldPos.worldPos(dim, x, y, z), this.name));
        }
        if (button.field_146127_k == 6) {
            IWorldPos.worldPos[] array = this.pos.keySet().toArray(new IWorldPos.worldPos[this.pos.size()]);
            if (((GuiDynamic.Tab)this.tabsList.get((Object)Integer.valueOf((int)0))).filterList.get(0).getChoosedButton() > -1) {
                if (this.tp.getVisCount() >= 500.0f) {
                    this.field_146297_k.func_147108_a(null);
                    NetworkHandler.sendToServer(new MessageServerTeleportatorActiveTp(this.tp, array[((GuiDynamic.Tab)this.tabsList.get((Object)Integer.valueOf((int)0))).filterList.get(0).getChoosedButton()]));
                }
            }
        }
    }
}

