/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.spinningwheel;

import com.ancient.thaumicgadgets.objects.machines.spinningwheel.SpinningWheelRecipes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySpinningWheel
extends TileEntity
implements IInventory,
ITickable {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private String customName;
    private int totalWorkTime;
    private int workTime;

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.spinning_wheel";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && index + 1 == 1 && !flag) {
            ItemStack stack1 = (ItemStack)this.inventory.get(index + 1);
            ItemStack stack2 = (ItemStack)this.inventory.get(index + 2);
            ItemStack stack3 = (ItemStack)this.inventory.get(index + 3);
            this.totalWorkTime = this.getWorkTime(stack, stack1, stack2, stack3);
            this.workTime = 0;
            this.func_70296_d();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("WorkTime", (int)((short)this.workTime));
        compound.func_74768_a("TotalWorkTime", (int)((short)this.totalWorkTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.workTime = compound.func_74762_e("WorkTime");
        this.totalWorkTime = compound.func_74762_e("TotalWorkTime");
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(compound.func_74779_i("CustomName"));
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isWorking() {
        return this.workTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isWorking(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public int getWorkTime(ItemStack input1, ItemStack input2, ItemStack input3, ItemStack input4) {
        return 200;
    }

    private boolean canWork() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b() || ((ItemStack)this.inventory.get(1)).func_190926_b() || ((ItemStack)this.inventory.get(2)).func_190926_b() || ((ItemStack)this.inventory.get(3)).func_190926_b()) {
            return false;
        }
        ItemStack result = SpinningWheelRecipes.getInstance().getWorkResult((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1), (ItemStack)this.inventory.get(2), (ItemStack)this.inventory.get(3));
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack output = (ItemStack)this.inventory.get(4);
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(result)) {
            return false;
        }
        int res = output.func_190916_E() + result.func_190916_E();
        return res <= this.func_70297_j_() && res <= output.func_77976_d();
    }

    public void craftItem() {
        if (this.canWork()) {
            ItemStack input1 = (ItemStack)this.inventory.get(0);
            ItemStack input2 = (ItemStack)this.inventory.get(1);
            ItemStack input3 = (ItemStack)this.inventory.get(2);
            ItemStack input4 = (ItemStack)this.inventory.get(3);
            ItemStack result = SpinningWheelRecipes.getInstance().getWorkResult(input1, input2, input3, input4);
            ItemStack output = (ItemStack)this.inventory.get(4);
            if (output.func_190926_b()) {
                this.inventory.set(4, (Object)result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            input1.func_190918_g(1);
            input2.func_190918_g(1);
            input3.func_190918_g(1);
            input4.func_190918_g(1);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 4;
    }

    public String getGuiID() {
        return "tg:spinning_wheel";
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.workTime;
            }
            case 1: {
                return this.totalWorkTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.workTime = value;
                break;
            }
            case 1: {
                this.totalWorkTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void func_73660_a() {
        boolean flag = this.isWorking();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            ItemStack item1 = (ItemStack)this.inventory.get(0);
            ItemStack item2 = (ItemStack)this.inventory.get(1);
            ItemStack item3 = (ItemStack)this.inventory.get(2);
            ItemStack item4 = (ItemStack)this.inventory.get(3);
            if (this.canWork()) {
                ++this.workTime;
                if (this.workTime == this.totalWorkTime) {
                    this.workTime = 0;
                    this.totalWorkTime = this.getWorkTime(item1, item2, item3, item4);
                    this.craftItem();
                    flag1 = true;
                }
            } else {
                this.workTime = 0;
            }
            if (flag == this.isWorking()) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }
}

