/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.spinningwheel;

import com.ancient.thaumicgadgets.init.ModItems;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;

public class SpinningWheelRecipes {
    private static final SpinningWheelRecipes INSTANCE = new SpinningWheelRecipes();
    private final Map<String, craftingRecepies> list = Maps.newHashMap();

    public static SpinningWheelRecipes getInstance() {
        return INSTANCE;
    }

    private SpinningWheelRecipes() {
        this.addSpinningWheelRecipe("tg:yarn", new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(ModItems.YARN), 5.0f);
        this.addSpinningWheelRecipe("tg:yarn_gold", new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151074_bl), new ItemStack(ModItems.YARN_GOLD), 5.0f);
        this.addSpinningWheelRecipe("tg:yarn_thanium", new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(ItemsTC.nuggets, 1, 6), new ItemStack(ModItems.YARN_THANIUM), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(ItemsTC.nuggets, 1, 8), new ItemStack(ModItems.YARN_MAGIC), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(ModItems.NUGGET_LIGHT), new ItemStack(ModItems.YARN_LIGHT), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(ModItems.NUGGET_SHADE), new ItemStack(ModItems.YARN_SHADE), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Item.func_150898_a((Block)BlocksTC.shimmerleaf)), new ItemStack(ModItems.YARN_ETHER), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(ItemsTC.nuggets, 1, 7), new ItemStack(ModItems.YARN_VOID), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(ModItems.YARN), new ItemStack(ModItems.YARN), new ItemStack(ModItems.YARN_GOLD), new ItemStack(ModItems.YARN_THANIUM), new ItemStack(ModItems.FABRIC_DECORATED), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(ModItems.YARN), new ItemStack(ModItems.YARN), new ItemStack(ModItems.YARN_THANIUM), new ItemStack(ModItems.YARN_MAGIC), new ItemStack(ItemsTC.fabric), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(ModItems.YARN_THANIUM), new ItemStack(ModItems.YARN_THANIUM), new ItemStack(ModItems.YARN_GOLD), new ItemStack(ModItems.YARN_MAGIC), new ItemStack(ModItems.FABRIC_ENCHANTED), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(ModItems.YARN_ETHER), new ItemStack(ModItems.YARN_MAGIC), new ItemStack(ModItems.YARN_LIGHT), new ItemStack(ModItems.YARN_LIGHT), new ItemStack(ModItems.FABRIC_LIGHT), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(ModItems.YARN_ETHER), new ItemStack(ModItems.YARN_MAGIC), new ItemStack(ModItems.YARN_SHADE), new ItemStack(ModItems.YARN_SHADE), new ItemStack(ModItems.FABRIC_SHADE), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(ModItems.YARN_GOLD), new ItemStack(ModItems.YARN_THANIUM), new ItemStack(ModItems.YARN_VOID), new ItemStack(ModItems.YARN_VOID), new ItemStack(ModItems.FABRIC_VOID), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(ModItems.YARN_ETHER), new ItemStack(ModItems.YARN_THANIUM), new ItemStack(ModItems.YARN_MAGIC), new ItemStack(ModItems.YARN_MAGIC), new ItemStack(ModItems.FABRIC_BEWITCHED), 5.0f);
        this.addSpinningWheelRecipe("tg:weaving", new ItemStack(ModItems.YARN_ETHER), new ItemStack(ModItems.YARN_LIGHT), new ItemStack(ModItems.YARN_SHADE), new ItemStack(ModItems.YARN_VOID), new ItemStack(ModItems.FABRIC_VOLATILE), 5.0f);
    }

    public void addSpinningWheelRecipe(String group, ItemStack input1, ItemStack input2, ItemStack input3, ItemStack input4, ItemStack result, float experience) {
        if (!result.func_190926_b()) {
            craftingRecepies recipe = new craftingRecepies(group, input1, input2, input3, input4, result, Float.valueOf(experience).floatValue());
            this.list.put(result.func_77977_a().toLowerCase(), recipe);
        }
    }

    public int getMaxRecipeCount() {
        return this.list.size();
    }

    public ItemStack getWorkResult(ItemStack input1, ItemStack input2, ItemStack input3, ItemStack input4) {
        for (Map.Entry<String, craftingRecepies> e : this.list.entrySet()) {
            craftingRecepies recipe = e.getValue();
            if (!this.compareItemStacks(input1, recipe.item1) || !this.compareItemStacks(input2, recipe.item2) || !this.compareItemStacks(input3, recipe.item3) || !this.compareItemStacks(input4, recipe.item4)) continue;
            return recipe.result;
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack item1, ItemStack item2) {
        return item2.func_77973_b() == item1.func_77973_b() && (item2.func_77960_j() == Short.MAX_VALUE || item2.func_77960_j() == item1.func_77960_j());
    }

    public Map<String, craftingRecepies> getDualWorkingList() {
        return this.list;
    }

    public float getWorkExperience(ItemStack output) {
        for (Map.Entry<String, craftingRecepies> e : this.list.entrySet()) {
            craftingRecepies recipe = e.getValue();
            if (!output.func_77969_a(recipe.result)) continue;
            return recipe.experience;
        }
        return 0.0f;
    }

    public class craftingRecepies {
        public String group;
        public ItemStack item1;
        public ItemStack item2;
        public ItemStack item3;
        public ItemStack item4;
        public ItemStack result;
        public float experience;

        public craftingRecepies(String group, ItemStack Item1, ItemStack Item2, ItemStack Item3, ItemStack Item4, ItemStack Result, float Experience) {
            this.group = group;
            this.item1 = Item1;
            this.item2 = Item2;
            this.item3 = Item3;
            this.item4 = Item4;
            this.result = Result;
            this.experience = Experience;
        }
    }
}

