/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.extruder;

import com.ancient.thaumicgadgets.util.handlers.EnumHandler;
import com.ancient.thaumicgadgets.util.handlers.ParticleSpawner;
import com.ancient.thaumicgadgets.util.handlers.RandomFunctions;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.lib.events.EssentiaHandler;

public class TileEntityExtruderUp
extends TileEntity
implements ITickable {
    private int workTime = 0;
    private int maxWorkTime;
    private int mode = 0;
    private final Map<Aspect, Integer> aspectList = Maps.newHashMap();
    private static final ParticleSpawner ps = ParticleSpawner.INSTANCE;

    public TileEntityExtruderUp() {
        this.maxWorkTime = this.getWorkTime();
        this.aspectList.put(Aspect.EARTH, 0);
        this.aspectList.put(Aspect.WATER, 0);
        this.aspectList.put(Aspect.FIRE, 0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("WorkTime", (int)((short)this.workTime));
        compound.func_74768_a("MaxWorkTime", (int)((short)this.maxWorkTime));
        compound.func_74768_a("Mode", this.mode);
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<Aspect, Integer> e : this.aspectList.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            compound.func_74778_a("aspect", e.getKey().getTag());
            compound.func_74768_a("count", e.getValue().intValue());
            tagList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("aspects", (NBTBase)tagList);
        return compound;
    }

    public boolean canWork() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.workTime = compound.func_74762_e("WorkTime");
        this.maxWorkTime = compound.func_74762_e("MaxWorkTime");
        this.mode = compound.func_74762_e("Mode");
        NBTTagList tagList = compound.func_150295_c("aspects", 10);
        this.aspectList.clear();
        for (int q = 0; q < tagList.func_74745_c(); ++q) {
            NBTTagCompound tag = tagList.func_150305_b(q);
            this.aspectList.put(Aspect.getAspect(compound.func_74779_i("aspect")), compound.func_74762_e("count"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isWorking(TileEntityExtruderUp ent) {
        return ent.getField(0) > 0;
    }

    public boolean isWorking() {
        return this.workTime > 0;
    }

    public int getWorkTime() {
        return 100;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.workTime;
            }
            case 1: {
                return this.maxWorkTime;
            }
            case 2: {
                return this.mode;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.workTime = value;
                break;
            }
            case 1: {
                this.maxWorkTime = value;
                break;
            }
            case 2: {
                this.mode = value;
            }
        }
    }

    public int getFieldCount() {
        return 3;
    }

    public void func_73660_a() {
        boolean flag = this.isWorking();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            int dim = this.field_145850_b.field_73011_w.getDimension();
            if (this.canWork()) {
                EnumFacing face;
                IBlockState state;
                if (this.mode == 2) {
                    if (this.aspectList.get(Aspect.EARTH) < 10 && EssentiaHandler.drainEssentia((TileEntity)this, (Aspect)Aspect.EARTH, null, (int)10, (int)1)) {
                        this.aspectList.replace(Aspect.EARTH, this.aspectList.get(Aspect.EARTH) + 1);
                    }
                    if (this.aspectList.get(Aspect.FIRE) < 10 && EssentiaHandler.drainEssentia((TileEntity)this, (Aspect)Aspect.FIRE, null, (int)10, (int)1)) {
                        this.aspectList.replace(Aspect.FIRE, this.aspectList.get(Aspect.FIRE) + 1);
                    }
                    if (this.aspectList.get(Aspect.WATER) < 10 && EssentiaHandler.drainEssentia((TileEntity)this, (Aspect)Aspect.WATER, null, (int)10, (int)1)) {
                        this.aspectList.replace(Aspect.WATER, this.aspectList.get(Aspect.WATER) + 1);
                    }
                    if (this.workTime >= this.maxWorkTime && this.aspectList.get(Aspect.EARTH) >= 10 && this.aspectList.get(Aspect.FIRE) >= 10 && this.aspectList.get(Aspect.WATER) >= 10) {
                        this.workTime = 0;
                        this.aspectList.replace(Aspect.EARTH, this.aspectList.get(Aspect.EARTH) - 10);
                        this.aspectList.replace(Aspect.FIRE, this.aspectList.get(Aspect.FIRE) - 10);
                        this.aspectList.replace(Aspect.WATER, this.aspectList.get(Aspect.WATER) - 10);
                        this.maxWorkTime = this.getWorkTime();
                        state = this.field_145850_b.func_180495_p(this.field_174879_c);
                        face = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                        EntityItem cobble = null;
                        switch (face) {
                            case NORTH: {
                                cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - 0.5, new ItemStack(this.getItemFromMode(this.mode), 1));
                                break;
                            }
                            case SOUTH: {
                                cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 1.5, new ItemStack(this.getItemFromMode(this.mode), 1));
                                break;
                            }
                            case EAST: {
                                cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 1.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack(this.getItemFromMode(this.mode), 1));
                                break;
                            }
                            case WEST: {
                                cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack(this.getItemFromMode(this.mode), 1));
                                break;
                            }
                        }
                        cobble.field_70159_w = 0.025;
                        cobble.field_70181_x = 0.075;
                        cobble.field_70179_y = 0.025;
                        RandomFunctions cfr_ignored_0 = TileEntityExtruderUp.ps.rf;
                        ps.transferData(EnumParticleTypes.LAVA, RandomFunctions.rand.nextInt(5) + 1, cobble.field_70165_t, cobble.field_70163_u, cobble.field_70161_v, dim);
                        RandomFunctions cfr_ignored_1 = TileEntityExtruderUp.ps.rf;
                        ps.transferData(EnumParticleTypes.SMOKE_NORMAL, RandomFunctions.rand.nextInt(5) + 1, cobble.field_70165_t, cobble.field_70163_u, cobble.field_70161_v, dim);
                        this.field_145850_b.func_72838_d((Entity)cobble);
                        flag1 = true;
                    }
                } else if (this.workTime >= this.maxWorkTime) {
                    this.workTime = 0;
                    this.maxWorkTime = this.getWorkTime();
                    state = this.field_145850_b.func_180495_p(this.field_174879_c);
                    face = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                    EntityItem cobble = null;
                    switch (face) {
                        case NORTH: {
                            cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - 0.5, new ItemStack(this.getItemFromMode(this.mode), 1));
                            break;
                        }
                        case SOUTH: {
                            cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 1.5, new ItemStack(this.getItemFromMode(this.mode), 1));
                            break;
                        }
                        case EAST: {
                            cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 1.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack(this.getItemFromMode(this.mode), 1));
                            break;
                        }
                        case WEST: {
                            cobble = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() - 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack(this.getItemFromMode(this.mode), 1));
                            break;
                        }
                    }
                    cobble.field_70159_w = 0.025;
                    cobble.field_70181_x = 0.075;
                    cobble.field_70179_y = 0.025;
                    RandomFunctions cfr_ignored_2 = TileEntityExtruderUp.ps.rf;
                    ps.transferData(EnumParticleTypes.LAVA, RandomFunctions.rand.nextInt(5) + 1, cobble.field_70165_t, cobble.field_70163_u, cobble.field_70161_v, dim);
                    RandomFunctions cfr_ignored_3 = TileEntityExtruderUp.ps.rf;
                    ps.transferData(EnumParticleTypes.SMOKE_NORMAL, RandomFunctions.rand.nextInt(5) + 1, cobble.field_70165_t, cobble.field_70163_u, cobble.field_70161_v, dim);
                    this.field_145850_b.func_72838_d((Entity)cobble);
                    flag1 = true;
                }
                ++this.workTime;
                state = this.field_145850_b.func_180495_p(this.field_174879_c);
                face = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                if (this.workTime % 7 == 0) {
                    ps.transferData(EnumHandler.CustomParticles.SMOKE, 1, (double)(this.field_174879_c.func_177958_n() + face.func_82601_c()), (double)this.field_174879_c.func_177956_o() + 0.8, (double)(this.field_174879_c.func_177952_p() + face.func_82599_e()), TileEntityExtruderUp.ps.rf.getRandomPartcileVelocity(0.02), 0.05, TileEntityExtruderUp.ps.rf.getRandomPartcileVelocity(0.02), dim);
                }
            } else {
                this.workTime = 0;
            }
            if (flag == this.isWorking()) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public Item getItemFromMode(int value) {
        switch (value) {
            case 0: {
                return Item.func_150898_a((Block)Blocks.field_150347_e);
            }
            case 1: {
                return Item.func_150898_a((Block)Blocks.field_150348_b);
            }
            case 2: {
                return Item.func_150898_a((Block)Blocks.field_150343_Z);
            }
        }
        return Item.func_150898_a((Block)Blocks.field_150347_e);
    }
}

