/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.blastfurnace;

import com.ancient.thaumicgadgets.Main;
import com.ancient.thaumicgadgets.init.ModItems;
import com.ancient.thaumicgadgets.objects.machines.blastfurnace.BlastFurnaceRecipes;
import com.ancient.thaumicgadgets.util.ICheckMultiBlock;
import com.ancient.thaumicgadgets.util.handlers.EnumHandler;
import com.ancient.thaumicgadgets.util.handlers.ParticleSpawner;
import com.ancient.thaumicgadgets.util.handlers.RandomFunctions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.lib.events.EssentiaHandler;

public class TileEntityBlastFurnace
extends TileEntity
implements ITickable {
    private int workTime = 0;
    private int maxWorkTime;
    private static final ParticleSpawner ps = ParticleSpawner.INSTANCE;
    private final Map<Aspect, Integer> aspectList = Maps.newHashMap();
    private final Map<ItemStack, Integer> inputs = Maps.newHashMap();
    private int essenceCount;

    public TileEntityBlastFurnace() {
        this.maxWorkTime = this.getWorkTime();
        this.aspectList.put(Aspect.FIRE, 0);
        this.essenceCount = 1;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("WorkTime", (int)((short)this.workTime));
        compound.func_74768_a("MaxWorkTime", (int)((short)this.maxWorkTime));
        compound.func_74768_a("Fire", this.aspectList.get(Aspect.FIRE).intValue());
        NBTTagList tList = new NBTTagList();
        for (Map.Entry<ItemStack, Integer> e : this.inputs.entrySet()) {
            NBTTagCompound compoundItem = new NBTTagCompound();
            ItemStack st = e.getKey();
            st.func_190920_e(e.getValue().intValue());
            compoundItem = st.serializeNBT();
            tList.func_74742_a((NBTBase)compoundItem);
        }
        compound.func_74782_a("inputs", (NBTBase)tList);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.workTime = compound.func_74762_e("WorkTime");
        this.maxWorkTime = compound.func_74762_e("MaxWorkTime");
        this.aspectList.clear();
        this.aspectList.put(Aspect.FIRE, compound.func_74762_e("Fire"));
        this.inputs.clear();
        NBTTagList tList = compound.func_150295_c("inputs", 10);
        if (tList.func_74745_c() > 0) {
            for (int q = 0; q < tList.func_74745_c(); ++q) {
                NBTTagCompound tC = tList.func_150305_b(q);
                ItemStack st = new ItemStack(tC);
                this.inputs.put(new ItemStack(st.func_77973_b(), 1, st.func_77960_j()), st.func_190916_E());
            }
        }
    }

    public boolean canWork() {
        return true;
    }

    public void findItem(TileEntityBlastFurnace te) {
        List players;
        double z;
        double y;
        double x = this.field_174879_c.func_177958_n();
        AxisAlignedBB scanAbove = new AxisAlignedBB(x, y = (double)this.field_174879_c.func_177956_o() + 1.0, z = (double)this.field_174879_c.func_177952_p(), x + 1.0, y + 1.0, z + 1.0);
        List entities = this.field_145850_b.func_72872_a(EntityItem.class, scanAbove);
        if (entities.size() > 0) {
            for (EntityItem i : entities) {
                ItemStack stack = i.func_92059_d();
                ItemStack check = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                if (this.inputs.containsKey(check)) {
                    this.inputs.replace(check, this.inputs.get(check) + stack.func_190916_E());
                } else {
                    this.inputs.put(check, stack.func_190916_E());
                }
                i.func_70106_y();
            }
        }
        if ((players = this.field_145850_b.func_72872_a(EntityPlayer.class, scanAbove)).size() > 0) {
            for (EntityPlayer pl : players) {
                pl.func_70015_d(5);
            }
        }
    }

    public int findBellows(TileEntityBlastFurnace te) {
        IBlockState state;
        EnumFacing face = te.field_145850_b.func_180495_p(te.field_174879_c).func_177228_b().containsKey((Object)BlockHorizontal.field_185512_D) ? (EnumFacing)te.field_145850_b.func_180495_p(te.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D) : EnumFacing.NORTH;
        int x = face.func_82601_c();
        int z = face.func_82599_e();
        int i = 0;
        if (x != 0) {
            state = te.field_145850_b.func_180495_p(new BlockPos(te.field_174879_c.func_177958_n() - 2, te.field_174879_c.func_177956_o(), te.field_174879_c.func_177952_p()));
            if (state.func_177230_c().equals(BlocksTC.bellows)) {
                ++i;
            }
            if ((state = te.field_145850_b.func_180495_p(new BlockPos(te.field_174879_c.func_177958_n() + 2, te.field_174879_c.func_177956_o(), te.field_174879_c.func_177952_p()))).func_177230_c().equals(BlocksTC.bellows)) {
                ++i;
            }
        } else {
            state = te.field_145850_b.func_180495_p(new BlockPos(te.field_174879_c.func_177958_n() + x * 2, te.field_174879_c.func_177956_o(), te.field_174879_c.func_177952_p()));
            if (state.func_177230_c().equals(BlocksTC.bellows)) {
                ++i;
            }
        }
        if (z != 0) {
            state = te.field_145850_b.func_180495_p(new BlockPos(te.field_174879_c.func_177958_n(), te.field_174879_c.func_177956_o(), te.field_174879_c.func_177952_p() + 2));
            if (state.func_177230_c().equals(BlocksTC.bellows)) {
                ++i;
            }
            if ((state = te.field_145850_b.func_180495_p(new BlockPos(te.field_174879_c.func_177958_n(), te.field_174879_c.func_177956_o(), te.field_174879_c.func_177952_p() - 2))).func_177230_c().equals(BlocksTC.bellows)) {
                ++i;
            }
        } else {
            state = te.field_145850_b.func_180495_p(new BlockPos(te.field_174879_c.func_177958_n(), te.field_174879_c.func_177956_o(), te.field_174879_c.func_177952_p() + z * 2));
            if (state.func_177230_c().equals(BlocksTC.bellows)) {
                ++i;
            }
        }
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isWorking(TileEntityBlastFurnace ent) {
        return ent.getField(0) > 0;
    }

    public boolean isWorking() {
        return this.workTime > 0;
    }

    public int getWorkTime() {
        return 80;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.workTime;
            }
            case 1: {
                return this.maxWorkTime;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.workTime = value;
                break;
            }
            case 1: {
                this.maxWorkTime = value;
            }
        }
    }

    public int getFieldCount() {
        return 2;
    }

    public void func_73660_a() {
        boolean flag = this.isWorking();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (!ICheckMultiBlock.checkMultiBlockStatic(this.field_145850_b, Main.MMB.getMultiBlockRecipeList().get((Object)EnumHandler.MultiBlocks.BLAST_FURNACE.getName()).recipe, this.field_174879_c)) {
                ICheckMultiBlock.demorphMultiBlockStatic(this.field_145850_b, Main.MMB.getMultiBlockRecipeList().get((Object)EnumHandler.MultiBlocks.BLAST_FURNACE.getName()).recipe, this.field_174879_c);
                return;
            }
            this.findItem(this);
            ArrayList<ItemStack> forRemove = new ArrayList<ItemStack>();
            for (Map.Entry<ItemStack, Integer> e : this.inputs.entrySet()) {
                if (e.getValue() != 0) continue;
                forRemove.add(e.getKey());
            }
            if (forRemove.size() > 0) {
                for (ItemStack st : forRemove) {
                    this.inputs.remove(st);
                }
                forRemove.clear();
            }
            int bellows = this.findBellows(this);
            if (this.aspectList.get(Aspect.FIRE) < this.essenceCount && EssentiaHandler.drainEssentia((TileEntity)this, (Aspect)Aspect.FIRE, null, (int)10, (int)1)) {
                this.aspectList.replace(Aspect.FIRE, this.aspectList.get(Aspect.FIRE) + 1);
            }
            if (bellows > 0) {
                float f = 1.0f + 0.33f * (float)(bellows + 1);
                this.maxWorkTime = Math.round((float)this.getWorkTime() / f);
            } else {
                this.maxWorkTime = this.getWorkTime();
            }
            if (this.aspectList.get(Aspect.FIRE) >= this.essenceCount) {
                this.maxWorkTime = Math.round((float)this.maxWorkTime * 0.75f);
            }
            if (!this.inputs.isEmpty()) {
                Object[] ks = this.inputs.keySet().toArray();
                RandomFunctions cfr_ignored_0 = TileEntityBlastFurnace.ps.rf;
                int rand = RandomFunctions.rand.nextInt(ks.length);
                ItemStack it = (ItemStack)ks[rand];
                it.func_190920_e(this.inputs.get(it).intValue());
                if (this.workTime >= this.maxWorkTime) {
                    this.workTime = 0;
                    if (this.aspectList.get(Aspect.FIRE) >= this.essenceCount) {
                        this.aspectList.replace(Aspect.FIRE, 0);
                    }
                    EnumFacing face = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                    ArrayList<EntityItem> output = new ArrayList<EntityItem>();
                    ArrayList<Object> result = new ArrayList();
                    if (BlastFurnaceRecipes.INSTANCE.hasWorkResult(it)) {
                        result = BlastFurnaceRecipes.INSTANCE.getWorkResult(it);
                    } else {
                        ItemStack temp = new ItemStack(ModItems.ASH, 3);
                        BlastFurnaceRecipes blastFurnaceRecipes = BlastFurnaceRecipes.INSTANCE;
                        blastFurnaceRecipes.getClass();
                        result.add(blastFurnaceRecipes.new BlastFurnaceRecipes.outPut(temp.func_77973_b(), temp.func_77960_j(), temp.func_190916_E()));
                        BlastFurnaceRecipes blastFurnaceRecipes2 = BlastFurnaceRecipes.INSTANCE;
                        blastFurnaceRecipes2.getClass();
                        result.add(blastFurnaceRecipes2.new BlastFurnaceRecipes.outPut(temp.func_77973_b(), temp.func_77960_j(), temp.func_190916_E()));
                    }
                    ItemStack st = (ItemStack)ks[rand];
                    this.inputs.replace(st, it.func_190916_E() - 1);
                    int q = 0;
                    switch (face) {
                        case NORTH: {
                            for (BlastFurnaceRecipes.outPut outPut2 : result) {
                                output.add(new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - 1.5, new ItemStack(((BlastFurnaceRecipes.outPut)result.get((int)q)).item, ((BlastFurnaceRecipes.outPut)result.get((int)q)).count, ((BlastFurnaceRecipes.outPut)result.get((int)q)).meta)));
                                ++q;
                            }
                            break;
                        }
                        case SOUTH: {
                            for (BlastFurnaceRecipes.outPut outPut3 : result) {
                                output.add(new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 2.5, new ItemStack(((BlastFurnaceRecipes.outPut)result.get((int)q)).item, ((BlastFurnaceRecipes.outPut)result.get((int)q)).count, ((BlastFurnaceRecipes.outPut)result.get((int)q)).meta)));
                                ++q;
                            }
                            break;
                        }
                        case EAST: {
                            for (BlastFurnaceRecipes.outPut outPut4 : result) {
                                output.add(new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 2.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack(((BlastFurnaceRecipes.outPut)result.get((int)q)).item, ((BlastFurnaceRecipes.outPut)result.get((int)q)).count, ((BlastFurnaceRecipes.outPut)result.get((int)q)).meta)));
                                ++q;
                            }
                            break;
                        }
                        case WEST: {
                            for (BlastFurnaceRecipes.outPut outPut5 : result) {
                                output.add(new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() - 1.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack(((BlastFurnaceRecipes.outPut)result.get((int)q)).item, ((BlastFurnaceRecipes.outPut)result.get((int)q)).count, ((BlastFurnaceRecipes.outPut)result.get((int)q)).meta)));
                                ++q;
                            }
                            break;
                        }
                    }
                    for (EntityItem entityItem : output) {
                        entityItem.field_70159_w = 0.025 * (double)face.func_82601_c();
                        entityItem.field_70181_x = 0.075;
                        entityItem.field_70179_y = 0.025 * (double)face.func_82599_e();
                        RandomFunctions cfr_ignored_1 = TileEntityBlastFurnace.ps.rf;
                        ps.transferData(EnumParticleTypes.EXPLOSION_NORMAL, RandomFunctions.rand.nextInt(5) + 1, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, entityItem.field_71093_bK);
                        RandomFunctions cfr_ignored_2 = TileEntityBlastFurnace.ps.rf;
                        ps.transferData(EnumParticleTypes.SMOKE_NORMAL, RandomFunctions.rand.nextInt(5) + 1, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, entityItem.field_71093_bK);
                        this.field_145850_b.func_72838_d((Entity)entityItem);
                    }
                    flag1 = true;
                }
                ++this.workTime;
            } else {
                this.workTime = 0;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }
}

